import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./FilterList-CWxGcEKk.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Scores",
  __ssrInlineRender: true,
  props: {
    scores: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.customer_club_scores")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_scores"))}</div>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        filters: {
          increase: _ctx.$t("messages.word.increase"),
          decrease: _ctx.$t("messages.word.decrease")
        }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.score"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.description"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.scores.data, (score) => {
        _push(`<tr><td>`);
        if (score.type == "increase") {
          _push(`<span class="text-success fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.increase"))}</span>`);
        } else if (score.type == "decrease") {
          _push(`<span class="text-danger fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.decrease"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(score.get_formatted_score)}</td><td class="fs-8">${ssrInterpolate(score.description)}</td><td class="lts-05 fs-8">${ssrInterpolate(score.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.scores.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.scores.links
      }, null, _parent));
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/CustomerClub/Scores.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
