import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Sent",
  __ssrInlineRender: true,
  props: {
    consignments: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.sent_orders")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.sent"),
        item: _ctx.$t("messages.word.orders")
      }, null, _parent));
      _push(`<div class="orders-list list"><div class="card"><div class="card-body"><div class="orders">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.consignment_uuid") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1100px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.send_date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.consignments.data, (consignment) => {
        _push(`<tr><td>${ssrInterpolate(consignment.send_type == "direct" ? consignment["order_uuid"] : consignment.uuid)}</td><td>`);
        if (consignment.status == "sent_to_main_storage") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_main_storage"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (consignment.status == "direct_sent_to_customer") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.direct_sent_to_customer"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(consignment.jalali_updated_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "150px" })}">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.orders.show", consignment.id),
          as: "button",
          class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.details"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.details")) + " ", 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.consignments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.consignments.links
      }, null, _parent));
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Orders/Sent.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
