import { defineComponent, ref, watch, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderAttr, ssrRenderList, ssrRenderComponent, ssrIncludeBooleanAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, Link } from "@inertiajs/vue3";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import { u as useNumberFormat } from "../ssr.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./NumInput-Bt6uFGO4.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Shiping",
  __ssrInlineRender: true,
  props: {
    places: {},
    addresses: {},
    selectedAddress: {},
    sepratedConsignments: {},
    itemsCount: {},
    financial: {},
    customerClubScore: {},
    paymentMeta: {}
  },
  setup(__props) {
    const props = __props;
    const selectedState = ref();
    const states = ref([]);
    for (let state in props.places) {
      states.value.push(state);
    }
    const selectedCity = ref();
    const cities = ref([]);
    watch(selectedState, (value) => {
      cities.value = [];
      if (selectedState.value != null) {
        for (let city of props.places[selectedState.value]) {
          cities.value.push(city);
        }
      }
    });
    const Map = ref();
    const MapEdit = ref();
    const createMapReset = ref(254896);
    const createAddressForm = useForm({
      first_name: null,
      last_name: null,
      state: selectedState.value,
      city: selectedCity.value,
      phone: "",
      postal_code: "",
      full_address: null,
      map: { longitude: 54.36281969540723, latitude: 32.69672648316882, zoom: 4.7, selected: false }
    });
    const mapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        createAddressForm.full_address = event.apiData.formatted_address;
        createAddressForm.map.longitude = event.coords[0];
        createAddressForm.map.latitude = event.coords[1];
        createAddressForm.map.zoom = (_a = Map.value) == null ? void 0 : _a.state.zoom;
        createAddressForm.map.selected = true;
      }
    };
    const editMapReset = ref(658963);
    ref();
    const editAddressForm = useForm({
      first_name: "",
      last_name: "",
      state: "",
      city: "",
      phone: "",
      postal_code: "",
      full_address: "",
      map: { longitude: 54.36281969540723, latitude: 32.69672648316882, zoom: 4.7, selected: false }
    });
    const editMapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        editAddressForm.full_address = event.apiData.formatted_address;
        editAddressForm.map = {
          longitude: event.coords[0],
          latitude: event.coords[1],
          zoom: (_a = MapEdit.value) == null ? void 0 : _a.state.zoom,
          selected: true
        };
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container" }, _attrs))}><div class="row"><div class="col-xl-9 col-lg-8 mb-3"><div class="card shadow-1 cart address-container mb-4"><div class="card-body"><div class="send-address-title">${ssrInterpolate(_ctx.$t("messages.sentence.choose_order_delivery_address"))}:</div><ul class="nav nav-tabs" role="tablist"><li class="nav-item" role="presentation"><button class="${ssrRenderClass({ "nav-link lts-05": true, active: _ctx.selectedAddress == null || _ctx.selectedAddress.type == "user" })}" id="your-address-tab" data-bs-toggle="tab" data-bs-target="#your-address-tab-pane" type="button" role="tab" aria-controls="your-address-tab-pane"${ssrRenderAttr("aria-selected", _ctx.selectedAddress == null || _ctx.selectedAddress.type == "user")}>${ssrInterpolate(_ctx.$t("messages.sentence.your_addresses"))}</button></li><li class="nav-item" role="presentation"><button class="${ssrRenderClass({ "nav-link lts-05": true, active: _ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop" })}" id="we-addresses-tab" data-bs-toggle="tab" data-bs-target="#we-addresses-tab-pane" type="button" role="tab" aria-controls="we-addresses-tab-pane"${ssrRenderAttr("aria-selected", _ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop")}>${ssrInterpolate(_ctx.$t("messages.sentence.reception_centers_addresses"))}</button></li></ul><div class="tab-content"><div class="${ssrRenderClass({ "tab-pane fade": true, "show active": _ctx.selectedAddress == null || _ctx.selectedAddress.type == "user" })}" id="your-address-tab-pane" role="tabpanel" aria-labelledby="your-address-tab" tabindex="0"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.addresses, (address) => {
        _push(`<div class="${ssrRenderClass({
          "col-xl-3": true,
          "col-lg-4": true,
          "col-md-6": true,
          "user-address-item": true,
          "active-address": _ctx.selectedAddress != null && _ctx.selectedAddress.type == "user" && _ctx.selectedAddress.address.id == address.id
        })}"${ssrRenderAttr("data-address", address.id)}><div class="custom-radio-box"><label class="custom-radio-box-label"${ssrRenderAttr(
          "data-placeholder",
          _ctx.selectedAddress != null && _ctx.selectedAddress.type == "user" && _ctx.selectedAddress.address.id == address.id ? _ctx.$t("messages.word.selected") : _ctx.$t("messages.sentence.select_this_address")
        )}><span class="d-block user-address-recipient mb-2">${ssrInterpolate(address.state + ", " + address.city)}</span><span class="d-block user-contact-items mb-3"><span class="user-contact-item"><span class="value full-address lts-05">${ssrInterpolate(address.full_address)}</span></span><span class="user-contact-item"><i class="ri-phone-line icon"></i><span class="value">${ssrInterpolate(address.phone)}</span></span><span class="user-contact-item"><i class="ri-user-line icon"></i><span class="value">${ssrInterpolate(address.first_name + " " + address.last_name)}</span></span></span><span class="d-flex align-items-center justify-content-end"><a href="javascript:void(0)" class="link border-bottom-0 fs-7 fw-bold" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#delete-address-" + address.id)}>${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a><span class="divider mx-2">|</span><a href="javascript:void(0)" class="link border-bottom-0 fs-7 fw-bold" data-bs-toggle="modal" data-bs-target="#editAddressModal">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></span>`);
        _push(ssrRenderComponent(unref(Link), {
          type: "button",
          class: "change-active-button",
          href: _ctx.route("cart.shiping.update"),
          data: { type: "user", address_id: address.id },
          as: "button",
          method: "post",
          "preserve-scroll": true,
          "preserve-state": false
        }, null, _parent));
        _push(`</label></div><div class="modal fade"${ssrRenderAttr("id", "delete-address-" + address.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_this_address"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer"><input type="hidden" name="address_id" value="">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("cart.shiping.delete_address", address.id),
          method: "delete",
          as: "button",
          type: "button",
          "data-bs-dismiss": "modal",
          "preserve-state": false,
          "aria-label": "Close",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div></div></div>`);
      });
      _push(`<!--]--><div class="modal fade" id="editAddressModal" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_address"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="address-bar-map-message col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_185521"))}</p></div><div class="col-md-6 add-address-container"><div class="row"><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaFirstName" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).first_name)} type="text" id="eaFirstName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.name"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaLastName" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_lastname"))}</label><input${ssrRenderAttr("value", unref(editAddressForm).last_name)} type="text" id="eaLastName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.lastname"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><span class="label d-block required-field fs-8 mb-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}</span>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: selectedState.value,
        "onUpdate:modelValue": ($event) => selectedState.value = $event,
        options: states.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_state"),
        emptyMessage: _ctx.$t("messages.sentence.no_items_found"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><span class="label d-block required-field fs-8 mb-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}</span>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: selectedCity.value,
        "onUpdate:modelValue": ($event) => selectedCity.value = $event,
        options: cities.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_city"),
        emptyMessage: _ctx.$t("messages.sentence.please_select_state_first"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPhone" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(editAddressForm).phone,
        "onUpdate:modelValue": ($event) => unref(editAddressForm).phone = $event,
        type: "text",
        id: "eaPhone",
        minlength: "11",
        maxlength: "11",
        class: "form-control",
        placeholder: "ex: 09123456789"
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="eaPostalCode" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(editAddressForm).postal_code,
        "onUpdate:modelValue": ($event) => unref(editAddressForm).postal_code = $event,
        type: "text",
        id: "eaPostalCode",
        minlength: "10",
        maxlength: "10",
        class: "form-control",
        placeholder: _ctx.$t("messages.sentence.must_10digit_no_line")
      }, null, _parent));
      _push(`<span class="form-control-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_40548051"))}</span></div></div><div class="col-12 mb-3"><div class="form-element-row"><label for="eaFullAddress" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea type="text" id="eaFullAddress" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))}>${ssrInterpolate(unref(editAddressForm).full_address)}</textarea></div></div></div></div><div class="address-bar-map-container col-md-6 mb-4"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "MapEdit",
        ref: MapEdit,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(editAddressForm).map,
        zoom: unref(editAddressForm).map.zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        onOnClick: editMapResult,
        class: "map",
        key: editMapReset.value
      }, null, _parent));
      _push(`</div></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(editAddressForm).processing) ? " disabled" : ""} data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="col-xl-3 col-lg-4 col-md-6 user-address-item user-add-address-container"><div class="user-add-address--box" data-bs-toggle="modal" data-bs-target="#addAddressModal"><i class="ri-add-line"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.add_new_address"))}</span></div><div class="modal fade" id="addAddressModal" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content"><form><div class="modal-header pb-1"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_new_address"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="address-bar-map-message col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_185521"))}</p></div><div class="col-md-6 add-address-container"><div class="row"><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="crFirstName" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).first_name)} type="text" id="crFirstName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.name"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="crLastName" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_lastname"))}</label><input${ssrRenderAttr("value", unref(createAddressForm).last_name)} type="text" id="crLastName" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.lastname"))}></div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><span class="label d-block required-field fs-8 mb-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}</span>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: selectedState.value,
        "onUpdate:modelValue": ($event) => selectedState.value = $event,
        options: states.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_state"),
        emptyMessage: _ctx.$t("messages.sentence.no_items_found"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><span class="label d-block required-field fs-8 mb-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}</span>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: selectedCity.value,
        "onUpdate:modelValue": ($event) => selectedCity.value = $event,
        options: cities.value,
        display: "chip",
        filter: "",
        appendTo: "self",
        placeholder: _ctx.$t("messages.sentence.select_city"),
        emptyMessage: _ctx.$t("messages.sentence.please_select_state_first"),
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found")
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="crPhone" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(createAddressForm).phone,
        "onUpdate:modelValue": ($event) => unref(createAddressForm).phone = $event,
        type: "text",
        id: "crPhone",
        minlength: "11",
        maxlength: "11",
        class: "form-control",
        placeholder: "ex: 09123456789"
      }, null, _parent));
      _push(`</div></div><div class="col-lg-6 mb-3"><div class="form-element-row"><label for="crPostalCode" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(createAddressForm).postal_code,
        "onUpdate:modelValue": ($event) => unref(createAddressForm).postal_code = $event,
        type: "text",
        id: "crPostalCode",
        minlength: "10",
        maxlength: "10",
        class: "form-control",
        placeholder: _ctx.$t("messages.sentence.must_10digit_no_line")
      }, null, _parent));
      _push(`<span class="form-control-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_40548051"))}</span></div></div><div class="col-12 mb-3"><div class="form-element-row"><label for="crFullAddress" class="label required-field fs-7">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea type="text" id="crFullAddress" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))}>${ssrInterpolate(unref(createAddressForm).full_address)}</textarea></div></div></div></div><div class="address-bar-map-container col-md-6 mb-4"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "Map",
        ref: Map,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(createAddressForm).map,
        zoom: unref(createAddressForm).map.zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        onOnClick: mapResult,
        class: "map",
        key: createMapReset.value
      }, null, _parent));
      _push(`</div></div></div></div><div class="modal-footer pt-0"><button${ssrIncludeBooleanAttr(unref(createAddressForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_address"))}</button></div></form></div></div></div></div></div></div><div class="${ssrRenderClass({ "tab-pane fade": true, "show active": _ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop" })}" id="we-addresses-tab-pane" role="tabpanel" aria-labelledby="we-addresses-tab" tabindex="0"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.paymentMeta.get_reception_centers_addresses, (address, index) => {
        _push(`<div class="${ssrRenderClass({
          "col-xl-3": true,
          "col-lg-4": true,
          "col-md-6": true,
          "user-address-item": true,
          "active-address": _ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop" && _ctx.selectedAddress.address.id == index
        })}"><div class="custom-radio-box"><label class="custom-radio-box-label"${ssrRenderAttr(
          "data-placeholder",
          _ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop" && _ctx.selectedAddress.address.id == index ? _ctx.$t("messages.word.selected") : _ctx.$t("messages.sentence.select_this_address")
        )}><span class="d-block user-address-recipient mb-2">${ssrInterpolate(address.state + ", " + address.city)}</span><span class="d-block user-contact-items user-contact-items--wecenter"><span class="user-contact-item"><span class="value full-address lts-05">${ssrInterpolate(address.full_address)}</span></span><span class="user-contact-item"><span class="fs-9 me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}:</span><span class="value">${ssrInterpolate(address.postal_code)}</span></span><span class="user-contact-item"><i class="ri-phone-line icon"></i><span class="value">${ssrInterpolate(address.phone)}</span></span><span class="user-contact-item"><span class="value receive-guide lts-05" data-bs-toggle="tooltip" data-bs-placement="bottom"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.msg_id_111256"))}><i class="ri-question-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.how_to_get"))}</span></span></span>`);
        _push(ssrRenderComponent(unref(Link), {
          type: "button",
          class: "change-active-button",
          href: _ctx.route("cart.shiping.update"),
          data: { type: "shop", address_id: index },
          as: "button",
          method: "post",
          "preserve-scroll": true,
          "preserve-state": false
        }, null, _parent));
        _push(`</label></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div><div class="consignment-container">`);
      if (((_a = _ctx.sepratedConsignments.main) == null ? void 0 : _a.items.length) > 0) {
        _push(`<div class="card shadow-1 consignments"><div class="card-body"><div class="consignment"><div class="main-title d-flex align-items-center mb-3"><img${ssrRenderAttr("src", _ctx.$page.props.appFavicon != null ? _ctx.$page.props.appFavicon : _ctx.$page.props.appUrl + "/img/temp/store-logo.png")}${ssrRenderAttr("alt", _ctx.$page.props.appName)} loading="lazy"><div class="d-flex flex-column justify-content-center ms-3"><span class="fw-light fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_item_number_", { number: "1" }))}</span><span class="fw-bold lts-05 text-dark"><span>${ssrInterpolate(_ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop" ? _ctx.$t("messages.sentence.receive_in_person_from") : _ctx.$t("messages.sentence.send_by"))}</span><span class="ms-1">${ssrInterpolate(_ctx.$page.props.appName)}</span><span class="fs-9 text-gray fw-light badge bg-light ms-1">${ssrInterpolate(_ctx.sepratedConsignments.main.items.length + " " + _ctx.$t("messages.word.ware"))}</span></span></div></div>`);
        if (_ctx.sepratedConsignments.main.send_method != null && _ctx.sepratedConsignments.main.send_method["type"] == "post") {
          _push(`<div class="send-time mb-3"><span class="d-inline-flex lts-05 alert alert-light text-dark m-0 mb-2 me-2">${ssrInterpolate(_ctx.sepratedConsignments.main.send_method["item"]["sendPeriod"])}</span>`);
          if (_ctx.sepratedConsignments.main.send_method["item"]["uuid"] == "paskeraye") {
            _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0">${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
          } else if (_ctx.sepratedConsignments.main.freeSend) {
            _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0"><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.word.free"))}</span></span>`);
          } else {
            _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0"><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.sepratedConsignments.main.sendPrice))} <span class="unit unit-sm"></span></span></span>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="row align-items-center"><div class="col-auto pe-0"><ul class="consignment-items ps-0"><!--[-->`);
        ssrRenderList(_ctx.sepratedConsignments.main.items, (item, i) => {
          _push(`<li class="item item-full"><div class="thumbnail">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", item.product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.title)} loading="lazy"${_scopeId}>`);
              } else {
                return [
                  createVNode("img", {
                    src: item.product.get_images[0]["link"],
                    alt: item.product.title,
                    loading: "lazy"
                  }, null, 8, ["src", "alt"])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><div class="body d-flex flex-column justify-content-center"><h4 class="mb-2">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", item.product.slug),
            class: "link fs-8 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(item.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(item.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h4><ul class="mb-2">`);
          if (item.get_props.length > 0) {
            _push(`<div class="cart-item--data"><ul><!--[-->`);
            ssrRenderList(item.get_props, (prop, i2) => {
              _push(`<li class="mb-0" style="${ssrRenderStyle({ "vertical-align": "middle" })}">`);
              if (prop.type == "color") {
                _push(`<div class="cart-item--variant">`);
                if (prop.value["image"] != null) {
                  _push(`<span class="shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "15px", "height": "15px" })}"><img${ssrRenderAttr("src", prop.value["image"])} alt="رنگ"></span>`);
                } else {
                  _push(`<span class="color" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span>`);
                }
                _push(`<span class="color-name lts-05 ms-1">${ssrInterpolate(prop.value["label"])}</span></div>`);
              } else {
                _push(`<div class="d-inline-flex align-items-center ms-2">`);
                if (prop.type == "warranty") {
                  _push(`<i class="ri-shield-check-fill"></i>`);
                } else {
                  _push(`<i class="ri-focus-line"></i>`);
                }
                _push(`<span class="lts-05 ms-1">${ssrInterpolate(prop.name + ": " + prop.value)}</span></div>`);
              }
              _push(`</li>`);
            });
            _push(`<!--]--></ul></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</ul><div class="cart-item--price fa-num"><div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span><span class="unit unit-sm"></span></div>`);
          if (item.discount > 0) {
            _push(`<div class="cart-item--discount ms-3"><del>${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count + item.price * item.count))}</del><span class="unit-red unit-sm"></span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div></li>`);
        });
        _push(`<!--]--></ul></div>`);
        if (_ctx.selectedAddress != null) {
          _push(`<div class="col-auto">`);
          if (_ctx.selectedAddress.type == "user") {
            _push(`<div class="time-and-send-container"><div class="send-address-title fs-8 mt-0">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}:</div><div class="radio-send-method"><div class="row"><!--[-->`);
            ssrRenderList(_ctx.sepratedConsignments.main.get_post_ways, (method, index) => {
              _push(`<!--[-->`);
              if (method.status) {
                _push(`<div class="${ssrRenderClass({
                  "custom-radio col-auto": true,
                  "custom-radio--active": _ctx.sepratedConsignments.main.send_method != null && _ctx.sepratedConsignments.main.send_method["item"]["uuid"] == method.uuid
                })}"><div class="inner">`);
                _push(ssrRenderComponent(unref(Link), {
                  href: _ctx.route("cart.shiping.update"),
                  method: "post",
                  data: { type: "main", consignment_uuid: _ctx.sepratedConsignments.main.uuid, send_method_uuid: method.uuid },
                  as: "button",
                  class: "custom-radio-label white-space-nowrap",
                  "preserve-scroll": true,
                  "preserve-state": false
                }, {
                  default: withCtx((_, _push2, _parent2, _scopeId) => {
                    if (_push2) {
                      _push2(`<span class="label pe-2"${_scopeId}><span class="detail"${_scopeId}><span class="title lts-05"${_scopeId}>${ssrInterpolate(method.name)}</span><span class="subtitle lts-05"${_scopeId}>${ssrInterpolate(method.description)}</span></span></span>`);
                    } else {
                      return [
                        createVNode("span", { class: "label pe-2" }, [
                          createVNode("span", { class: "detail" }, [
                            createVNode("span", { class: "title lts-05" }, toDisplayString(method.name), 1),
                            createVNode("span", { class: "subtitle lts-05" }, toDisplayString(method.description), 1)
                          ])
                        ])
                      ];
                    }
                  }),
                  _: 2
                }, _parent));
                _push(`</div></div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<!--]-->`);
            });
            _push(`<!--]--></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="col-auto"><div class="time-and-send-container"><div class="send-address-title fs-8 mt-0">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}:</div><div class="d-flex w-100"><span class="text-dark lts-05 d-block mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.please_first_select_any_address"))}</span></div></div></div>`);
        }
        _push(`</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.sepratedConsignments, (consignment, key) => {
        _push(`<!--[-->`);
        if (key !== "main") {
          _push(`<div class="card shadow-1 consignments"><div class="card-body"><div class="consignment"><div class="main-title d-flex align-items-center mb-3"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/temp/store-logo.png")}${ssrRenderAttr("alt", consignment.store.name)} loading="lazy"><div class="d-flex flex-column justify-content-center ms-3"><span class="fw-light fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_item_number_", { number: String(Number(key) + ("main" in _ctx.sepratedConsignments ? 2 : 1)) }))}</span><span class="fw-bold lts-05 text-dark"><span>${ssrInterpolate(_ctx.$t("messages.sentence.send_by_seller"))}: `);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.stores.show", consignment.store.uuid),
            class: "link ms-1"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(consignment.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(consignment.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</span><span class="fs-9 text-gray fw-light badge bg-light ms-1">${ssrInterpolate(consignment.items.length + " ‌ ‌" + _ctx.$t("messages.word.ware"))}</span></span></div></div>`);
          if (consignment.send_method != null && consignment.send_method["type"] == "post") {
            _push(`<div class="send-time mb-3"><span class="d-inline-flex lts-05 alert alert-light text-dark m-0 mb-2 me-2">${ssrInterpolate(consignment.send_method["item"]["sendPeriod"])}</span>`);
            if (consignment.send_method["item"]["uuid"] == "paskeraye") {
              _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0">${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
            } else if (consignment.freeSend) {
              _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0"><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.word.free"))}</span></span>`);
            } else {
              _push(`<span class="d-inline-flex lts-05 alert alert-light text-dark m-0"><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(consignment.sendPrice))} <span class="unit unit-sm"></span></span></span>`);
            }
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="row align-items-center"><div class="col-auto pe-0"><ul class="consignment-items ps-0"><!--[-->`);
          ssrRenderList(consignment.items, (item, i) => {
            _push(`<li class="item item-full"><div class="thumbnail">`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.products.show", item.product.slug)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<img${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.title)} loading="lazy"${_scopeId}>`);
                } else {
                  return [
                    createVNode("img", {
                      src: item.product.get_images[0]["link"],
                      alt: item.product.title,
                      loading: "lazy"
                    }, null, 8, ["src", "alt"])
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div><div class="body d-flex flex-column justify-content-center"><h4 class="mb-2">`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.products.show", item.product.slug),
              class: "link fs-8 lts-05"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(item.product.title)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(item.product.title), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</h4><ul class="mb-2">`);
            if (item.get_props.length > 0) {
              _push(`<div class="cart-item--data"><ul><!--[-->`);
              ssrRenderList(item.get_props, (prop, i2) => {
                _push(`<li class="mb-0">`);
                if (prop.type == "color") {
                  _push(`<div class="cart-item--variant"><span class="color" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span><span class="color-name lts-05 ms-1">${ssrInterpolate(prop.value["label"])}</span></div>`);
                } else {
                  _push(`<div class="d-inline-flex align-items-center ms-2">`);
                  if (prop.type == "warranty") {
                    _push(`<i class="ri-shield-check-fill"></i>`);
                  } else {
                    _push(`<i class="ri-focus-line"></i>`);
                  }
                  _push(`<span class="lts-05 ms-1">${ssrInterpolate(prop.name + ": " + prop.value)}</span></div>`);
                }
                _push(`</li>`);
              });
              _push(`<!--]--></ul></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</ul><div class="cart-item--price fa-num"><div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span><span class="unit unit-sm"></span></div>`);
            if (item.discount > 0) {
              _push(`<div class="cart-item--discount ms-3"><del>${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count + item.price * item.count))}</del><span class="unit-red unit-sm"></span></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div></li>`);
          });
          _push(`<!--]--></ul></div>`);
          if (_ctx.selectedAddress != null) {
            _push(`<div class="col-auto">`);
            if (_ctx.selectedAddress.type == "user") {
              _push(`<div class="time-and-send-container"><div class="send-address-title fs-8 mt-0">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}:</div><div class="radio-send-method"><div class="row"><!--[-->`);
              ssrRenderList(consignment.get_post_ways, (method, index) => {
                _push(`<!--[-->`);
                if (method.status) {
                  _push(`<div class="${ssrRenderClass({
                    "custom-radio col-auto": true,
                    "custom-radio--active": consignment.send_method != null && consignment.send_method["item"]["uuid"] == method.uuid
                  })}"><div class="inner">`);
                  _push(ssrRenderComponent(unref(Link), {
                    href: _ctx.route("cart.shiping.update"),
                    method: "post",
                    data: { type: "direct", consignment_uuid: consignment.uuid, send_method_uuid: method.uuid },
                    as: "button",
                    class: "custom-radio-label white-space-nowrap",
                    "preserve-scroll": true,
                    "preserve-state": false
                  }, {
                    default: withCtx((_, _push2, _parent2, _scopeId) => {
                      if (_push2) {
                        _push2(`<span class="label pe-2"${_scopeId}><span class="detail"${_scopeId}><span class="title lts-05"${_scopeId}>${ssrInterpolate(method.name)}</span><span class="subtitle lts-05"${_scopeId}>${ssrInterpolate(method.description)}</span></span></span>`);
                      } else {
                        return [
                          createVNode("span", { class: "label pe-2" }, [
                            createVNode("span", { class: "detail" }, [
                              createVNode("span", { class: "title lts-05" }, toDisplayString(method.name), 1),
                              createVNode("span", { class: "subtitle lts-05" }, toDisplayString(method.description), 1)
                            ])
                          ])
                        ];
                      }
                    }),
                    _: 2
                  }, _parent));
                  _push(`</div></div>`);
                } else {
                  _push(`<!---->`);
                }
                _push(`<!--]-->`);
              });
              _push(`<!--]--></div></div></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          } else {
            _push(`<div class="col-auto"><div class="time-and-send-container"><div class="send-address-title fs-8 mb-3 mt-0">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}:</div><div class="d-flex w-100"><span class="text-dark lts-05 d-block mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.please_first_select_any_address"))}</span></div></div></div>`);
          }
          _push(`</div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div><div class="col-xl-3 col-lg-4 mb-3"><div class="cart-sidebar"><div class="card shadow-1 mb-3"><div class="card-body"><div class="checkout"><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_prices"))} (${ssrInterpolate(_ctx.itemsCount)})</div><div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalPrice))}</span><span class="unit unit-sm"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_discounts"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalDiscount))}</span><span class="unit-red unit-sm"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}</div>`);
      if (_ctx.selectedAddress != null && _ctx.selectedAddress.type == "user") {
        _push(`<!--[-->`);
        if (Object.keys(_ctx.sepratedConsignments).length === 1 && Object.keys(_ctx.sepratedConsignments).includes("main")) {
          _push(`<!--[-->`);
          if (_ctx.sepratedConsignments.main.send_method != null && _ctx.sepratedConsignments.main.send_method["type"] == "post" && _ctx.sepratedConsignments.main.send_method["item"]["uuid"] == "paskeraye") {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span></div>`);
          } else if (_ctx.sepratedConsignments.main.freeSend) {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.word.free"))}</span></div>`);
          } else {
            _push(`<div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.sendPrice))}</span><span class="unit unit-sm"></span></div>`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.sendPrice))}</span><span class="unit unit-sm"></span></div>`);
        }
        _push(`<!--]-->`);
      } else if (_ctx.selectedAddress != null && _ctx.selectedAddress.type == "shop") {
        _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.receive_in_person"))}</span></div>`);
      } else {
        _push(`<div class="checkout-row-value lts-05"><span class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.please_choose"))}</span></div>`);
      }
      _push(`</div></div></div></div><div class="card shadow-1 mb-3"><div class="card-body"><div class="checkout"><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cart_total_pay_price"))}</div><div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.financial.totalFinalPrice))}</span><span class="unit unit-sm"></span></div></div><div class="checkout-row checkout-action">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("cart.payment"),
        type: "button",
        class: "btn btn-block btn-primary lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.order_registration"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.order_registration")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="checkout-row checkout-footer"><div class="checkout-row-label lts-05"><span class="d-flex"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.customerClubScore))}</span> <span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div></div></div>`);
      if (_ctx.$page.props.payment_meta.free_post_min_price > 0) {
        _push(`<div class="card shadow-1 mb-3"><div class="send-free card-body"><div class="title"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_free_send"))}</div><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_above_price", { price: _ctx.$page.props.payment_meta.get_formatted_free_post_min_price }))}</span></div><i class="ri-truck-line"></i></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Cart/Shiping.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
