import { defineComponent, unref, useSSRContext, mergeProps, withCtx, createTextVNode, toDisplayString, ref, computed, onMounted, onUnmounted, inject, nextTick, createBlock, openBlock, createVNode, mergeModels, useModel, resolveComponent, watch, reactive, resolveDynamicComponent, createCommentVNode, isRef } from "vue";
import { ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrRenderStyle, ssrRenderAttrs, ssrRenderComponent, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual, ssrRenderVNode } from "vue/server-renderer";
import { _ as _sfc_main$o } from "./MainLayout-CahYFWjG.js";
import { Link, router, useForm, usePage, Head } from "@inertiajs/vue3";
import Debounce from "lodash/debounce.js";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { wTrans, trans } from "laravel-vue-i18n";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import { u as useNumberFormat, _ as _export_sfc, e as useCountdownTimer } from "../ssr.js";
import { _ as _sfc_main$l } from "./LineChart-CIYq_-2s.js";
import { _ as _sfc_main$m } from "./NumInput-Bt6uFGO4.js";
import "toastify-js";
import { _ as _sfc_main$n } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "swiper";
import "chart.js/auto";
const useMinObject = (object, attr) => {
  const checker = (o, i) => typeof o === "object" && o[i];
  return object.length && object.reduce(function(prev, curr) {
    const prevOk = checker(prev, attr);
    const currOk = checker(curr, attr);
    if (!prevOk && !currOk) return {};
    if (!prevOk) return curr;
    if (!currOk) return prev;
    return prev[attr] < curr[attr] ? prev : curr;
  }) || null;
};
const _sfc_main$k = /* @__PURE__ */ defineComponent({
  __name: "AddedToCartModal",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div id="openAddedToCart" class="d-none" data-bs-toggle="modal" data-bs-target="#addedToCart"></div><div class="modal fade" id="addedToCart" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.product_added_to_cart"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div>`);
      if (_ctx.$page.props.flash.add_to_cart != void 0 && _ctx.$page.props.flash.add_to_cart != null) {
        _push(`<div class="modal-body"><div class="row"><div class="col-12"><div class="card d-flex align-item-center flex-column p-3"><div class="d-flex align-item-center flex-row mb-3"><div><img class="br-15 border-light-gray p-2" width="110" height="110"${ssrRenderAttr("src", _ctx.product.get_images[0]["link"])}${ssrRenderAttr("alt", _ctx.product.title)} loading="lazy"></div><div class="d-flex flex-grow-1 flex-column justify-content-center ps-4"><span class="product-title fs-7 lh-25 fw-bold lts-05">${ssrInterpolate(_ctx.product.title)}</span>`);
        if (_ctx.$page.props.flash.add_to_cart.data.props.length > 0) {
          _push(`<ul class="prop-ul mt-2"><!--[-->`);
          ssrRenderList(_ctx.$page.props.flash.add_to_cart.data.props, (prop, i) => {
            _push(`<li>`);
            if (prop.type == "color") {
              _push(`<span class="${ssrRenderClass({ color: true, border: prop.value["color"] == "#ffffff" })}" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span>`);
            } else {
              _push(`<span>${ssrInterpolate(prop.name + ": " + prop.value)}</span>`);
            }
            _push(`</li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div class="divider mb-2"></div><div class="d-flex align-item-center justify-content-between"><div class="d-flex flex-column justify-content-center"><span class="count-text fs-8 mb-1">${ssrInterpolate(_ctx.$t("messages.word.count"))}: <span class="fs-7 fw-bold">${ssrInterpolate(_ctx.$page.props.flash.add_to_cart.data.count)}</span></span><span class="fs-9 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.total_price_by_count"))}:</span></div><div class="cart-item--price fa-num">`);
        if (_ctx.$page.props.flash.add_to_cart.data.discount > 0) {
          _push(`<div class="cart-item--discount"><del>${ssrInterpolate(unref(useNumberFormat)(
            _ctx.$page.props.flash.add_to_cart.data.discount * _ctx.$page.props.flash.add_to_cart.data.count + _ctx.$page.props.flash.add_to_cart.data.price * _ctx.$page.props.flash.add_to_cart.data.count
          ))}</del></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(_ctx.$page.props.flash.add_to_cart.data.price * _ctx.$page.props.flash.add_to_cart.data.count))}</span><span class="unit unit-sm"></span></div></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="modal-footer"><button class="btn btn-light lts-05" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button class="btn btn-success lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.go_to_cart"))}</button></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup$k = _sfc_main$k.setup;
_sfc_main$k.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/AddedToCartModal.vue");
  return _sfc_setup$k ? _sfc_setup$k(props, ctx) : void 0;
};
const _sfc_main$j = /* @__PURE__ */ defineComponent({
  __name: "ProductBreadcrumb",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<nav${ssrRenderAttrs(mergeProps({
        class: "simplebar-container mb-1",
        "aria-label": "breadcrumb"
      }, _attrs))}><ol class="breadcrumb mb-0" style="${ssrRenderStyle({ "min-width": "800px" })}"><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$page.props.appName)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$page.props.appName), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.index", { cat: _ctx.product.category.slug })
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.product.category.title)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.product.category.title), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item product-title-breadcrumb active" aria-current="page">${ssrInterpolate(_ctx.product.title)}</li></ol></nav>`);
    };
  }
});
const _sfc_setup$j = _sfc_main$j.setup;
_sfc_main$j.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductBreadcrumb.vue");
  return _sfc_setup$j ? _sfc_setup$j(props, ctx) : void 0;
};
const slideHeight = 20;
const _sfc_main$i = /* @__PURE__ */ defineComponent({
  __name: "VerticalTextSlider",
  __ssrInlineRender: true,
  props: {
    texts: {},
    time: {}
  },
  setup(__props) {
    const props = __props;
    const currentIndex = ref(0);
    const transitioning = ref(true);
    let interval = null;
    const textArray = computed(() => Object.values(props.texts));
    const extendedTexts = computed(() => [...textArray.value, textArray.value[0]]);
    const startSlider = () => {
      interval = setInterval(() => {
        currentIndex.value++;
        if (currentIndex.value === textArray.value.length) {
          transitioning.value = true;
          setTimeout(() => {
            transitioning.value = false;
            currentIndex.value = 0;
            setTimeout(() => {
              transitioning.value = true;
            }, 50);
          }, 500);
        }
      }, props.time);
    };
    onMounted(() => {
      startSlider();
    });
    onUnmounted(() => {
      if (interval) clearInterval(interval);
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "slider-container" }, _attrs))} data-v-8ac51490><div class="slider-content" style="${ssrRenderStyle({
        transform: `translateY(-${currentIndex.value * slideHeight}px)`,
        transition: transitioning.value ? "transform 0.5s ease-in-out" : "none"
      })}" data-v-8ac51490><!--[-->`);
      ssrRenderList(extendedTexts.value, (text, i) => {
        _push(`<div class="slide lts-05 text-dark" data-v-8ac51490><span data-v-8ac51490>${text ?? ""}</span></div>`);
      });
      _push(`<!--]--></div></div>`);
    };
  }
});
const _sfc_setup$i = _sfc_main$i.setup;
_sfc_main$i.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/VerticalTextSlider.vue");
  return _sfc_setup$i ? _sfc_setup$i(props, ctx) : void 0;
};
const VerticalTextSlider = /* @__PURE__ */ _export_sfc(_sfc_main$i, [["__scopeId", "data-v-8ac51490"]]);
const _sfc_main$h = /* @__PURE__ */ defineComponent({
  __name: "ModelViewer3D",
  __ssrInlineRender: true,
  props: {
    src: {},
    alt: {},
    poster: {},
    autoRotate: { type: Boolean },
    cameraControls: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<model-viewer${ssrRenderAttrs(mergeProps({
        src: props.src,
        alt: props.alt,
        poster: props.poster,
        style: { width: "100%", height: "500px", background: "#f0f0f0", borderRadius: "15px" },
        "auto-rotate": props.autoRotate,
        "camera-controls": props.cameraControls,
        "camera-target": "0m 3m 0m"
      }, _attrs), "model-viewer")}></model-viewer>`);
    };
  }
});
const _sfc_setup$h = _sfc_main$h.setup;
_sfc_main$h.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ModelViewer3D.vue");
  return _sfc_setup$h ? _sfc_setup$h(props, ctx) : void 0;
};
const _sfc_main$g = /* @__PURE__ */ defineComponent({
  __name: "ProductImageGallery",
  __ssrInlineRender: true,
  props: {
    product: {},
    images: {},
    bestInventory: {}
  },
  setup(__props, { expose: __expose }) {
    const props = __props;
    const allImages = [...props.images.official, ...props.images.buyer];
    const isMobile = () => /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    let Fancybox = null;
    let Panzoom = null;
    onMounted(() => {
      Fancybox = inject("Fancybox");
      Panzoom = inject("Panzoom");
      Fancybox.defaults.trapFocus = false;
      Fancybox.defaults.autoFocus = false;
      Fancybox.defaults.placeFocusBack = false;
      Fancybox.bind("[data-fancybox]", false);
      const container = document.getElementById("image-panzoom");
      if (container && !isMobile()) {
        const instance = new Panzoom(container, {
          panMode: "mousemove",
          mouseMoveFactor: 1.25,
          click: false,
          wheel: false,
          disablePan: false,
          disableZoom: false
        });
        container.addEventListener("mouseenter", (event) => {
          if (!event.buttons) instance.zoomTo(2);
        });
        container.addEventListener("mouseleave", () => instance.zoomToFit());
      }
      if (isMobile() && container) {
        container.style.touchAction = "auto";
      }
    });
    function openGallery(startIndex) {
      if (!Fancybox) return;
      const items = allImages.map((img) => ({
        src: img.link,
        type: "image",
        caption: img.alt
      }));
      Fancybox.show(items, {
        startIndex: 0,
        idle: false,
        zoom: false,
        wheel: false,
        pan: false,
        dragToClose: false,
        click: false,
        Thumbs: {
          type: "classic"
        },
        Carousel: {
          direction: "rtl",
          infinite: false,
          click: false,
          friction: 0.92,
          initialIndex: startIndex,
          on: {
            change: (carousel, to) => {
              const instance2 = Fancybox.getInstance();
              if (!instance2) return;
              const { tabList, officialCount } = instance2.userData || {};
              if (!tabList) return;
              const tabIndex = to < officialCount ? 0 : 1;
              tabList.forEach((tab, i) => tab.classList.toggle("active", i === tabIndex));
            }
          }
        },
        on: {
          ready: (instance2) => {
            const root = instance2.container;
            if (root) root.setAttribute("dir", "rtl");
            if (!instance2.userData) instance2.userData = {};
            root.classList.remove("is-idle");
            const idleObserver = new MutationObserver((mutations) => {
              for (const mutation of mutations) {
                if (mutation.type === "attributes" && mutation.attributeName === "class" && root.classList.contains("is-idle")) {
                  root.classList.remove("is-idle");
                  console.log("❌ is-idle class removed");
                }
              }
            });
            idleObserver.observe(root, { attributes: true });
            instance2.userData._idleObserver = idleObserver;
            const preventIdle = (e) => {
              const inUI = e.target.closest(".fancybox__toolbar, .slider-titels, .fancybox__thumbs");
              if (inUI) {
                root.classList.remove("is-idle");
                console.log("🛡 Click on UI - removed idle");
              }
            };
            root.addEventListener("click", preventIdle, true);
            root.addEventListener(
              "click",
              (e) => {
                const slideEl = e.target.closest(".fancybox__slide");
                const closeBtn = e.target.closest("[data-fancybox-close]");
                if (slideEl && !closeBtn) {
                  e.stopPropagation();
                  e.preventDefault();
                }
              },
              true
            );
            setTimeout(() => {
              instance2.jumpTo(startIndex);
              const toolbar = root == null ? void 0 : root.querySelector(".fancybox__toolbar__column.is-middle");
              if (!toolbar || toolbar.querySelector(".slider-titels")) return;
              const ul = document.createElement("ul");
              ul.classList.add("slider-titels");
              ul.innerHTML = `
                        <div class="bottom-left"></div>
                        <div class="bottom-right"></div>
                        <li class="tab-btn clickable active" data-index="0">تصاویر رسمی</li>
                        <li class="tab-btn clickable ${props.images.buyer.length == 0 ? "d-none" : ""}" data-index="${props.images.official.length}">تصاویر خریداران</li>
                    `;
              toolbar.appendChild(ul);
              const tabList = Array.from(ul.querySelectorAll("li.tab-btn"));
              const officialCount = props.images.official.length;
              const totalCount = officialCount + props.images.buyer.length;
              instance2.userData = { tabList, officialCount, totalCount };
              tabList.forEach((tab) => {
                tab.addEventListener("click", () => {
                  const jumpIndex = parseInt(tab.dataset.index || "0");
                  instance2.jumpTo(jumpIndex);
                  tabList.forEach((el) => el.classList.remove("active"));
                  tab.classList.add("active");
                });
              });
              const slideIndex = instance2.getSlide().index;
              const tabIndex = slideIndex < officialCount ? 0 : 1;
              tabList.forEach((tab, i) => tab.classList.toggle("active", i === tabIndex));
            }, 100);
          },
          done: (instance2, slide) => {
            if (slide == null ? void 0 : slide.$el) {
              slide.$el.addEventListener(
                "wheel",
                (e) => {
                  e.preventDefault();
                  e.stopPropagation();
                },
                { passive: false }
              );
            }
            if (slide == null ? void 0 : slide.panzoom) {
              slide.panzoom.destroy();
              slide.panzoom = null;
            }
          },
          destroy: (instance2) => {
            if (instance2.userData && instance2.userData._idleObserver) {
              instance2.userData._idleObserver.disconnect();
            }
          }
        }
      });
    }
    __expose({
      openGallery
    });
    const rounded = (n) => Math.ceil(n / 100) * 100;
    const statistics = computed(() => {
      const stats = {};
      if (props.bestInventory != null && (Object.keys(props.bestInventory.get_price_changes).length === 0 || Math.min(...Object.values(props.bestInventory.get_price_changes)) === props.bestInventory.get_final_price)) {
        stats.best_price = '🤩 بهترین قیمت در <b class="mx-1 text-success">30</b> روز گذشته';
      }
      if (props.bestInventory != null && props.bestInventory.count < 5) {
        stats.storage_count = '📦 تنها <b class="mx-1 text-danger">' + props.bestInventory.count + "</b> عدد در انبار باقی مانده";
      }
      if (props.product.cart_count > 0) {
        stats.cart_count = '🛒 +<b class="mx-1">' + props.product.cart_count + "</b> عدد در سبد خرید کاربران";
      }
      const views = rounded(parseInt(props.product.view_count));
      if (views > 0) {
        stats.views = '👁️ +<b class="me-1">' + views + "</b> نفر این کالا را مشاهده کرده‌اند";
      }
      const favorites = rounded(props.product.favorites_count);
      if (favorites > 0) {
        stats.favorites = '❤️ +<b class="me-1">' + favorites + "</b> نفر به این کالا علاقه دارند";
      }
      return stats;
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "gallery-img-container" }, _attrs))}><div class="gallery-img" id="image-panzoom">`);
      if (_ctx.bestInventory != null) {
        _push(`<img${ssrRenderAttr("src", (_a = _ctx.bestInventory) == null ? void 0 : _a.get_image.url)}${ssrRenderAttr("alt", (_b = _ctx.bestInventory) == null ? void 0 : _b.get_image.alt)}>`);
      } else {
        _push(`<img${ssrRenderAttr("src", _ctx.images.official[0].link)}${ssrRenderAttr("alt", _ctx.images.official[0].alt)}>`);
      }
      _push(`</div><div class="gallery-thumbs"><ul><!--[-->`);
      ssrRenderList(allImages.slice(0, 5), (image, index) => {
        _push(`<li class="shadow-1" style="${ssrRenderStyle({ "cursor": "pointer" })}"><img${ssrRenderAttr("src", image.link)}${ssrRenderAttr("alt", image.alt)}></li>`);
      });
      _push(`<!--]--></ul></div>`);
      if (_ctx.$page.props.productStatisticsStatus === "1") {
        _push(ssrRenderComponent(VerticalTextSlider, {
          class: "product-statistics-mobile d-sm-none d-block",
          texts: statistics.value,
          time: 3e3
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-100 d-flex align-items-center justify-content-center mt-4">`);
      if (_ctx.product.model_3d != null && _ctx.product.model_3d != "") {
        _push(`<button type="button" data-bs-toggle="modal" data-bs-target="#show3DModel" class="show-3d-model btn btn-light lts-05 fs-7"><img width="25" class="me-3"${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/common/3d.png")}${ssrRenderAttr("alt", _ctx.$t("messages.sentence.model_3d"))}> ${ssrInterpolate(_ctx.$t("messages.sentence.model_3d"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.model_3d != null && _ctx.product.model_3d != "") {
        _push(`<div class="modal fade" id="show3DModel" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.model_3d"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12">`);
        _push(ssrRenderComponent(_sfc_main$h, {
          src: _ctx.product.model_3d,
          "auto-rotate": "",
          "camera-controls": ""
        }, null, _parent));
        _push(`</div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup$g = _sfc_main$g.setup;
_sfc_main$g.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductImageGallery.vue");
  return _sfc_setup$g ? _sfc_setup$g(props, ctx) : void 0;
};
const _sfc_main$f = /* @__PURE__ */ defineComponent({
  __name: "ProductMeta",
  __ssrInlineRender: true,
  props: {
    product: {},
    bestInventory: {}
  },
  setup(__props) {
    let Bootstrap = null;
    onMounted(() => {
      if (typeof window !== "undefined") {
        Bootstrap = inject("bootstrap");
      }
    });
    router.on("start", () => {
      if (typeof window !== "undefined") {
        if (Bootstrap != null) {
          document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach((element) => {
            const tooltip = Bootstrap.Tooltip.getInstance(element);
            if (tooltip) {
              tooltip.hide();
            }
          });
        }
      }
    });
    let tooltipInstances = [];
    onMounted(async () => {
      await nextTick();
      const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
      tooltipTriggerList.forEach((tooltipTriggerEl) => {
        const tooltip = new Bootstrap.Tooltip(tooltipTriggerEl);
        tooltipInstances.push(tooltip);
      });
      if (window.innerWidth < 768) {
        tooltipInstances.forEach((instance) => instance.disable());
      }
    });
    onUnmounted(() => {
      tooltipInstances.forEach((instance) => instance.dispose());
      tooltipInstances = [];
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-meta" }, _attrs))}><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.other_actions"))}: </span><ul><li data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.add_to_favorites"))}>`);
      if (_ctx.$page.props.auth.user != null) {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.favorites", _ctx.product.slug),
          method: "post",
          as: "button",
          type: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (_ctx.product.is_favorite) {
                _push2(`<i class="ri-heart-fill text-danger"${_scopeId}></i>`);
              } else {
                _push2(`<i class="ri-heart-line"${_scopeId}></i>`);
              }
            } else {
              return [
                _ctx.product.is_favorite ? (openBlock(), createBlock("i", {
                  key: 0,
                  class: "ri-heart-fill text-danger"
                })) : (openBlock(), createBlock("i", {
                  key: 1,
                  class: "ri-heart-line"
                }))
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-heart-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-heart-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
      }
      _push(`</li><li data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.word.share"))}><button type="button" data-bs-toggle="modal" data-bs-target="#share-product"><i class="ri-reply-line"></i></button></li><li data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.word.notifications"))}><button type="button" data-bs-toggle="modal" data-bs-target="#product-notification"><i class="ri-notification-3-line"></i></button></li><li data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.price_changes_chart"))}><button type="button" data-bs-toggle="modal" data-bs-target="#product-price-chart"><i class="ri-line-chart-fill"></i></button></li><li data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.add_to_compare"))}>`);
      if (_ctx.$page.props.auth.user != null) {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.compare.add", _ctx.product.slug),
          method: "post",
          data: { type: "start" },
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-scales-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-scales-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-scales-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-scales-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
      }
      _push(`</li></ul><div class="modal fade" id="share-product" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.share_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><p class="d-flex mb-3 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.share_product_with_your_friend"))}</p><div class="alert alert-light mb-0" style="${ssrRenderStyle({ "direction": "ltr" })}">${ssrInterpolate(_ctx.route("main.products.shortcut", _ctx.product.uuid))}</div></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.copy_address"))}</button></div></div></div></div><div class="modal fade" id="product-notification" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.notifications"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row">`);
      if (!_ctx.product.inventory) {
        _push(`<div class="col-12"><div class="alert alert-light d-flex align-items-center justify-content-between ps-3 pe-2 mb-2"><span class="text-dark fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.notify_me_when_the_product_is_available"))}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.notification", _ctx.product.slug),
          data: { type: "inventory" },
          method: "post",
          as: "button",
          type: "button",
          class: "btn text-white fw-bold lts-05 fs-8 " + (_ctx.product.has_inventory_notification ? "btn-danger" : "btn-success")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.product.has_inventory_notification ? _ctx.$t("messages.word.deactivation") : _ctx.$t("messages.word.activation"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.product.has_inventory_notification ? _ctx.$t("messages.word.deactivation") : _ctx.$t("messages.word.activation")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else if (_ctx.product.inventory && !_ctx.product.has_discount) {
        _push(`<div class="col-12"><div class="alert alert-light d-flex align-items-center justify-content-between ps-3 pe-2 mb-2"><span class="text-dark fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.notify_me_when_the_product_is_discounted"))}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.notification", _ctx.product.slug),
          data: { type: "discount" },
          method: "post",
          as: "button",
          type: "button",
          class: "btn text-white fw-bold lts-05 fs-8 " + (_ctx.product.has_discount_notification ? "btn-danger" : "btn-success")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.product.has_discount_notification ? _ctx.$t("messages.word.deactivation") : _ctx.$t("messages.word.activation"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.product.has_discount_notification ? _ctx.$t("messages.word.deactivation") : _ctx.$t("messages.word.activation")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<div class="col-12"><p class="lts-05 fs-8 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.no_notifications_are_available_for_product_status"))}</p></div>`);
      }
      _push(`</div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><div class="modal fade" id="product-price-chart" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.price_changes_chart"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row">`);
      if (_ctx.bestInventory != null && _ctx.bestInventory.get_price_changes != null) {
        _push(`<div class="col-12 mb-4"><div class="bg-light p-2 ps-4 pe-4 br-20">`);
        _push(ssrRenderComponent(_sfc_main$l, {
          id: 1,
          labels: _ctx.bestInventory.get_price_changes_chart.date,
          datasets: {
            one: {
              data: _ctx.bestInventory.get_price_changes_chart.price,
              label: "قیمت",
              color: _ctx.$page.props.template.get_options.style.site_main_color
            }
          }
        }, null, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12"><span class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_452111"))}</span></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup$f = _sfc_main$f.setup;
_sfc_main$f.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductMeta.vue");
  return _sfc_setup$f ? _sfc_setup$f(props, ctx) : void 0;
};
const _sfc_main$e = /* @__PURE__ */ defineComponent({
  __name: "ProductProps",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    child: {}
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const model = useModel(__props, "modelValue");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ProductProps = resolveComponent("ProductProps", true);
      _push(`<!--[-->`);
      ssrRenderList(_ctx.child, (child_prop, child_prop_index) => {
        _push(`<!--[--><div class="type-container mb-2"><div class="type-container-title mb-2">${ssrInterpolate(child_prop_index)}:</div><ul class="type-list"><!--[-->`);
        ssrRenderList(child_prop, (p, i) => {
          _push(`<li class="${ssrRenderClass({ selected: model.value[child_prop_index] == p["value"] })}">${ssrInterpolate(p["value"])}</li>`);
        });
        _push(`<!--]--></ul></div><div class="d-none">${ssrInterpolate(model.value[child_prop_index] == null ? model.value[child_prop_index] = Object.keys(child_prop)[0] : "")}</div>`);
        if (child_prop[model.value[child_prop_index]] != void 0 && child_prop[model.value[child_prop_index]]["child"] != null) {
          _push(ssrRenderComponent(_component_ProductProps, {
            modelValue: model.value,
            "onUpdate:modelValue": ($event) => model.value = $event,
            child: child_prop[model.value[child_prop_index]]["child"]
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$e = _sfc_main$e.setup;
_sfc_main$e.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductProps.vue");
  return _sfc_setup$e ? _sfc_setup$e(props, ctx) : void 0;
};
const _sfc_main$d = /* @__PURE__ */ defineComponent({
  __name: "ProductInformation",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    product: {},
    productProps: {}
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const activeProps = useModel(__props, "modelValue");
    const paramsRef = ref(null);
    const isCollapsed = ref(true);
    const showToggle = ref(false);
    onMounted(() => {
      if (!paramsRef.value) return;
      const maxHeight = 65;
      const height = paramsRef.value.scrollHeight;
      showToggle.value = height > maxHeight;
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-information col-lg-5 col-md-6 mb-lg-0 mb-md-5 mb-3" }, _attrs))}><div class="d-flex align-items-center justify-content-between mb-2">`);
      if (_ctx.product.brand != null) {
        _push(`<nav aria-label="breadcrumb"><ol class="breadcrumb"><li class="breadcrumb-item">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.brands.show", _ctx.product.brand.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.product.brand.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.product.brand.title), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ol></nav>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.is_vip) {
        _push(`<span class="badge text-gray bg-light fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.vip_product"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><h1 class="product-title">${ssrInterpolate(_ctx.product.title)}</h1><div class="product-en mb-3"><span>${ssrInterpolate(_ctx.product.title_en)}</span></div><div class="product-user-suggestion mb-2"><i class="ri-thumb-up-fill me-1"></i><span class="lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.users_suggest_percent", { percent: _ctx.product.comments_info.suggation_percent + "" }))}</span><span type="button" data-bs-toggle="tooltip" data-bs-placement="bottom"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.msg_id_125589"))}><i class="ri-information-line"></i></span></div><div class="product-user-meta fa-num mb-3"><span class="product-users-rating"><i class="ri-star-fill icon me-1"></i><span class="fw-bold me-1">${ssrInterpolate(_ctx.product.comments_info.rating)}</span><span class="text-muted fs-7">(${ssrInterpolate(_ctx.product.comments_info.count)})</span></span><span class="divider"></span><span class="link fw-bold border-bottom-0 fs-7">${ssrInterpolate(_ctx.product.comments_info.count)} ${ssrInterpolate(_ctx.$t("messages.word.comment"))}</span><span class="divider"></span><span class="link fw-bold border-bottom-0 fs-7">${ssrInterpolate(_ctx.product.questions_info.count)} ${ssrInterpolate(_ctx.$t("messages.word.question"))}</span></div>`);
      if (_ctx.product.guide != null && _ctx.product.guide.length >= 15) {
        _push(`<div class="product-guide mb-3"><span class="title clickable" data-bs-toggle="modal" data-bs-target="#productGuide"><i class="ri-pencil-ruler-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_variable_guide"))}</span><div class="modal fade" id="productGuide" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5"></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="review-content main-content">${_ctx.product.guide ?? ""}</div></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div id="product-props-under"></div><!--[-->`);
      ssrRenderList(_ctx.productProps, (prop, index) => {
        _push(`<!--[-->`);
        if (index == "رنگ") {
          _push(`<div class="color-container mb-3"><div class="color-container-title">${ssrInterpolate(_ctx.$t("messages.word.color"))}:</div><ul class="color-list"><!--[-->`);
          ssrRenderList(prop, (p, i) => {
            _push(`<!--[-->`);
            if (p["value"]["image"] != null) {
              _push(`<li class="${ssrRenderClass({ "shadow-1 color-box add-image": true, "is-white": p["value"]["color"] == "#ffffff", selected: activeProps.value[index] == p["value"]["color"] })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", p["value"]["label"])}><img${ssrRenderAttr("src", p["value"]["image"])} alt="رنگ"></li>`);
            } else {
              _push(`<li class="${ssrRenderClass({ "shadow-1": true, "is-white": p["value"]["color"] == "#ffffff", selected: activeProps.value[index] == p["value"]["color"] })}" style="${ssrRenderStyle("background-color:" + p["value"]["color"])}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", p["value"]["label"])}></li>`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<div class="type-container mb-4"><div class="type-container-title mb-2">${ssrInterpolate(index)}:</div><ul class="type-list"><!--[-->`);
          ssrRenderList(prop, (p, i) => {
            _push(`<li class="${ssrRenderClass({ selected: activeProps.value[index] == p["value"] })}">${ssrInterpolate(p["value"])}</li>`);
          });
          _push(`<!--]--></ul></div>`);
        }
        if (prop[activeProps.value[index]] != void 0 && prop[activeProps.value[index]]["child"] != null) {
          _push(ssrRenderComponent(_sfc_main$e, {
            modelValue: activeProps.value,
            "onUpdate:modelValue": ($event) => activeProps.value = $event,
            child: prop[activeProps.value[index]]["child"]
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]-->`);
      if (_ctx.product.get_attrs.length > 0) {
        _push(`<div class="product-params-title mb-3 mt-4">${ssrInterpolate(_ctx.$t("messages.sentence.outstanding_features"))}:</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.get_attrs.length > 0) {
        _push(`<div class="mb-3"><div><div class="product-params" style="${ssrRenderStyle(isCollapsed.value && showToggle.value ? "max-height:60px; overflow:hidden;" : "")}"><ul><!--[-->`);
        ssrRenderList(_ctx.product.get_attrs, (attr) => {
          _push(`<li><span class="label mb-1">${ssrInterpolate(attr.key)}:</span><span>${ssrInterpolate(attr.value)}</span></li>`);
        });
        _push(`<!--]--></ul></div>`);
        if (showToggle.value) {
          _push(`<div><button class="btn link d-flex align-items-center gap-1 fs-8 ps-0"><span>${ssrInterpolate(isCollapsed.value ? _ctx.$t("messages.word.more") : _ctx.$t("messages.word.less"))}</span><i class="${ssrRenderClass(isCollapsed.value ? "ri-arrow-down-s-line" : "ri-arrow-up-s-line")}"></i></button></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.warnings != null) {
        _push(`<div class="product-additional-info-container"><span class="icon"><i class="ri-information-fill"></i></span><div class="product-additional-info"><p class="lts-05">${ssrInterpolate(_ctx.product.warnings)}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$d = _sfc_main$d.setup;
_sfc_main$d.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductInformation.vue");
  return _sfc_setup$d ? _sfc_setup$d(props, ctx) : void 0;
};
const _sfc_main$c = /* @__PURE__ */ defineComponent({
  __name: "ProductAction",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    product: {},
    activeInventories: {},
    bestInventory: {},
    addToCartProcessing: { type: Boolean }
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["addToCart"], ["update:modelValue"]),
  setup(__props, { emit: __emit }) {
    const props = __props;
    const count = useModel(__props, "modelValue");
    const changeCount = () => {
      if (props.bestInventory != null) {
        if (props.bestInventory.max_sale == null) {
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        } else if (count.value > props.bestInventory.max_sale) {
          count.value = Number(props.bestInventory.max_sale);
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        }
        if (count.value < props.bestInventory.min_sale) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    };
    watch(
      () => props.bestInventory,
      (first, second) => {
        if (props.bestInventory != null) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    );
    const scrollBeforePx = ref(25);
    onMounted(() => {
      if (typeof window !== "undefined") {
        if ($(".sticky-header-with-top-banner").length > 0) {
          scrollBeforePx.value = 200;
        }
      }
    });
    const rounded = (n) => Math.ceil(n / 100) * 100;
    const statistics = computed(() => {
      const stats = {};
      if (props.bestInventory != null && (Object.keys(props.bestInventory.get_price_changes).length === 0 || Math.min(...Object.values(props.bestInventory.get_price_changes)) === props.bestInventory.get_final_price)) {
        stats.best_price = '🤩 بهترین قیمت در <b class="mx-1 text-success">30</b> روز گذشته';
      }
      if (props.bestInventory != null && props.bestInventory.count < 5) {
        stats.storage_count = '📦 تنها <b class="mx-1 text-danger">' + props.bestInventory.count + "</b> عدد در انبار باقی مانده";
      }
      if (props.product.cart_count > 0) {
        stats.cart_count = '🛒 +<b class="mx-1">' + props.product.cart_count + "</b> عدد در سبد خرید کاربران";
      }
      const views = rounded(parseInt(props.product.view_count));
      if (views > 0) {
        stats.views = '👁️ +<b class="me-1">' + views + "</b> نفر این کالا را مشاهده کرده‌اند";
      }
      const favorites = rounded(props.product.favorites_count);
      if (favorites > 0) {
        stats.favorites = '❤️ +<b class="me-1">' + favorites + "</b> نفر به این کالا علاقه دارند";
      }
      return stats;
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-actions col-lg-3 col-md-12" }, _attrs))}><div class="seller-container mb-3"><div class="d-flex align-items-center justify-content-between"><div class="seller-container-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
      if (_ctx.activeInventories.length > 1) {
        _push(`<span class="link fs-8 lts-05"><span class="fw-bold me-1">${ssrInterpolate(_ctx.activeInventories.length - 1)}</span> ${ssrInterpolate(_ctx.$t("messages.sentence.other_seller"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><ul>`);
      if (_ctx.bestInventory != null && _ctx.bestInventory.store == null) {
        _push(`<!--[--><li><div class="seller-avatar shadow-1 me-2"><img${ssrRenderAttr("src", _ctx.$page.props.appFavicon != null ? _ctx.$page.props.appFavicon : _ctx.$page.props.appUrl + "/img/temp/store-logo.png")}${ssrRenderAttr("alt", _ctx.$page.props.appName)} loading="lazy"></div><a class="table-name lts-05" href="javascript:void(0)">${ssrInterpolate(_ctx.$page.props.appName)} <i class="ri-verified-badge-fill verify me-0"></i></a><span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></li><li><i class="ri-donut-chart-fill"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.word.performance"))}</span><span class="divider"></span><span class="table-flag green lts-05">${ssrInterpolate(_ctx.$t("messages.word.best"))}</span></li><!--]-->`);
      } else if (_ctx.bestInventory != null && _ctx.bestInventory.store != null) {
        _push(`<!--[--><li><div class="seller-avatar shadow-1 me-2">`);
        if (_ctx.bestInventory.store.get_logo != null) {
          _push(`<img${ssrRenderAttr("src", _ctx.bestInventory.store.get_logo)}${ssrRenderAttr("alt", _ctx.bestInventory.store.name)} loading="lazy">`);
        } else {
          _push(`<i class="ri-store-2-line shop"></i>`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "table-name lts-05",
          href: _ctx.route("main.stores.show", _ctx.bestInventory.store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.bestInventory.store.name)} <i class="ri-verified-badge-fill verify me-0"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.bestInventory.store.name) + " ", 1),
                createVNode("i", { class: "ri-verified-badge-fill verify me-0" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span></li><li><i class="ri-donut-chart-fill"></i><span class="table-name lts-05" href="#">${ssrInterpolate(_ctx.$t("messages.word.performance"))}</span><span class="divider"></span>`);
        if (_ctx.bestInventory.store.get_meta.performance == "best") {
          _push(`<span class="text-success-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.best"))}</span>`);
        } else if (_ctx.bestInventory.store.get_meta.performance == "good") {
          _push(`<span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.word.good"))}</span>`);
        } else if (_ctx.bestInventory.store.get_meta.performance == "average") {
          _push(`<span class="text-warning fw-bold">${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (_ctx.bestInventory.store.get_meta.performance == "weak") {
          _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.weak"))}</span>`);
        } else if (_ctx.bestInventory.store.get_meta.performance == "awful") {
          _push(`<span class="text-danger-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.awful"))}</span>`);
        } else {
          _push(`<span class="text-dark fw-bold">-</span>`);
        }
        _push(`</li><!--]-->`);
      } else {
        _push(`<li><i class="ri-error-warning-line"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_seller"))}</span></li>`);
      }
      _push(`<li class="clickable" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.copy_product_uuid"))}><i class="ri-qr-code-line"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))}</span><span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.product.uuid)}</span></li>`);
      if (_ctx.bestInventory != null) {
        _push(`<li><i class="ri-truck-line"></i>`);
        if (_ctx.bestInventory.store != null && _ctx.bestInventory.store.direct_post) {
          _push(`<span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.send_by_seller"))}</span>`);
        } else {
          _push(`<span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.send_by_main_shop"))}</span>`);
        }
        _push(`<span class="divider"></span>`);
        if (_ctx.bestInventory.send_time != null && _ctx.bestInventory.send_time != "") {
          _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(_ctx.bestInventory.send_time)}</span>`);
        } else {
          _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
        }
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.bestInventory != null) {
        _push(`<li>`);
        if (_ctx.bestInventory.original) {
          _push(`<span class="table-name badge bg-success fs-9 lts-05" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.original_product_hint"))} style="${ssrRenderStyle({ "padding": "4px 6px !important" })}">${ssrInterpolate(_ctx.$t("messages.sentence.original_product"))}</span>`);
        } else {
          _push(`<span class="table-name badge bg-warning fs-9 lts-05" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.unoriginal_product_hint"))} style="${ssrRenderStyle({ "padding": "4px 6px !important" })}">${ssrInterpolate(_ctx.$t("messages.sentence.unoriginal_product"))}</span>`);
        }
        _push(`<span class="divider"></span>`);
        if (_ctx.bestInventory.used) {
          _push(`<span class="table-name badge bg-warning fs-9 lts-05" style="${ssrRenderStyle({ "padding": "4px 6px !important" })}">${ssrInterpolate(_ctx.$t("messages.sentence.used_product"))}</span>`);
        } else {
          _push(`<span class="table-name badge bg-success fs-9 lts-05" style="${ssrRenderStyle({ "padding": "4px 6px !important" })}">${ssrInterpolate(_ctx.$t("messages.sentence.unused_product"))}</span>`);
        }
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div><div class="divider d-none d-sm-block"></div>`);
      if (_ctx.bestInventory != null) {
        _push(`<div class="d-none d-sm-block">`);
        if (_ctx.$page.props.productStatisticsStatus === "1") {
          _push(ssrRenderComponent(VerticalTextSlider, {
            class: "mb-3",
            texts: statistics.value,
            time: 3e3
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="price-count-container mb-3"><div class="count-container"><span class="increase"><i class="ri-add-line"></i></span>`);
        _push(ssrRenderComponent(_sfc_main$m, {
          modelValue: count.value,
          "onUpdate:modelValue": ($event) => count.value = $event,
          onChange: changeCount,
          type: "text",
          name: "count",
          minlength: "1",
          maxlength: "4",
          autocomplete: "off"
        }, null, _parent));
        _push(`<span class="decrease"><i class="ri-subtract-line"></i></span></div><div class="price-container d-flex flex-column">`);
        if (_ctx.bestInventory.is_discount_valid) {
          _push(`<span class="product-price-old lts-05 mb-1"><span class="old-price color-secondary">${ssrInterpolate(_ctx.bestInventory.get_formatted_price)}</span><span class="discount-percent bg-secondary shadow-1 ms-1"><i class="ri-percent-fill"></i> ${ssrInterpolate(_ctx.bestInventory.get_discount_percent)}</span></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="product-price-now lts-05">${ssrInterpolate(_ctx.bestInventory.get_formatted_final_price)} <span class="unit"></span></span></div></div>`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button${ssrIncludeBooleanAttr(_ctx.addToCartProcessing) ? " disabled" : ""} class="${ssrRenderClass({ "add-to-cart btn btn-primary btn-block lts-05 mb-2": true, "shadow-primary": !_ctx.addToCartProcessing })}" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))} `);
          if (_ctx.addToCartProcessing) {
            _push(`<i class="ri-refresh-line i-spin"></i>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: decodeURIComponent(_ctx.$page.props.ziggy.location) }),
            as: "button",
            class: "add-to-cart btn btn-primary shadow-primary lts-05 mb-2",
            type: "button"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_to_cart")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`<div class="customer-club"><div class="checkout-row-label lts-05"><span class="d-flex align-items-center"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fs-7">${ssrInterpolate(_ctx.bestInventory.get_customer_club_score.score * count.value)}</span> <span class="fs-8 fw-light ms-1">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div>`);
      } else {
        _push(`<!--[--><div class="d-none d-sm-block">`);
        if (_ctx.product.in_stock_status) {
          _push(`<button disabled class="add-to-cart btn btn-primary lts-05 mb-2" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.product_is_not_available"))}</button>`);
        } else {
          _push(`<button class="add-to-cart btn btn-primary lts-05 mb-2" type="button" data-bs-toggle="modal" data-bs-target="#product-inquiry">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</button>`);
        }
        _push(`</div><div class="modal fade" id="product-inquiry" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><p class="d-flex mb-3 lts-05 lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478996"))}</p><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td><span class="text-success fs-6 me-1"><i class="ri-whatsapp-fill"></i></span> ${ssrInterpolate(_ctx.$t("messages.sentence.whatsapp_inquiry"))}</td><td><a class="link text-info"${ssrRenderAttr("href", "https://wa.me/" + _ctx.product.get_inquiry_options.cellular_phone)} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.send_message"))}</a></td></tr><tr><td><span class="text-gray fs-6 me-1"><i class="ri-smartphone-fill"></i></span> ${ssrInterpolate(_ctx.$t("messages.sentence.cellular_phone"))}</td><td><a class="link text-info"${ssrRenderAttr("href", "tel://" + _ctx.product.get_inquiry_options.cellular_phone)}>${ssrInterpolate(_ctx.product.get_inquiry_options.cellular_phone)}</a></td></tr><tr><td><span class="text-dark fs-6 me-1"><i class="ri-phone-fill"></i></span> ${ssrInterpolate(_ctx.$t("messages.sentence.landline_phone"))}</td><td><a class="link text-info"${ssrRenderAttr("href", "tel://" + _ctx.product.get_inquiry_options.landline_phone)}>${ssrInterpolate(_ctx.product.get_inquiry_options.landline_phone)}</a></td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$c = _sfc_main$c.setup;
_sfc_main$c.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductAction.vue");
  return _sfc_setup$c ? _sfc_setup$c(props, ctx) : void 0;
};
const _sfc_main$b = /* @__PURE__ */ defineComponent({
  __name: "ProductSellerList",
  __ssrInlineRender: true,
  props: {
    activeInventories: {},
    addToCartProcessing: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container" }, _attrs))}>`);
      if (_ctx.activeInventories.length > 1) {
        _push(`<div class="card shadow-1 seller-list-container mb-4" id="product-seller"><div class="seller-list-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.product_sellers"))}</div><div class="seller-table"><!--[-->`);
        ssrRenderList(_ctx.activeInventories, (inventory) => {
          _push(`<div class="seller-item">`);
          if (inventory.store != null) {
            _push(`<div class="seller-item-col seller-item-col--info"><div class="seller-name fw-bold mb-2"><div class="seller-avatar shadow-1 me-2">`);
            if (inventory.store.get_logo != null) {
              _push(`<img${ssrRenderAttr("src", inventory.store.get_logo)}${ssrRenderAttr("alt", inventory.store.name)} loading="lazy">`);
            } else {
              _push(`<i class="ri-store-2-line shop"></i>`);
            }
            _push(`</div>`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.stores.show", inventory.store.uuid),
              class: "link text-dark"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(inventory.store.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(inventory.store.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div><div class="seller-rate fs-7">`);
            if (inventory.store.get_meta.product_satisfaction != null) {
              _push(`<span class="${ssrRenderClass({
                "fw-bold fa-num": true,
                "text-success": inventory.store.get_meta.performance == "best" || inventory.store.get_meta.performance == "good",
                "text-warning": inventory.store.get_meta.performance == "average",
                "text-danger": inventory.store.get_meta.performance == "weak" || inventory.store.get_meta.performance == "awful"
              })}">${ssrInterpolate(inventory.store.get_meta.product_satisfaction)}% </span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.buyer_satisfaction"))}</span><span>|</span><span>${ssrInterpolate(_ctx.$t("messages.word.performance"))}</span>`);
            if (inventory.store.get_meta.performance == "best") {
              _push(`<span class="text-success-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.best"))}</span>`);
            } else if (inventory.store.get_meta.performance == "good") {
              _push(`<span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.word.good"))}</span>`);
            } else if (inventory.store.get_meta.performance == "average") {
              _push(`<span class="text-warning fw-bold">${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
            } else if (inventory.store.get_meta.performance == "weak") {
              _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.weak"))}</span>`);
            } else if (inventory.store.get_meta.performance == "awful") {
              _push(`<span class="text-danger-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.awful"))}</span>`);
            } else {
              _push(`<span class="text-warning fw-bold">-</span>`);
            }
            _push(`</div></div>`);
          } else {
            _push(`<div class="seller-item-col seller-item-col--info"><div class="seller-name fw-bold mb-2"><div class="seller-avatar shadow-1 me-2"><img${ssrRenderAttr("src", _ctx.$page.props.appFavicon)}${ssrRenderAttr("alt", _ctx.$page.props.appName)} loading="lazy"></div><span>${ssrInterpolate(_ctx.$page.props.appName)}</span></div><div class="seller-rate fs-7"><span class="text-success fw-bold fa-num">100%</span><span>${ssrInterpolate(_ctx.$t("messages.sentence.buyer_satisfaction"))}</span><span>|</span><span>${ssrInterpolate(_ctx.$t("messages.word.performance"))}</span><span class="text-success-dark fw-bold">${ssrInterpolate(_ctx.$t("messages.word.best"))}</span></div></div>`);
          }
          _push(`<div class="seller-item-col seller-item-col--conditions"><div class="seller-item-sender"><i class="ri-truck-line"></i>`);
          if (inventory.send_time != null && inventory.send_time != "") {
            _push(`<span>${ssrInterpolate(inventory.send_time)}</span>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
          }
          _push(`</div></div><div class="seller-item-col seller-item-col--guarantee"><i class="ri-shield-check-line"></i>`);
          if ("گارانتی" in inventory.raw_props) {
            _push(`<span class="fa-num">${ssrInterpolate(inventory.raw_props["گارانتی"])}</span>`);
          } else {
            _push(`<span class="fa-num">${ssrInterpolate(_ctx.$t("messages.sentence.default_warranty"))}</span>`);
          }
          _push(`</div><div class="seller-item-col seller-item-col--price">`);
          if (inventory.is_discount_valid) {
            _push(`<span class="product-price-old lts-05"><span class="old-price text-light-gray">${ssrInterpolate(inventory.get_formatted_price)}</span><span class="discount-percent bg-secondary shadow-1 ms-1"><i class="ri-percent-fill"></i> ${ssrInterpolate(inventory.get_discount_percent)}</span></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="price-now fa-num fw-bold lts-05">${ssrInterpolate(inventory.get_formatted_final_price)} <span class="unit unit-sm"></span></span></div><div class="seller-item-col seller-item-col--action">`);
          if (_ctx.$page.props.auth.user != null) {
            _push(`<button type="button" class="btn btn-sm btn-primary-semi fs-8 px-3 py-2 lts-05"${ssrIncludeBooleanAttr(_ctx.addToCartProcessing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.add_to_basket"))}</button>`);
          } else {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
              as: "button",
              type: "button",
              class: "btn btn-sm btn-primary-semi px-4 lts-05"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_to_basket"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_to_basket")), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          }
          _push(`</div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$b = _sfc_main$b.setup;
_sfc_main$b.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductSellerList.vue");
  return _sfc_setup$b ? _sfc_setup$b(props, ctx) : void 0;
};
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  __name: "ProductTab",
  __ssrInlineRender: true,
  props: {
    product: {},
    activeTab: {},
    scrollMode: { type: Boolean }
  },
  emits: ["update:activeTabEmit"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const productContentActiveTab = ref(props.activeTab || "review-tab");
    onMounted(() => {
      if (props.scrollMode !== false) {
        window.onscroll = () => {
          let sTop = document.documentElement.scrollTop + 55;
          document.querySelectorAll(".tab-content").forEach((el) => {
            let id = el.getAttribute("id"), offset = el.offsetTop - 1, height = el.clientHeight;
            if (sTop >= offset && sTop < offset + height) {
              productContentActiveTab.value = id;
            }
          });
        };
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-tabs" }, _attrs))}><div class="simplebar-container"><ul class="nav nav-pills" style="${ssrRenderStyle({ "flex-wrap": "nowrap", "white-space": "nowrap" })}">`);
      if (_ctx.product.content.length >= 15) {
        _push(`<li class="nav-item"><a href="javascript:void(0)" class="${ssrRenderClass(productContentActiveTab.value == "review-tab" ? "nav-link active" : "nav-link")}">${ssrInterpolate(_ctx.$t("messages.word.review"))}</a></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.get_specifications.length > 0) {
        _push(`<li class="nav-item"><a href="javascript:void(0)" class="${ssrRenderClass(productContentActiveTab.value == "specifications-tab" ? "nav-link active" : "nav-link")}">${ssrInterpolate(_ctx.$t("messages.word.specifications"))}</a></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.product.get_tabs, (tab, index) => {
        _push(`<li class="nav-item"><a href="javascript:void(0)" class="${ssrRenderClass(productContentActiveTab.value == "tab-id-" + index ? "nav-link active" : "nav-link")}">${ssrInterpolate(tab.title)}</a></li>`);
      });
      _push(`<!--]-->`);
      if (_ctx.product.comment_status) {
        _push(`<li class="nav-item"><a href="javascript:void(0)" class="${ssrRenderClass(productContentActiveTab.value == "comments-tab" ? "nav-link active" : "nav-link")}">${ssrInterpolate(_ctx.$t("messages.word.comments"))}</a></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.question_status) {
        _push(`<li class="nav-item"><a href="javascript:void(0)" class="${ssrRenderClass(productContentActiveTab.value == "question-tab" ? "nav-link active" : "nav-link")}">${ssrInterpolate(_ctx.$t("messages.sentence.question_list"))}</a></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div></div>`);
    };
  }
});
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductTab.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  __name: "ProductAffiliateBox",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.product.get_affiliate != null) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "affiliate-box" }, _attrs))}><div class="affiliate-box-description d-flex align-items-center mb-4"><div class="affiliate-box-icon d-flex align-items-center justify-content-center me-3"><i class="ri-wallet-3-line"></i></div><div><span class="d-block text-black fs-7 fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.income_with_affiliate"))}</span><span class="d-block fs-9 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_458993"))}</span></div></div>`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<div class="mb-2"><span class="d-flex align-items-center justify-content-between"><span><span class="fs-8 text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.your_level"))}:</span>`);
          if (_ctx.$page.props.auth.user.get_level == "gold") {
            _push(`<span class="d-inline-flex align-items-center fs-8 text-black lts-05 ms-1">${ssrInterpolate(_ctx.$t("messages.word.gold"))} <span class="d-inline-block gold-circle ms-1"></span></span>`);
          } else if (_ctx.$page.props.auth.user.get_level == "silver") {
            _push(`<span class="d-inline-flex align-items-center fs-8 text-black lts-05 ms-1">${ssrInterpolate(_ctx.$t("messages.word.silver"))} <span class="d-inline-block silver-circle ms-1"></span></span>`);
          } else {
            _push(`<span class="d-inline-flex align-items-center fs-8 text-black lts-05 ms-1">${ssrInterpolate(_ctx.$t("messages.word.bronze"))} <span class="d-inline-block bronze-circle ms-1"></span></span>`);
          }
          _push(`</span><span><span class="fs-8 text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.word.commission"))}:</span>`);
          if (_ctx.$page.props.auth.user.get_level == "gold") {
            _push(`<span class="fs-7 text-black fw-bold lts-05 ms-1">${ssrInterpolate(_ctx.product.get_affiliate.gold_commission)} <i class="ri-percent-fill fs-9"></i></span>`);
          } else if (_ctx.$page.props.auth.user.get_level == "silver") {
            _push(`<span class="fs-7 text-black fw-bold lts-05 ms-1">${ssrInterpolate(_ctx.product.get_affiliate.silver_commission)} <i class="ri-percent-fill fs-9"></i></span>`);
          } else {
            _push(`<span class="fs-7 text-black fw-bold lts-05 ms-1">${ssrInterpolate(_ctx.product.get_affiliate.bronze_commission)} <i class="ri-percent-fill fs-9"></i></span>`);
          }
          _push(`</span></span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button class="btn btn-light lts-05 fs-7 w-100">${ssrInterpolate(_ctx.$t("messages.sentence.product_affiliate_link"))}</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            class: "btn btn-light lts-05 fs-7 w-100"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.product_affiliate_link"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.product_affiliate_link")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductAffiliateBox.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "ProductActionSidebar",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    product: {},
    activeInventories: {},
    bestInventory: {},
    addToCartProcessing: { type: Boolean }
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["addToCart"], ["update:modelValue"]),
  setup(__props, { emit: __emit }) {
    const props = __props;
    const count = useModel(__props, "modelValue");
    const changeCount = () => {
      if (props.bestInventory != null) {
        if (props.bestInventory.max_sale == null) {
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        } else if (count.value > props.bestInventory.max_sale) {
          count.value = Number(props.bestInventory.max_sale);
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        }
        if (count.value < props.bestInventory.min_sale) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    };
    watch(
      () => props.bestInventory,
      (first, second) => {
        if (props.bestInventory != null) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    );
    const scrollBeforePx = ref(25);
    onMounted(() => {
      if (typeof window !== "undefined") {
        if ($(".sticky-header-with-top-banner").length > 0) {
          scrollBeforePx.value = 200;
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-sidebar product-actions col-xl-3 col-lg-4 d-md-block d-none" }, _attrs))}><div class="inner"><div class="card shadow-1 mb-4"><div class="product-info"><img${ssrRenderAttr("src", _ctx.product.get_images[0]["link"])} width="70" height="70"${ssrRenderAttr("alt", _ctx.product.title)} loading="lazy"><h2>${ssrInterpolate(_ctx.product.title)}</h2></div><div class="seller-container mb-4"><div class="d-flex align-items-center justify-content-between mb-2"><div class="seller-container-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
      if (_ctx.activeInventories.length > 1) {
        _push(`<span class="link fs-8 lts-05"><span class="fw-bold me-1">${ssrInterpolate(_ctx.activeInventories.length - 1)}</span> ${ssrInterpolate(_ctx.$t("messages.sentence.other_seller"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><ul>`);
      if (_ctx.bestInventory != null && _ctx.bestInventory.store == null) {
        _push(`<li><div class="seller-avatar shadow-1 me-2"><img${ssrRenderAttr("src", _ctx.$page.props.appFavicon != null ? _ctx.$page.props.appFavicon : _ctx.$page.props.appUrl + "/img/temp/store-logo.png")}${ssrRenderAttr("alt", _ctx.$page.props.appName)} loading="lazy"></div><a class="table-name lts-05" href="javascript:void(0)">${ssrInterpolate(_ctx.$page.props.appName)} <i class="ri-verified-badge-fill verify me-0"></i></a><span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></li>`);
      } else if (_ctx.bestInventory != null && _ctx.bestInventory.store != null) {
        _push(`<li><div class="seller-avatar shadow-1 me-2">`);
        if (_ctx.bestInventory.store.get_logo != null) {
          _push(`<img${ssrRenderAttr("src", _ctx.bestInventory.store.get_logo)}${ssrRenderAttr("alt", _ctx.bestInventory.store.name)} loading="lazy">`);
        } else {
          _push(`<i class="ri-store-2-line shop"></i>`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "table-name lts-05",
          href: _ctx.route("main.stores.show", _ctx.bestInventory.store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.bestInventory.store.name)} <i class="ri-verified-badge-fill verify me-0"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.bestInventory.store.name) + " ", 1),
                createVNode("i", { class: "ri-verified-badge-fill verify me-0" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span></li>`);
      } else {
        _push(`<li><i class="ri-error-warning-line"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_seller"))}</span></li>`);
      }
      _push(`<li><i class="ri-qr-code-line"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))}</span><span class="divider"></span><span class="table-flag lts-05">${ssrInterpolate(_ctx.product.uuid)}</span></li>`);
      if (_ctx.bestInventory != null) {
        _push(`<li><i class="ri-checkbox-multiple-line"></i><span class="table-name lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.available_in_stock"))}</span><span class="divider"></span>`);
        if (_ctx.bestInventory.send_time != null && _ctx.bestInventory.send_time != "") {
          _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(_ctx.bestInventory.send_time)}</span>`);
        } else {
          _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
        }
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div><div class="divider mb-4"></div>`);
      if (_ctx.bestInventory != null) {
        _push(`<!--[--><div class="price-count-container mb-3"><div class="count-container"><span class="increase"><i class="ri-add-line"></i></span>`);
        _push(ssrRenderComponent(_sfc_main$m, {
          modelValue: count.value,
          "onUpdate:modelValue": ($event) => count.value = $event,
          onChange: changeCount,
          type: "text",
          name: "count",
          minlength: "1",
          maxlength: "4",
          autocomplete: "off"
        }, null, _parent));
        _push(`<span class="decrease"><i class="ri-subtract-line"></i></span></div><div class="price-container d-flex flex-column">`);
        if (_ctx.bestInventory.is_discount_valid) {
          _push(`<span class="product-price-old lts-05 mb-1"><span class="old-price color-secondary">${ssrInterpolate(_ctx.bestInventory.get_formatted_price)}</span><span class="discount-percent shadow-1 bg-secondary ms-1"><i class="ri-percent-fill"></i> ${ssrInterpolate(_ctx.bestInventory.get_discount_percent)}</span></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="product-price-now lts-05">${ssrInterpolate(_ctx.bestInventory.get_formatted_final_price)} <span class="unit"></span></span></div></div>`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button${ssrIncludeBooleanAttr(_ctx.addToCartProcessing) ? " disabled" : ""} class="${ssrRenderClass({ "add-to-cart btn btn-primary btn-block lts-05 mb-2": true, "shadow-primary": !_ctx.addToCartProcessing })}" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))} `);
          if (_ctx.addToCartProcessing) {
            _push(`<i class="ri-refresh-line i-spin"></i>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            as: "button",
            class: "add-to-cart btn btn-primary lts-05 mb-2",
            type: "button"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_to_cart")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`<div class="customer-club"><div class="checkout-row-label lts-05"><span class="d-flex align-items-center"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fs-7">${ssrInterpolate(_ctx.bestInventory.get_customer_club_score.score * count.value)}</span> <span class="fs-8 fw-light ms-1">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div><!--]-->`);
      } else {
        _push(`<!--[-->`);
        if (_ctx.product.in_stock_status) {
          _push(`<button disabled class="add-to-cart btn btn-primary lts-05 mb-2" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.product_is_not_available"))}</button>`);
        } else {
          _push(`<button class="add-to-cart btn btn-primary lts-05 mb-2" type="button" data-bs-toggle="modal" data-bs-target="#product-inquiry">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</button>`);
        }
        _push(`<div class="modal fade" id="product-inquiry" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><p class="d-flex mb-3 lts-05 lh-30">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478996"))}</p><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.cellular_phone"))}</td><td>${ssrInterpolate(_ctx.product.get_inquiry_options.cellular_phone)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.landline_phone"))}</td><td>${ssrInterpolate(_ctx.product.get_inquiry_options.landline_phone)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm fs-8 btn-light px-3">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><!--]-->`);
      }
      _push(`</div>`);
      if (_ctx.product.get_affiliate != null) {
        _push(`<div class="card shadow-1 mb-4">`);
        _push(ssrRenderComponent(_sfc_main$9, { product: _ctx.product }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductActionSidebar.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "ProductReviewTab",
  __ssrInlineRender: true,
  props: {
    product: {},
    scrollMode: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const descriptionStatus = ref({ active: !props.scrollMode, status: true });
    onMounted(() => {
      try {
        if (typeof window !== "undefined") {
          if (document.getElementById("review-content").offsetHeight <= 170) {
            descriptionStatus.value.active = true;
            descriptionStatus.value.status = false;
          }
        }
      } catch (e) {
      }
    });
    const getEmbed = () => {
      if (typeof window !== "undefined") {
        if (props.product.get_videos.embed != null) {
          var div = document.createElement("div");
          div.innerHTML = props.product.get_videos.embed;
          var elementsStyle = div.getElementsByTagName("style");
          if (elementsStyle[0] != null && elementsStyle[0].parentNode != null) {
            while (elementsStyle[0]) elementsStyle[0].parentNode.removeChild(elementsStyle[0]);
          }
          var elementsScript = div.getElementsByTagName("script");
          if (elementsScript[0] != null && elementsScript[0].parentNode != null) {
            while (elementsScript[0]) elementsScript[0].parentNode.removeChild(elementsScript[0]);
          }
          return div.innerHTML;
        } else {
          return null;
        }
      }
    };
    const getEmbedData = getEmbed();
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.product.content.length >= 15) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          id: "review-tab",
          class: "review-tab product-tab-content tab-content pb-2 mt-4"
        }, _attrs))}><div class="tab-content-title">${ssrInterpolate(_ctx.$t("messages.word.introduction"))}</div><div class="tab-content-description">${ssrInterpolate(_ctx.product.title_en)}</div>`);
        if (_ctx.product.get_videos.type == "url" && _ctx.product.get_videos.link != null && _ctx.product.get_videos.link != "") {
          _push(`<div class="product-video mb-4"><video id="movie" width="320" height="320" controls><source${ssrRenderAttr("src", _ctx.product.get_videos.link)} type="video/mp4"></video></div>`);
        } else if (_ctx.product.get_videos.type == "aparat" && _ctx.product.get_videos.embed != null) {
          _push(`<div class="product-video mb-4">${unref(getEmbedData) ?? ""}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="${ssrRenderClass(descriptionStatus.value.active ? "expandable-text active mb-3" : "expandable-text mb-3")}" style="${ssrRenderStyle({ "height": "200px" })}"><div class="review-content main-content" id="review-content">${_ctx.product.content ?? ""}</div><ul class="hashtags mb-3"><!--[-->`);
        ssrRenderList(_ctx.product.tags, (hashtag, index) => {
          _push(`<li class="mb-2">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.index", { tag: hashtag.slug })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(hashtag.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(hashtag.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        });
        _push(`<!--]--></ul>`);
        if (descriptionStatus.value.status) {
          _push(`<div class="${ssrRenderClass(descriptionStatus.value.active ? "expand-button expanded" : "expand-button")}"><span class="${ssrRenderClass(descriptionStatus.value.active ? "show-more d-none" : "show-more")}">${ssrInterpolate(_ctx.$t("messages.sentence.read_more"))} <i class="ri-arrow-down-s-line"></i></span><span class="${ssrRenderClass(descriptionStatus.value.active ? "show-less" : "show-less d-none")}">${ssrInterpolate(_ctx.$t("messages.word.close"))} <i class="ri-arrow-up-s-line"></i></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductReviewTab.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "ProductSpecificationsTab",
  __ssrInlineRender: true,
  props: {
    product: {},
    scrollMode: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const specificationStatus = ref({ active: !props.scrollMode, status: true });
    onMounted(() => {
      try {
        if (document.getElementById("specifications-list").offsetHeight <= 170) {
          specificationStatus.value.active = true;
          specificationStatus.value.status = false;
        }
      } catch (e) {
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.product.get_specifications.length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          id: "specifications-tab",
          class: "specifications-tab product-tab-content tab-content pb-2 mt-4"
        }, _attrs))}><div class="tab-content-title">${ssrInterpolate(_ctx.$t("messages.word.specifications"))}</div><div class="tab-content-description">${ssrInterpolate(_ctx.product.title_en)}</div><div class="${ssrRenderClass(specificationStatus.value.active ? "expandable-text active mb-3" : "expandable-text mb-3")}" style="${ssrRenderStyle({ "height": "230px" })}"><div id="specifications-list"><!--[-->`);
        ssrRenderList(_ctx.product.get_specifications, (specification) => {
          _push(`<div class="specifications-list mb-4"><div class="specifications-list-title mb-2">${ssrInterpolate(specification.title)}</div>`);
          if (specification.keys.length > 0) {
            _push(`<ul><!--[-->`);
            ssrRenderList(specification.keys, (item) => {
              _push(`<!--[-->`);
              if (item.value != null) {
                _push(`<li><span class="specifications-title">${ssrInterpolate(item.key)}</span><span class="specifications-value">${ssrInterpolate(item.value)}</span></li>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<!--]-->`);
            });
            _push(`<!--]--></ul>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
        if (specificationStatus.value.status) {
          _push(`<div class="${ssrRenderClass(specificationStatus.value.active ? "expand-button expanded" : "expand-button")}" style="${ssrRenderStyle({ "background-image": "linear-gradient(180deg, hsla(0, 0%, 100%, 0.1), #fff)", "height": "100px" })}"><span class="${ssrRenderClass(specificationStatus.value.active ? "show-more d-none" : "show-more")}">${ssrInterpolate(_ctx.$t("messages.sentence.read_more"))} <i class="ri-arrow-down-s-line"></i></span><span class="${ssrRenderClass(specificationStatus.value.active ? "show-less" : "show-less d-none")}">${ssrInterpolate(_ctx.$t("messages.word.close"))} <i class="ri-arrow-up-s-line"></i></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductSpecificationsTab.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "ProductCommentsTab",
  __ssrInlineRender: true,
  props: {
    product: {},
    comments: {}
  },
  emits: ["open-gallery"],
  setup(__props, { emit: __emit }) {
    const images = ref([]);
    const strengthsModel = ref("");
    let strengths = reactive([]);
    const weaknessModel = ref("");
    let weakness = reactive([]);
    let Rating = null;
    onMounted(() => {
      if (typeof window !== "undefined") {
        Rating = inject("Rating");
        new Rating(".star-rating", {
          tooltip: false
        });
      }
    });
    const addCommentForm = useForm({
      content: null,
      strengths,
      weakness,
      suggation: "",
      rating: null,
      images: null
    });
    const $queryStrings = (...args) => {
      let queryString = usePage().url;
      if (queryString.indexOf("?") === -1) {
        return {};
      }
      queryString = queryString.substring(queryString.indexOf("?") + 1);
      let object = Object.fromEntries(new URLSearchParams(queryString));
      for (let qs in object) {
        if (qs == "search") {
          continue;
        }
        delete object[qs];
      }
      return {
        search: Object.assign(object, ...args),
        all: Object.fromEntries(new URLSearchParams(queryString))
      };
    };
    const isActive = (key, value) => {
      let queryStrings = { ...$queryStrings().all };
      if (queryStrings.hasOwnProperty(key) && value) {
        return true;
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "comments-tab",
        class: "comments-tab product-tab-content tab-content pb-2 mt-4"
      }, _attrs))}><div class="tab-content-title">${ssrInterpolate(_ctx.$t("messages.sentence.users_comments_and_scores"))}</div><div class="tab-content-description">${ssrInterpolate(_ctx.product.title_en)}</div><div class="row"><div class="col-xl-3 col-lg-4 col-md-5 mb-3"><div class="comments-sidebar-sticky pt-5 z-index-0"><div class="comments-sidebar"><div class="comments-sidebar-rating"><div class="comments-sidebar-rating-main lts-05 me-2">${ssrInterpolate(_ctx.product.comments_info.rating)}</div><div class="comments-sidebar-rating-desc">از 5</div></div><div class="comments-sidebar-rating-bottom mb-3"><div class="stars-container justify-content-end"><div class="stars-text ms-2">${ssrInterpolate(_ctx.$t("messages.sentence.score_from_all_scores", { score: _ctx.product.comments_info.count }))}</div><div class="stars"><div class="stars-val" style="${ssrRenderStyle("width: " + _ctx.product.comments_info.rating_percent + "%")}"></div></div></div></div><div class="write-your-comment mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.send_your_comment_about_product"))}</div>`);
      if (_ctx.product.comment_status) {
        _push(`<!--[-->`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button class="btn btn-block btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#sendComment">${ssrInterpolate(_ctx.$t("messages.sentence.add_comment"))}</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            as: "button",
            class: "btn btn-block btn-outline-primary"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_comment"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_comment")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="comments-content col-xl-9 col-lg-8 col-md-7 pt-5"><div class="filter-comments mb-4"><div class="filter-comments-title me-2"><i class="ri-list-settings-fill me-1"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.filter_comments_by"))}:</span></div><div class="filter-comments-options">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, clatest: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("clatest", true) || !isActive("useful", true) && !isActive("buyers", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.latest_comments"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.latest_comments")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, useful: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("useful", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.helpful_comments"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.helpful_comments")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, buyers: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("buyers", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.buyers_comments"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.buyers_comments")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="comments"><!--[-->`);
      ssrRenderList(_ctx.comments.data, (comment) => {
        _push(`<div class="comment mb-3"><div class="comment-header d-flex align-item-center justify-content-between"><div><span>${ssrInterpolate(comment.user.get_name)}</span>`);
        if (comment.is_buyer) {
          _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="d-flex align-item-center dropdown"><span class="date">${ssrInterpolate(comment.jalali_created_at[3])}</span><i data-bs-toggle="dropdown" class="ri-more-2-fill dropdown-comment fs-7 ms-2"></i><div class="dropdown-menu shadow-smooth-2 mb-1 mt-1"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.comments.report", comment.id),
          method: "post",
          as: "button",
          "preserve-scroll": "",
          class: "dropdown-item lts-05 fs-8"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-flag-line text-danger fs-7 me-2"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.report_comment"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-flag-line text-danger fs-7 me-2" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.report_comment")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li></ul></div></div></div><div class="comment-body">`);
        if (comment.buy_suggest == "1") {
          _push(`<span class="suggestion suggest"><i class="ri-thumb-up-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_suggest"))}</span>`);
        } else if (comment.buy_suggest == "0") {
          _push(`<span class="suggestion not-suggest"><i class="ri-thumb-down-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_dont_suggest"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<p class="lts-05">${ssrInterpolate(comment.content)}</p><ul><!--[-->`);
        ssrRenderList(comment.get_strengths, (strength, index) => {
          _push(`<li class="comment-evaluation positive">${ssrInterpolate(strength)}</li>`);
        });
        _push(`<!--]--><!--[-->`);
        ssrRenderList(comment.get_weakness, (weakness2, index) => {
          _push(`<li class="comment-evaluation negative">${ssrInterpolate(weakness2)}</li>`);
        });
        _push(`<!--]--></ul>`);
        if (comment.get_images.length > 0) {
          _push(`<ul class="comment-images mt-4"><!--[-->`);
          ssrRenderList(comment.get_images, (image, index) => {
            _push(`<li class="image-grid clickable"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + image.url + ")")}"></div></div></div></li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_answer != null) {
          _push(`<div class="comment-answer mt-4"><span class="user-order-meta mb-2">${ssrInterpolate(comment.get_answer.user.name)} <span class="text-light-gray fs-10 ms-2">${ssrInterpolate(comment.get_answer.user.role.label)}</span></span><p class="fw-bold mb-0">${ssrInterpolate(comment.get_answer.content)}</p></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="comment-footer"><span class="me-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.is_this_comment_useful_for_you"))}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.comments.like", comment.id),
          method: "post",
          only: ["comments"],
          "preserve-scroll": "",
          as: "button",
          class: "comment-like"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(comment.vote_up)}`);
            } else {
              return [
                createTextVNode(toDisplayString(comment.vote_up), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.comments.dislike", comment.id),
          method: "post",
          only: ["comments"],
          "preserve-scroll": "",
          as: "button",
          class: "comment-dislike"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(comment.vote_down)}`);
            } else {
              return [
                createTextVNode(toDisplayString(comment.vote_down), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div>`);
      });
      _push(`<!--]-->`);
      if (_ctx.comments.data.length == 0) {
        _push(`<div class="list-empty-box w-100 d-flex align-item-center justify-content-center p-5 bg-light text-light-gray br-15"><p class="lts-05 fs-8 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_comment"))}</p></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.comments.data.length > 0) {
        _push(`<div class="w-100">`);
        _push(ssrRenderComponent(_sfc_main$n, {
          links: _ctx.comments.links,
          "preserve-scroll": true
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (_ctx.product.comment_status) {
        _push(`<div class="modal fade" id="sendComment" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><form method="post"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.send_your_comment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><div class="form-element-row product-name mb-3"><p class="lts-05"><span class="text-info fw-normal fs-8">${ssrInterpolate(_ctx.$t("messages.word.product"))}: </span>${ssrInterpolate(_ctx.product.title)}</p></div><div class="col-lg-12 col-12 mb-4"><div class="star-rating-container form-element-row"><label for="starRating" class="star-rating-title fw-bold form-label required lts-05 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.what_is_your_star_score_to_product"))}</label><select class="star-rating" id="starRating"><option value=""${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "") : ssrLooseEqual(unref(addCommentForm).rating, "")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.send_your_comment_about_product"))}</option><option value="5"${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "5") : ssrLooseEqual(unref(addCommentForm).rating, "5")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.word.best"))}</option><option value="4"${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "4") : ssrLooseEqual(unref(addCommentForm).rating, "4")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.word.good"))}</option><option value="3"${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "3") : ssrLooseEqual(unref(addCommentForm).rating, "3")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.word.average"))}</option><option value="2"${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "2") : ssrLooseEqual(unref(addCommentForm).rating, "2")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.word.weak"))}</option><option value="1"${ssrIncludeBooleanAttr(Array.isArray(unref(addCommentForm).rating) ? ssrLooseContain(unref(addCommentForm).rating, "1") : ssrLooseEqual(unref(addCommentForm).rating, "1")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("messages.word.awful"))}</option></select></div></div><div class="form-element-row mb-3"><label for="commentContent" class="form-label fw-bold required">${ssrInterpolate(_ctx.$t("messages.word.comment"))}</label><textarea id="commentContent" rows="3" name="content" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_comment") + " ...")}>${ssrInterpolate(unref(addCommentForm).content)}</textarea></div></div><div class="col-lg-6 col-12 mb-4"><div class="form-element-row mb-3"><label for="strengthsItems" class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.strengths"))}</label><div class="add-point-container" id="advantages"><div class="add-point-field"><input${ssrRenderAttr("value", strengthsModel.value)} id="strengthsItems" type="text" class="form-control" autocomplete="off"><button type="button" class="btn btn-square btn-sm btn-light btn-add-point"><i class="ri-add-line"></i></button></div><div class="comment-dynamic-labels advantages-list"><!--[-->`);
        ssrRenderList(unref(strengths), (strength, index) => {
          _push(`<div class="dynamic-label dynamic-label--positive">${ssrInterpolate(strength)} <button type="button" class="dynamic-label-remove"></button></div>`);
        });
        _push(`<!--]--></div></div></div></div><div class="col-lg-6 col-12 mb-4"><div class="form-element-row mb-3"><label for="weaknessItems" class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.weakness"))}</label><div class="add-point-container" id="disadvantages"><div class="add-point-field"><input${ssrRenderAttr("value", weaknessModel.value)} id="weaknessItems" type="text" class="form-control" autocomplete="off"><button type="button" class="btn btn-square btn-sm btn-light btn-add-point"><i class="ri-add-line"></i></button></div><div class="comment-dynamic-labels disadvantages-list"><!--[-->`);
        ssrRenderList(unref(weakness), (wk, index) => {
          _push(`<div class="dynamic-label dynamic-label--negative">${ssrInterpolate(wk)} <button type="button" class="dynamic-label-remove"></button></div>`);
        });
        _push(`<!--]--></div></div></div></div>`);
        if (_ctx.product.is_buyer) {
          _push(`<div class="col-12 mb-4"><div class="images-container"><div class="title fw-bold lts-05 mb-3"><div class="select-buyer-image me-2" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("data-bs-title", _ctx.$t("messages.sentence.add_image"))}><label type="button" class="btn btn-square btn-success btn-xs"><i class="ri-add-line"></i><input class="d-none" type="file" multiple accept=".png, .jpg, .jpeg"></label></div><span class="text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.add_image_purchased_product"))}</span></div><div class="image-grid-container"><!--[-->`);
          ssrRenderList(images.value, (image, index) => {
            _push(`<div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + image.preview + ")")}"></div></div></div><i class="remove-image ri-close-line"></i></div>`);
          });
          _push(`<!--]--></div>`);
          if (images.value.length == 0) {
            _push(`<span class="d-block fs-8 lts-05 text-gray mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.no_item_added_yet"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-lg-12 col-12 mb-3"><div class="suggestion-container form-element-row"><div class="suggestion-title fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.do_you_suggest_product"))}</div><div class="suggestion-box"><span class="${ssrRenderClass(unref(addCommentForm).suggation == "suggest" ? "suggest active lts-05" : "suggest lts-05")}"><i class="ri-thumb-up-fill"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_suggest_product"))}</span><span class="${ssrRenderClass(unref(addCommentForm).suggation == "not_suggest" ? "not-suggest active lts-05" : "not-suggest lts-05")}"><i class="ri-thumb-down-fill"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.i_dont_suggest_product"))}</span></div></div></div></div></div><div class="modal-footer d-flex align-item-center justify-content-between"><div class="modal-text lts-05 mt-3">${_ctx.$t("messages.sentence.action_mean_is_accept_terms", {
          terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
        }) ?? ""}</div><div class="mt-3"><button type="button" class="btn btn-sm btn-light px-3 me-2" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button${ssrIncludeBooleanAttr(unref(addCommentForm).processing) ? " disabled" : ""} type="submit" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.send_comment"))} `);
        if (unref(addCommentForm).processing) {
          _push(`<i class="ri-refresh-line i-spin"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</button></div></div></form></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductCommentsTab.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "ProductQuestionsTab",
  __ssrInlineRender: true,
  props: {
    product: {},
    questions: {}
  },
  setup(__props) {
    const addQuestionForm = useForm({
      question: null
    });
    const addAnswerForm = useForm({
      answer: null
    });
    const $queryStrings = (...args) => {
      let queryString = usePage().url;
      if (queryString.indexOf("?") === -1) {
        return {};
      }
      queryString = queryString.substring(queryString.indexOf("?") + 1);
      let object = Object.fromEntries(new URLSearchParams(queryString));
      for (let qs in object) {
        if (qs == "search") {
          continue;
        }
        delete object[qs];
      }
      return {
        search: Object.assign(object, ...args),
        all: Object.fromEntries(new URLSearchParams(queryString))
      };
    };
    const isActive = (key, value) => {
      let queryStrings = { ...$queryStrings().all };
      if (queryStrings.hasOwnProperty(key) && value) {
        return true;
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "question-tab",
        class: "question-tab comments-tab product-tab-content tab-content pb-2 mt-4"
      }, _attrs))}><div class="tab-content-title">${ssrInterpolate(_ctx.$t("messages.sentence.question_list"))}</div><div class="tab-content-description">${ssrInterpolate(_ctx.product.title_en)}</div><div class="row"><div class="col-xl-3 col-lg-4 col-md-5 mb-3"><div class="comments-sidebar-sticky pt-5 z-index-0"><div class="comments-sidebar"><div class="write-your-comment mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.express_your_questions_about_the_product"))}</div>`);
      if (_ctx.product.question_status) {
        _push(`<!--[-->`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button class="btn btn-block btn-outline-primary" type="button" data-bs-toggle="modal" data-bs-target="#sendQuestion">${ssrInterpolate(_ctx.$t("messages.sentence.send_question"))}</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            as: "button",
            class: "btn btn-block btn-outline-primary"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.send_question"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.send_question")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="comments-content col-xl-9 col-lg-8 col-md-7 pt-5"><div class="filter-comments mb-4"><div class="filter-comments-title me-2"><i class="ri-list-settings-fill me-1"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.filter_questions_by"))}:</span></div><div class="filter-comments-options">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, qlatest: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("qlatest", true) || !isActive("noanswer", true) && !isActive("answer", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.latest"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.latest")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, noanswer: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("noanswer", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.no_answer"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.no_answer")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.show", { product: _ctx.product.slug, answer: true }),
        as: "button",
        "preserve-scroll": "",
        "preserve-state": "",
        class: { "filter-comments-option lts-05": true, active: isActive("answer", true) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.with_answer"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.with_answer")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="comments"><!--[-->`);
      ssrRenderList(_ctx.questions.data, (question) => {
        _push(`<div class="comment mb-3"><div class="comment-body pt-0"><p class="lts-05"><i class="ri-question-line"></i> ${ssrInterpolate(question.question)}</p></div><!--[-->`);
        ssrRenderList(question.answers, (answer) => {
          _push(`<!--[-->`);
          if (answer.status == "publish") {
            _push(`<div class="answer"><span class="answer-title">${ssrInterpolate(_ctx.$t("messages.word.answer"))}</span><span class="answer-user-name">${ssrInterpolate(answer.user.get_name)} `);
            if (answer.user.type == "owner" || answer.user.type == "admin") {
              _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.admin"))}</span>`);
            } else if (answer.user.seller) {
              _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
            } else if (answer.is_buyer) {
              _push(`<span class="badge">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</span><p class="answer-content">${ssrInterpolate(answer.answer)}</p><div class="comment-footer"><span class="me-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.is_this_answer_useful_for_you"))}</span>`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.products.questions.answers.like", answer.id),
              method: "post",
              as: "button",
              only: ["questions"],
              "preserve-scroll": "",
              class: "comment-like"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(answer.vote_up)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(answer.vote_up), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.products.questions.answers.dislike", answer.id),
              method: "post",
              as: "button",
              only: ["questions"],
              "preserve-scroll": "",
              class: "comment-dislike"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(answer.vote_down)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(answer.vote_down), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><a class="send-answer-button lts-05" data-bs-toggle="collapse"${ssrRenderAttr("href", "#collapse-answer-" + question.id)} role="button" aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-answer-" + question.id)}>${ssrInterpolate(_ctx.$t("messages.sentence.send_new_answer"))} <i class="ri-arrow-left-s-line"></i></a><div class="send-answer collapse"${ssrRenderAttr("id", "collapse-answer-" + question.id)}><div class="rounded p-3"><form method="post"><div class="form-element-row mb-3"><span class="label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.answer_to_this_question"))}: </span><textarea id="answerField" rows="3" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_answer") + " ...")} name="answer">${ssrInterpolate(unref(addAnswerForm).answer)}</textarea></div><div class="d-flex align-items-center justify-content-between flex-wrap"><div class="description mb-2 lts-05">${_ctx.$t("messages.sentence.action_mean_is_accept_terms", {
          terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
        }) ?? ""}</div><div class="mb-2"><button class="${ssrRenderClass("btn btn-sm btn-simple-danger me-2 question-answer-close-" + question.id)}" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-answer-" + question.id)} aria-expanded="true"${ssrRenderAttr("aria-controls", "collapse-answer-" + question.id)}>${ssrInterpolate(_ctx.$t("messages.word.close"))}</button><button class="btn btn-sm btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</button></div></div></form></div></div></div>`);
      });
      _push(`<!--]-->`);
      if (_ctx.questions.data.length == 0) {
        _push(`<div class="list-empty-box w-100 d-flex align-item-center justify-content-center p-5 bg-light text-light-gray br-15"><p class="lts-05 fs-8 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_answer"))}</p></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.questions.data.length > 0) {
        _push(`<div class="w-100">`);
        _push(ssrRenderComponent(_sfc_main$n, {
          links: _ctx.questions.links,
          "preserve-scroll": true
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
      if (_ctx.product.question_status) {
        _push(`<div class="modal fade" id="sendQuestion" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.express_your_question_about_this_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="form-element-row mb-3"><textarea rows="3" name="answer" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_question") + " ...")}>${ssrInterpolate(unref(addQuestionForm).question)}</textarea></div><div class="modal-text lts-05">${_ctx.$t("messages.sentence.action_mean_is_accept_terms", {
          terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
        }) ?? ""}</div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(addQuestionForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))} `);
        if (unref(addQuestionForm).processing) {
          _push(`<i class="ri-refresh-line i-spin"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</button></div></form></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductQuestionsTab.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "ProductNavigationBottom",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    product: {},
    bestInventory: {}
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["addToCart"], ["update:modelValue"]),
  setup(__props, { emit: __emit }) {
    const props = __props;
    const count = useModel(__props, "modelValue");
    const changeCount = () => {
      if (props.bestInventory != null) {
        if (props.bestInventory.max_sale == null) {
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        } else if (count.value > props.bestInventory.max_sale) {
          count.value = Number(props.bestInventory.max_sale);
          if (count.value > props.bestInventory.count) {
            count.value = Number(props.bestInventory.count);
          }
        }
        if (count.value < props.bestInventory.min_sale) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    };
    watch(
      () => props.bestInventory,
      (first, second) => {
        if (props.bestInventory != null) {
          count.value = Number(props.bestInventory.min_sale);
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-navigation-bottom d-block d-sm-none" }, _attrs))}>`);
      if (_ctx.bestInventory != null) {
        _push(`<!--[--><div class="d-flex align-items-center justify-content-between mb-2 pb-1"><div class="link fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_product_props"))} <i class="ri-arrow-left-up-line ms-1"></i></div><div class="price-container d-flex white-space-nowrap ms-3">`);
        if (_ctx.bestInventory.is_discount_valid) {
          _push(`<span class="product-price-old lts-05"><span class="discount-percent bg-secondary shadow-1 ms-1"><i class="ri-percent-fill"></i> ${ssrInterpolate(_ctx.bestInventory.get_discount_percent)}</span></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="product-price-now lts-05">${ssrInterpolate(_ctx.bestInventory.get_formatted_final_price)} <span class="unit"></span></span></div></div><div class="d-flex align-items-center justify-content-between">`);
        if (_ctx.$page.props.auth.user != null) {
          _push(`<button class="add-to-cart flex-grow-1 btn btn-primary shadow-primary lts-05" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))}</button>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            as: "button",
            class: "add-to-cart flex-grow-1 btn btn-primary shadow-primary lts-05",
            type: "button"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_to_cart")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`<div class="price-count-container"><div class="count-container"><span class="increase"><i class="ri-add-line"></i></span>`);
        _push(ssrRenderComponent(_sfc_main$m, {
          modelValue: count.value,
          "onUpdate:modelValue": ($event) => count.value = $event,
          onChange: changeCount,
          type: "text",
          name: "count",
          minlength: "1",
          maxlength: "4",
          autocomplete: "off"
        }, null, _parent));
        _push(`<span class="decrease"><i class="ri-subtract-line"></i></span></div></div></div>`);
        if (_ctx.bestInventory.count < 5) {
          _push(`<span class="d-block text-danger lts-05 fs-10 mt-1" style="${ssrRenderStyle({ "position": "relative", "top": "5px" })}">${_ctx.$t("messages.sentence.product_inventory_count_notice_for_user", { count: _ctx.bestInventory.count.toString() }) ?? ""}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        if (_ctx.product.in_stock_status) {
          _push(`<button disabled class="add-to-cart btn btn-primary lts-05" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.product_is_not_available"))}</button>`);
        } else {
          _push(`<button class="add-to-cart btn btn-primary lts-05" type="button" data-bs-toggle="modal" data-bs-target="#product-inquiry">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</button>`);
        }
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductNavigationBottom.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "ProductDiscountExpire",
  __ssrInlineRender: true,
  props: {
    bestInventory: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.bestInventory != null && _ctx.bestInventory.is_discount_valid && _ctx.bestInventory.discount_expire != null) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-discount-expire" }, _attrs))}><span class="title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.special_sale"))}</span><div class="countdown-timer"><div data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", _ctx.$t("messages.sentence.product_timer_tooltip"))} class="timer">${unref(useCountdownTimer)(_ctx.bestInventory.discount_expire, "html") ?? ""}</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductDiscountExpire.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ProductCustomTab",
  __ssrInlineRender: true,
  props: {
    tab: {},
    tabIndex: {},
    scrollMode: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "tab-id-" + _ctx.tabIndex,
        class: "product-tab-content tab-content pb-2 mt-4"
      }, _attrs))}><div class="tab-content-title">${ssrInterpolate(_ctx.tab.title)}</div><div class="review-content main-content" id="review-content">${_ctx.tab.content ?? ""}</div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/Product/ProductCustomTab.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$o
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    seo: {},
    product: {},
    productProps: {},
    inventories: {},
    relatedProducts: {},
    comments: {},
    questions: {}
  },
  setup(__props) {
    var _a, _b;
    const props = __props;
    let activeProps = reactive(props.product.best_inventory != null ? props.product.best_inventory.raw_props : {});
    let activeInventories = ref([]);
    let bestInventory = ref(null);
    if (Object.keys(props.productProps).length === 0) {
      activeInventories.value = props.inventories;
    } else {
      props.inventories.map((inventory) => {
        if (Object.entries(inventory.raw_props).sort().toString() === Object.entries(activeProps).sort().toString()) {
          activeInventories.value.push(inventory);
        }
      });
      watch(
        activeProps,
        Debounce((value) => {
          let activeInventoriesTemp = [];
          props.inventories.map((inventory) => {
            if (Object.entries(inventory.raw_props).sort().toString() === Object.entries(value).sort().toString()) {
              activeInventoriesTemp.push(inventory);
            }
          });
          activeInventories.value = activeInventoriesTemp;
          activeInventories.value.sort(({ get_final_price: a }, { get_final_price: b }) => a - b);
          bestInventory.value = useMinObject(activeInventories.value, "get_final_price");
        }, 50)
      );
    }
    activeInventories.value.sort(({ get_final_price: a }, { get_final_price: b }) => a - b);
    bestInventory.value = useMinObject(activeInventories.value, "get_final_price");
    const count = ref(bestInventory.value != null ? Number(bestInventory.value.min_sale) : 1);
    const addToCartFormData = useForm({
      inventory_id: null,
      count: 1
    });
    const addToCart = (inventory_id, single_count) => {
      if (!addToCartFormData.processing) {
        if (bestInventory.value != null) {
          addToCartFormData.inventory_id = inventory_id;
          if (single_count != null) {
            addToCartFormData.count = single_count;
          } else {
            addToCartFormData.count = count.value;
          }
          addToCartFormData.post(route("cart.add", props.product.slug), {
            only: ["errors", "flash", "cart"],
            replace: true,
            preserveScroll: true,
            preserveState: false,
            onSuccess: () => {
              count.value = bestInventory.value != null ? Number(bestInventory.value.min_sale) : 1;
              addToCartFormData.reset();
              if (typeof usePage().props.flash !== "undefined") {
                const status = usePage().props.flash.add_to_cart;
                if (status != null) {
                  $("#openAddedToCart").trigger("click");
                }
              }
            }
          });
        } else {
          useToast(trans("messages.sentence.inventory_not_selected"), "fail");
        }
      }
    };
    const productMetaKey = ref(useRandomStr(10));
    watch(bestInventory, (value) => {
      productMetaKey.value = useRandomStr(10);
    });
    const relatedProductsData = reactive({
      product_list: {
        id: 458756,
        label: wTrans("messages.sentence.related_products"),
        archive: { cat: props.product.category.slug },
        products: props.relatedProducts
      }
    });
    const productImageGallery = ref(null);
    function handleOpenGallery(index) {
      var _a2;
      (_a2 = productImageGallery.value) == null ? void 0 : _a2.openGallery(index);
    }
    const scrollMode = ref(((_b = (_a = usePage().props.template.get_data.product) == null ? void 0 : _a.settings) == null ? void 0 : _b.tabs_status) ?? true);
    const activeTab = ref("review-tab");
    watch(activeTab, (value) => {
      console.log(value);
    });
    onMounted(async () => {
      if (props.product.model_3d != null && props.product.model_3d != "") {
        await import("@google/model-viewer");
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a3, _b2, _c, _d, _e, _f, _g, _h;
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.author != null) {
              _push2(`<meta name="author"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.image != null) {
              _push2(`<meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.availability != null) {
              _push2(`<meta property="og:availability"${ssrRenderAttr("content", _ctx.seo.availability)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.type != null) {
              _push2(`<meta property="og:type"${ssrRenderAttr("content", _ctx.seo.type)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:card" content="summary_large_image"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.author != null) {
              _push2(`<meta name="twitter:creator"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.image != null) {
              _push2(`<meta name="twitter:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema["product"])}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema["product"]), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema["breadcrumb"])}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema["breadcrumb"]), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="product_id"${ssrRenderAttr("content", _ctx.product.uuid)}${_scopeId}><meta name="product_name"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}><meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            if (_ctx.product.inventory && _ctx.product.in_stock_status) {
              _push2(`<meta name="product_price"${ssrRenderAttr("content", _ctx.product.best_price + "")}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.product.inventory && _ctx.product.in_stock_status && _ctx.product.has_discount) {
              _push2(`<meta name="product_old_price"${ssrRenderAttr("content", _ctx.product.best_inventory.price + "")}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="availability"${ssrRenderAttr("content", _ctx.product.inventory && _ctx.product.in_stock_status ? "instock" : "outofstock")}${_scopeId}>`);
            if (_ctx.product.inventory && _ctx.product.in_stock_status) {
              _push2(`<meta name="guarantee"${ssrRenderAttr("content", ((_b2 = (_a3 = _ctx.product.best_inventory) == null ? void 0 : _a3.raw_props) == null ? void 0 : _b2["گارانتی"]) ?? "اصالت و سلامت فیزیکی کالا")}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(bestInventory) != null) {
              _push2(`<meta name="spec"${ssrRenderAttr("content", "اصالت کالا:" + (((_c = unref(bestInventory)) == null ? void 0 : _c.original) ? "اصل" : "غیراصل"))}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(bestInventory) != null) {
              _push2(`<meta name="spec"${ssrRenderAttr("content", "وضعیت کالا:" + (((_d = unref(bestInventory)) == null ? void 0 : _d.used) ? "کارکرده" : "نو"))}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 2,
                name: "author",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 4,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 5,
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.availability != null ? (openBlock(), createBlock("meta", {
                key: 6,
                property: "og:availability",
                content: _ctx.seo.availability
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.type != null ? (openBlock(), createBlock("meta", {
                key: 7,
                property: "og:type",
                content: _ctx.seo.type
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:card",
                content: "summary_large_image"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 8,
                name: "twitter:creator",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 9,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 10,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 11,
                name: "twitter:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                name: "robots",
                content: "index, follow"
              }),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 12,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema["product"]), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 13,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema["breadcrumb"]), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true),
              createVNode("meta", {
                name: "product_id",
                content: _ctx.product.uuid
              }, null, 8, ["content"]),
              createVNode("meta", {
                name: "product_name",
                content: _ctx.seo.title
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"]),
              _ctx.product.inventory && _ctx.product.in_stock_status ? (openBlock(), createBlock("meta", {
                key: 14,
                name: "product_price",
                content: _ctx.product.best_price + ""
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.product.inventory && _ctx.product.in_stock_status && _ctx.product.has_discount ? (openBlock(), createBlock("meta", {
                key: 15,
                name: "product_old_price",
                content: _ctx.product.best_inventory.price + ""
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                name: "availability",
                content: _ctx.product.inventory && _ctx.product.in_stock_status ? "instock" : "outofstock"
              }, null, 8, ["content"]),
              _ctx.product.inventory && _ctx.product.in_stock_status ? (openBlock(), createBlock("meta", {
                key: 16,
                name: "guarantee",
                content: ((_f = (_e = _ctx.product.best_inventory) == null ? void 0 : _e.raw_props) == null ? void 0 : _f["گارانتی"]) ?? "اصالت و سلامت فیزیکی کالا"
              }, null, 8, ["content"])) : createCommentVNode("", true),
              unref(bestInventory) != null ? (openBlock(), createBlock("meta", {
                key: 17,
                name: "spec",
                content: "اصالت کالا:" + (((_g = unref(bestInventory)) == null ? void 0 : _g.original) ? "اصل" : "غیراصل")
              }, null, 8, ["content"])) : createCommentVNode("", true),
              unref(bestInventory) != null ? (openBlock(), createBlock("meta", {
                key: 18,
                name: "spec",
                content: "وضعیت کالا:" + (((_h = unref(bestInventory)) == null ? void 0 : _h.used) ? "کارکرده" : "نو")
              }, null, 8, ["content"])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_sfc_main$k, { product: _ctx.product }, null, _parent));
      _push(`<div class="container">`);
      _push(ssrRenderComponent(_sfc_main$j, { product: _ctx.product }, null, _parent));
      _push(`<div class="main-product-section mb-4"><div class="product-section"><div class="card shadow-1"><div class="row"><div class="product-gallery col-lg-4 col-md-6 pe-md-4 pe-2 mb-lg-0 mb-md-5 mb-2">`);
      _push(ssrRenderComponent(_sfc_main$2, { bestInventory: unref(bestInventory) }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$f, {
        key: productMetaKey.value,
        product: _ctx.product,
        bestInventory: unref(bestInventory)
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$g, {
        ref_key: "productImageGallery",
        ref: productImageGallery,
        product: _ctx.product,
        images: {
          official: _ctx.product.get_all_images || [],
          buyer: _ctx.product.get_buyer_images || []
        },
        bestInventory: unref(bestInventory)
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$d, {
        modelValue: unref(activeProps),
        "onUpdate:modelValue": ($event) => isRef(activeProps) ? activeProps.value = $event : activeProps = $event,
        product: _ctx.product,
        productProps: _ctx.productProps
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$c, {
        product: _ctx.product,
        activeInventories: unref(activeInventories),
        bestInventory: unref(bestInventory),
        modelValue: count.value,
        "onUpdate:modelValue": ($event) => count.value = $event,
        onAddToCart: (inventory_id) => addToCart(inventory_id),
        "add-to-cart-processing": unref(addToCartFormData).processing
      }, null, _parent));
      _push(`</div></div><div class="product-sidebar d-block d-md-none col-12 mt-4 ps-0">`);
      if (_ctx.product.get_affiliate != null) {
        _push(`<div class="card shadow-1">`);
        _push(ssrRenderComponent(_sfc_main$9, { product: _ctx.product }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$b, {
        activeInventories: unref(activeInventories),
        modelValue: count.value,
        "onUpdate:modelValue": ($event) => count.value = $event,
        onAddToCart: (inventory_id, single_count) => addToCart(inventory_id, single_count),
        "add-to-cart-processing": unref(addToCartFormData).processing
      }, null, _parent));
      if (((_a2 = relatedProductsData.product_list.products) == null ? void 0 : _a2.length) > 5) {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent("ProductList3"), {
          component_id: relatedProductsData.product_list.id,
          data: relatedProductsData,
          status: "prod"
        }, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="container"><div class="row product-base-content-container"><div class="product-content col-xl-9 col-lg-8 mb-4 mb-lg-0"><div class="card">`);
      _push(ssrRenderComponent(_sfc_main$a, {
        product: _ctx.product,
        "scroll-mode": scrollMode.value,
        "active-tab": activeTab.value,
        "active-tab-emit": activeTab.value,
        "onUpdate:activeTabEmit": ($event) => activeTab.value = $event
      }, null, _parent));
      if (scrollMode.value || activeTab.value === "review-tab") {
        _push(ssrRenderComponent(_sfc_main$7, {
          product: _ctx.product,
          "scroll-mode": scrollMode.value
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (scrollMode.value || activeTab.value === "specifications-tab") {
        _push(ssrRenderComponent(_sfc_main$6, {
          product: _ctx.product,
          "scroll-mode": scrollMode.value
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.product.get_tabs || [], (tab, index) => {
        _push(`<!--[-->`);
        if (scrollMode.value || activeTab.value === "tab-id-" + index) {
          _push(ssrRenderComponent(_sfc_main$1, {
            key: index,
            tab,
            tabIndex: index,
            "scroll-mode": scrollMode.value
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]-->`);
      if (scrollMode.value || activeTab.value === "comments-tab") {
        _push(`<!--[-->`);
        if (_ctx.product.comment_status) {
          _push(ssrRenderComponent(_sfc_main$5, {
            product: _ctx.product,
            comments: _ctx.comments,
            onOpenGallery: handleOpenGallery,
            "scroll-mode": scrollMode.value
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (scrollMode.value || activeTab.value === "question-tab") {
        _push(`<!--[-->`);
        if (_ctx.product.question_status) {
          _push(ssrRenderComponent(_sfc_main$4, {
            product: _ctx.product,
            questions: _ctx.questions,
            "scroll-mode": scrollMode.value
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      _push(ssrRenderComponent(_sfc_main$8, {
        product: _ctx.product,
        activeInventories: unref(activeInventories),
        bestInventory: unref(bestInventory),
        modelValue: count.value,
        "onUpdate:modelValue": ($event) => count.value = $event,
        onAddToCart: (inventory_id) => addToCart(inventory_id),
        "add-to-cart-processing": unref(addToCartFormData).processing
      }, null, _parent));
      _push(`</div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        product: _ctx.product,
        bestInventory: unref(bestInventory),
        modelValue: count.value,
        "onUpdate:modelValue": ($event) => count.value = $event,
        onAddToCart: (inventory_id) => addToCart(inventory_id)
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Products/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
