import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    prefactor: {},
    user: {},
    orderGroup: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.show_prefactor")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.show_prefactor")
      }, null, _parent));
      _push(`<div class="card orders order-groups-list list"><div class="card-body p-md-4 p-3"><div class="d-flex flex-column align-items-start justify-content-center mb-3"><div class="mb-2"><span class="text-gray lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.factor_id"))}: </span><span class="fw-bold text-dark">${ssrInterpolate(_ctx.prefactor.uuid)}</span></div><div><span class="text-gray lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.customer"))}: </span>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "link lts-05 fw-bold",
        href: _ctx.route("admin.users.show", _ctx.user.id)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.user.get_name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.user.get_name), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="d-block mb-4"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_584020"))}</span></div><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "min-width": "750px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.consignments"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.customer"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.main_status"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.registered_date"))}</th></tr></thead><tbody><tr><td class="orders-badge"><ul><!--[-->`);
      ssrRenderList(_ctx.orderGroup.orders, (order) => {
        _push(`<li class="d-inline-flex align-items-center justify-content-between"><div class="d-flex flex-column justify-content-center"><div class="lts-05 mb-1"><span class="fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_uuid"))}: </span><span class="fw-bold text-dark fs-8">${ssrInterpolate(order.uuid)}</span></div><div class="lts-05"><span class="fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.send_by"))}: </span>`);
        if (order.get_send_by == null) {
          _push(`<span class="text-dark fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.stores.show", order.get_send_by.uuid),
            class: "link fw-bold lts-05 fs-8"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(order.get_send_by.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(order.get_send_by.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        }
        _push(`</div></div><div class="d-flex flex-column justify-content-center ms-4"><div class="status lts-05 mb-1">`);
        if (order.status == "registered") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.word.processing"))}</span>`);
        } else if (order.status == "sent") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
        } else if (order.status == "delivered") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
        } else if (order.status == "cancelled") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else if (order.status == "returned") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.orders.show", order.id),
          as: "button",
          class: "btn btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.check"))}</span><i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(_ctx.$t("messages.word.check")), 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></li>`);
      });
      _push(`<!--]--></ul></td><td class="first-small white-space-nowrap">${ssrInterpolate(_ctx.orderGroup.uuid)}</td><td class="first-small white-space-nowrap">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.users.show", _ctx.orderGroup.user.id),
        class: "link fw-normal lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.orderGroup.user.get_name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.orderGroup.user.get_name), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</td><td class="first-small white-space-nowrap">`);
      if (_ctx.orderGroup.status == "processing") {
        _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.word.processing"))}</span>`);
      } else if (_ctx.orderGroup.status == "completed") {
        _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.completed"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</td><td class="first-small white-space-nowrap lts-05 fs-8">${ssrInterpolate(_ctx.orderGroup.jalali_created_at[2])}</td></tr></tbody></table></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/Prefactors/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
