import { defineComponent, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext, ref, onMounted, createVNode, resolveDynamicComponent, createBlock, createCommentVNode, openBlock } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrIncludeBooleanAttr, ssrRenderClass, ssrRenderVNode } from "vue/server-renderer";
import { _ as _sfc_main$c } from "./BlogLayout-BCPNogI1.js";
import { Link, router, useForm, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$a } from "./ArticleAuthor-DNW4KDqb.js";
import { _ as _sfc_main$b } from "./Pagination-C1AQrLe3.js";
import "jquery";
import Swiper from "swiper/bundle";
import { _ as _export_sfc } from "../ssr.js";
/* empty css                       */
/* empty css                           */
/* empty css             */
/* empty css              */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useRandomStr-4MeWbtRd.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper";
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  __name: "ArticleBreadcrumb",
  __ssrInlineRender: true,
  props: {
    article: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<nav${ssrRenderAttrs(mergeProps({
        class: "mb-3 simplebar-container",
        "aria-label": "breadcrumb"
      }, _attrs))}><ol class="breadcrumb mb-0" style="${ssrRenderStyle({ "min-width": "800px" })}"><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("blog.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$page.props.blogName)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$page.props.blogName), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("blog.articles.index", { cat: _ctx.article.category.slug })
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.article.category.title)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.article.category.title), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item active" aria-current="page">${ssrInterpolate(_ctx.$t("messages.word.article"))}</li></ol></nav>`);
    };
  }
});
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleBreadcrumb.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "ArticleMeta",
  __ssrInlineRender: true,
  props: {
    article: {}
  },
  setup(__props) {
    const props = __props;
    const isVoted = ref(props.article.is_voted);
    const voteCount = ref(props.article.vote);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "article--right-meta" }, _attrs))}><ul class="meta-list"><li>`);
      if (!isVoted.value) {
        _push(`<button><i class="ri-heart-line"></i><span>${ssrInterpolate(voteCount.value)}</span></button>`);
      } else {
        _push(`<!--[--><i class="ri-heart-fill text-danger"></i><span>${ssrInterpolate(voteCount.value)}</span><!--]-->`);
      }
      _push(`</li><li><i class="ri-message-3-fill"></i><span>${ssrInterpolate(_ctx.article.comments_info.count)}</span></li><li class="divider"></li><li><a${ssrRenderAttr("href", "https://telegram.me/share/url?url=" + _ctx.route("blog.articles.show", _ctx.article.slug))} target="_blank"><i class="ri-send-plane-2-fill"></i></a></li><li><a${ssrRenderAttr("href", "https://www.facebook.com/sharer/sharer.php?u=" + _ctx.route("blog.articles.show", _ctx.article.slug))} target="_blank"><i class="ri-facebook-box-fill"></i></a></li><li><a${ssrRenderAttr("href", "https://wa.me/?text=" + _ctx.route("blog.articles.show", _ctx.article.slug))} target="_blank"><i class="ri-whatsapp-line"></i></a></li><li><a${ssrRenderAttr("href", "https://twitter.com/intent/tweet?text=" + _ctx.route("blog.articles.show", _ctx.article.slug))} target="_blank"><i class="ri-twitter-x-fill"></i></a></li></ul></div>`);
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleMeta.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "ArticleTitle",
  __ssrInlineRender: true,
  props: {
    article: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "article--title mb-4" }, _attrs))}><h1>${ssrInterpolate(_ctx.article.title)}</h1><ul class="article--title-details mt-3 mb-0">`);
      if (_ctx.article.user.seller) {
        _push(`<li><img${ssrRenderAttr("alt", _ctx.article.user.store.name)}${ssrRenderAttr("src", _ctx.article.user.store.get_logo)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "article--meta-username",
          href: _ctx.route("blog.articles.index", { profile: _ctx.article.user.store.uuid })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.article.user.store.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.article.user.store.name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<li><img${ssrRenderAttr("alt", _ctx.article.user.name)}${ssrRenderAttr("src", _ctx.article.user.get_avatar)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "article--meta-username",
          href: _ctx.route("blog.articles.index", { profile: _ctx.article.user.username })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.article.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.article.user.get_name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      }
      _push(`<li class="divider"></li><li><span class="date">${ssrInterpolate(_ctx.article.jalali_created_at[0])}</span></li><li class="divider"></li><li><span class="date">${ssrInterpolate(_ctx.article.get_formatted_view_count)} ${ssrInterpolate(_ctx.$t("messages.word.view"))}</span></li></ul></div>`);
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleTitle.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "ArticleInformation",
  __ssrInlineRender: true,
  props: {
    article: {}
  },
  setup(__props) {
    onMounted(() => {
      $(".go-to-product").on("click", (e) => {
        let route = $(e.currentTarget).attr("route");
        router.visit(route, {
          replace: false
        });
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div class="article--image mb-3"><img class="shadow-1"${ssrRenderAttr("src", _ctx.article.get_image.url)}${ssrRenderAttr("alt", _ctx.article.title)} loading="lazy">`);
      if (_ctx.article.read_time != null) {
        _push(`<div class="read-time-badge shadow-1">${ssrInterpolate(_ctx.$t("messages.sentence.read_time"))}: <span>${ssrInterpolate(_ctx.article.read_time)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (_ctx.article.type == "podcast" && _ctx.article.get_podcast != null) {
        _push(`<div class="article--podcast card shadow-1 mb-3"><div class="card-body"><div class="article--podcast-title"><i class="ri-customer-service-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.podcast"))}</div><audio controls autoplay style="${ssrRenderStyle({ "width": "100%" })}"><source${ssrRenderAttr("src", _ctx.article.get_podcast)}> ${ssrInterpolate(_ctx.$t("messages.sentence.your_browser_not_support_media_player"))}</audio></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.type == "video" && _ctx.article.get_video != null) {
        _push(`<div class="article--podcast card shadow-1 mb-3"><div class="card-body"><div class="article--podcast-title"><i class="ri-film-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.video"))}</div><video id="movie" controls style="${ssrRenderStyle({ "width": "100%" })}"><source${ssrRenderAttr("src", _ctx.article.get_video)} type="video/mp4"> ${ssrInterpolate(_ctx.$t("messages.sentence.your_browser_not_support_media_player"))}</video></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="article--content main-content card shadow-1 mb-4"><div class="card-body">${_ctx.article.get_content ?? ""}</div><div class="hashtag-container"><ul class="hashtags mb-2"><!--[-->`);
      ssrRenderList(_ctx.article.tags, (tag) => {
        _push(`<li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index", { tag: tag.slug })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(tag.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(tag.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div><div class="text-dark pb-3 px-4"><span class="text-gray fs-8">${ssrInterpolate(_ctx.$t("messages.word.source"))}: </span>${ssrInterpolate(_ctx.article.source)}</div></div><div class="section-title mb-2"><div class="title no-after">${ssrInterpolate(_ctx.$t("messages.word.author"))}</div></div>`);
      _push(ssrRenderComponent(_sfc_main$a, {
        user: _ctx.article.user
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleInformation.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "ArticleComments",
  __ssrInlineRender: true,
  props: {
    article: {},
    comments: {}
  },
  setup(__props) {
    const sendCommentFrom = useForm({
      content: null,
      name: null,
      phone: null,
      reply_to: 0
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div id="article-comments" class="section-title mb-2"><div class="title no-after">${ssrInterpolate(_ctx.$t("messages.word.comments"))}</div></div>`);
      if (_ctx.article.comment_status) {
        _push(`<div class="comments-container card shadow-1 mb-3"><div class="card-body"><!--[-->`);
        ssrRenderList(_ctx.comments.data, (comment) => {
          _push(`<div class="comment card mb-3"><div class="card-body"><div class="comment--avatar">`);
          if (comment.user.seller) {
            _push(`<img class="shadow-1 mb-2"${ssrRenderAttr("src", comment.user.store.get_logo)}${ssrRenderAttr("alt", comment.user.store.name)} width="55" height="55" loading="lazy">`);
          } else {
            _push(`<img class="shadow-1 mb-2"${ssrRenderAttr("src", comment.user.get_avatar)}${ssrRenderAttr("alt", comment.user.get_name)} width="55" height="55" loading="lazy">`);
          }
          if (comment.user.type == "owner") {
            _push(`<div class="admin--badge">${ssrInterpolate(_ctx.$t("messages.word.owner"))}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (comment.user.type == "admin") {
            _push(`<div class="admin--badge">${ssrInterpolate(comment.user.role)}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (comment.user.seller) {
            _push(`<div class="admin--badge fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="comment--meta"><div class="comment--name">`);
          if (comment.user.seller) {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("blog.articles.index", { profile: comment.user.store.uuid }),
              style: { "text-decoration": "none" }
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span${_scopeId}>${ssrInterpolate(comment.user.store.name)}</span>`);
                } else {
                  return [
                    createVNode("span", null, toDisplayString(comment.user.store.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else if (comment.user.type == "owner" || comment.user.type == "admin") {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("blog.articles.index", { profile: comment.user.username }),
              style: { "text-decoration": "none" }
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span${_scopeId}>${ssrInterpolate(comment.user.get_name)}</span>`);
                } else {
                  return [
                    createVNode("span", null, toDisplayString(comment.user.get_name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<a href="javascript:void(0)" style="${ssrRenderStyle({ "text-decoration": "none" })}"><span>${ssrInterpolate(comment.user.get_name)}</span></a>`);
          }
          if (_ctx.$page.props.auth.user == null) {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
              class: "send-answer",
              style: { "text-decoration": "none" }
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.word.answer"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.word.answer")), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<div class="send-answer" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#send-answer-" + comment.id)}>${ssrInterpolate(_ctx.$t("messages.word.answer"))}</div>`);
          }
          _push(`</div><span class="date">${ssrInterpolate(comment.jalali_created_at[0])}</span><p class="comment--description mb-3">${ssrInterpolate(comment.content)}</p><!--[-->`);
          ssrRenderList(comment.answers, (answer) => {
            _push(`<div class="comment comment-answer card mb-2"><div class="card-body"><div class="comment--avatar">`);
            if (answer.user.seller) {
              _push(`<img class="shadow-1 mb-2"${ssrRenderAttr("src", answer.user.store.get_logo)}${ssrRenderAttr("alt", answer.user.store.name)} width="55" height="55" loading="lazy">`);
            } else {
              _push(`<img class="shadow-1 mb-2"${ssrRenderAttr("src", answer.user.get_avatar)}${ssrRenderAttr("alt", answer.user.get_name)} width="55" height="55" loading="lazy">`);
            }
            if (answer.user.type == "owner") {
              _push(`<div class="admin--badge">${ssrInterpolate(_ctx.$t("messages.word.owner"))}</div>`);
            } else {
              _push(`<!---->`);
            }
            if (answer.user.type == "admin") {
              _push(`<div class="admin--badge">${ssrInterpolate(answer.user.role)}</div>`);
            } else {
              _push(`<!---->`);
            }
            if (answer.user.seller) {
              _push(`<div class="admin--badge fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div><div class="comment--meta"><div class="comment--name">`);
            if (answer.user.seller) {
              _push(ssrRenderComponent(unref(Link), {
                href: _ctx.route("blog.articles.index", { profile: answer.user.store.uuid }),
                style: { "text-decoration": "none" }
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<span${_scopeId}>${ssrInterpolate(answer.user.store.name)}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(answer.user.store.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
            } else if (answer.user.type == "owner" || answer.user.type == "admin") {
              _push(ssrRenderComponent(unref(Link), {
                href: _ctx.route("blog.articles.index", { profile: answer.user.username }),
                style: { "text-decoration": "none" }
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<span${_scopeId}>${ssrInterpolate(answer.user.get_name)}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(answer.user.get_name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
            } else {
              _push(`<a href="javascript:void(0)" style="${ssrRenderStyle({ "text-decoration": "none" })}"><span>${ssrInterpolate(answer.user.get_name)}</span></a>`);
            }
            _push(`</div><span class="date">${ssrInterpolate(answer.jalali_created_at[0])}</span><p class="comment--description mb-3">${ssrInterpolate(answer.content)}</p><div class="comment--meta-details"><span class="is-usefull">${ssrInterpolate(_ctx.$t("messages.sentence.is_this_answer_useful"))}</span><div class="action">`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("blog.article.comments.like", answer.id),
              method: "post",
              "preserve-scroll": "",
              as: "button",
              only: ["comments"],
              class: "action--child like"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<i class="ri-thumb-up-fill"${_scopeId}></i> ${ssrInterpolate(answer.vote_up)}`);
                } else {
                  return [
                    createVNode("i", { class: "ri-thumb-up-fill" }),
                    createTextVNode(" " + toDisplayString(answer.vote_up), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("blog.article.comments.dislike", answer.id),
              method: "post",
              "preserve-scroll": "",
              as: "button",
              only: ["comments"],
              class: "action--child dislike"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<i class="ri-thumb-down-fill"${_scopeId}></i> ${ssrInterpolate(answer.vote_down)}`);
                } else {
                  return [
                    createVNode("i", { class: "ri-thumb-down-fill" }),
                    createTextVNode(" " + toDisplayString(answer.vote_down), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div></div></div></div></div>`);
          });
          _push(`<!--]--><div class="comment--meta-details"><span class="is-usefull">${ssrInterpolate(_ctx.$t("messages.sentence.is_this_comment_useful"))}</span><div class="action">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("blog.article.comments.like", comment.id),
            method: "post",
            "preserve-scroll": "",
            as: "button",
            only: ["comments"],
            class: "action--child like"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-thumb-up-fill"${_scopeId}></i> ${ssrInterpolate(comment.vote_up)}`);
              } else {
                return [
                  createVNode("i", { class: "ri-thumb-up-fill" }),
                  createTextVNode(" " + toDisplayString(comment.vote_up), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("blog.article.comments.dislike", comment.id),
            method: "post",
            "preserve-scroll": "",
            as: "button",
            only: ["comments"],
            class: "action--child dislike"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-thumb-down-fill"${_scopeId}></i> ${ssrInterpolate(comment.vote_down)}`);
              } else {
                return [
                  createVNode("i", { class: "ri-thumb-down-fill" }),
                  createTextVNode(" " + toDisplayString(comment.vote_down), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div></div></div><div class="modal fade send-answer-modal"${ssrRenderAttr("id", "send-answer-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5"><span>${ssrInterpolate(_ctx.$t("messages.sentence.answering_to"))}:</span> ${ssrInterpolate(comment.user.seller ? comment.user.store.name : comment.user.get_name)}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><form><div class="row"><div class="col-12 mb-2"><label class="mb-2" for="userCommentContent">${ssrInterpolate(_ctx.$t("messages.word.answer"))}</label><textarea class="form-control" name="content" id="userCommentContent"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_answer") + " ...")}>${ssrInterpolate(unref(sendCommentFrom).content)}</textarea></div><div class="col-12 comments---info fs-8 lts-05 mb-3">${_ctx.$t("messages.sentence.action_mean_is_accept_terms", {
            terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
          }) ?? ""}</div><div class="col-12 d-flex justify-content-end"><button${ssrIncludeBooleanAttr(unref(sendCommentFrom).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))} `);
          if (unref(sendCommentFrom).processing) {
            _push(`<i class="ri-refresh-line i-spin"></i>`);
          } else {
            _push(`<i class="ri-send-plane-2-line"></i>`);
          }
          _push(`</button></div></div></form></div></div></div></div></div>`);
        });
        _push(`<!--]-->`);
        if (_ctx.comments.data.length == 0) {
          _push(`<div class="list-empty-box w-100 d-flex align-item-center justify-content-center p-5 bg-light text-light-gray br-15"><p class="lts-05 fs-8 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_comment"))}</p></div>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.comments.data.length > 0) {
          _push(`<div class="w-100">`);
          _push(ssrRenderComponent(_sfc_main$b, {
            links: _ctx.comments.links,
            "preserve-scroll": true
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.comment_status) {
        _push(`<div class="comments-container card shadow-1 mb-4"><div class="card-body">`);
        if (_ctx.$page.props.auth.user == null) {
          _push(`<div class="comments-login-required d-flex align-items-center justify-content-between"><span class="fs-7 fw-bold lts-05 text-dark fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.for_send_comment_do_login"))}</span>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("login", { prev: _ctx.$page.props.ziggy.location }),
            class: "btn btn-primary lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.login"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.login")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<form><div class="row"><div class="col-12 mb-2"><label class="mb-2" for="userCommentContent">${ssrInterpolate(_ctx.$t("messages.word.comment"))}</label><textarea class="form-control" name="content" id="userCommentContent"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.what_do_you_think"))}>${ssrInterpolate(unref(sendCommentFrom).content)}</textarea></div><div class="col-12 comments---info fs-8 lts-05 mb-3">${_ctx.$t("messages.sentence.action_mean_is_accept_terms", {
            terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
          }) ?? ""}</div><div class="col-12 d-flex justify-content-end"><button${ssrIncludeBooleanAttr(unref(sendCommentFrom).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.send_comment"))} `);
          if (unref(sendCommentFrom).processing) {
            _push(`<i class="ri-refresh-line i-spin"></i>`);
          } else {
            _push(`<i class="ri-send-plane-2-line"></i>`);
          }
          _push(`</button></div></div></form>`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (!_ctx.article.comment_status) {
        _push(`<div class="comments-container card shadow-1 mb-3"><div class="card-body d-flex align-item-center justify-content-center"><span class="lts-05 fs-7 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_866584"))}</span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleComments.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "ArticleSingleSlider",
  __ssrInlineRender: true,
  props: {
    articles: {},
    component_id: {}
  },
  setup(__props) {
    const props = __props;
    const swiperArticleSingleSlider = () => {
      new Swiper(".swiper-single-article-slider-" + props.component_id, {
        slidesPerView: 1,
        spaceBetween: 5,
        autoplay: {
          delay: 6e3
        },
        loop: props.articles != null ? props.articles.length >= 1 ? true : false : false,
        navigation: {
          nextEl: ".grid-type-two-container .swiper-button-prev-" + props.component_id,
          prevEl: ".grid-type-two-container .swiper-button-next-" + props.component_id
        },
        observer: true
      });
    };
    onMounted(() => {
      swiperArticleSingleSlider();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "grid-type-two-container" }, _attrs))}><div class="section-title section-title-secondary d-flex align-items-center justify-content-between mb-3"><div class="d-flex align-items-center justify-content-between"><div class="title">${ssrInterpolate(_ctx.$t("messages.sentence.maybe_read"))}</div>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "more text-gray el-center ms-3 fs-10",
        href: _ctx.route("blog.articles.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.more"))} <i class="ri-arrow-left-s-line ms-1"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.more")) + " ", 1),
              createVNode("i", { class: "ri-arrow-left-s-line ms-1" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="swiper-slider-controller-container"><div class="swiper-slider-controller"><div class="${ssrRenderClass("swiper-button-prev swiper-button-prev-" + props.component_id)}"></div><span>|</span><div class="${ssrRenderClass("swiper-button-next swiper-button-next-" + props.component_id)}"></div></div></div></div><div class="card shadow-1 mb-4"><div class="card-body"><div class="row"><div class="col-12"><div class="${ssrRenderClass("swiper swiper-single-article-slider-" + props.component_id)}"><div class="swiper-wrapper"><!--[-->`);
      ssrRenderList(_ctx.articles, (article) => {
        _push(`<div class="swiper-slide"><div class="article"><div class="grid-thumbnail"><div class="grid-thumbnail--level-one"><div class="grid-thumbnail--level-two"><div class="image" style="${ssrRenderStyle(`background-image: url('${article.get_image.url}')`)}"></div></div></div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "article-link",
          href: _ctx.route("blog.articles.show", article.slug)
        }, null, _parent));
        _push(ssrRenderComponent(unref(Link), {
          class: "category-badge shadow-2",
          href: _ctx.route("blog.articles.index", { cat: article.category.slug })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.category.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.category.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div><ul class="article--meta mt-3 mb-0">`);
        if (article.user.seller) {
          _push(`<li><img${ssrRenderAttr("src", article.user.store.get_logo)}${ssrRenderAttr("alt", article.user.store.name)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
          _push(ssrRenderComponent(unref(Link), {
            class: "article--meta-username",
            href: _ctx.route("blog.articles.index", { profile: article.user.store.uuid })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(article.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(article.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li><img${ssrRenderAttr("src", article.user.get_avatar)}${ssrRenderAttr("alt", article.user.get_name)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
          _push(ssrRenderComponent(unref(Link), {
            class: "article--meta-username",
            href: _ctx.route("blog.articles.index", { profile: article.user.username })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(article.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(article.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        }
        _push(`<li class="divider d-xl-block d-none"></li><li class="d-xl-block d-none"><span class="date">${ssrInterpolate(article.jalali_created_at[0])}</span></li><li class="divider"></li><li><span class="date">${ssrInterpolate(article.get_formatted_view_count)} ${ssrInterpolate(_ctx.$t("messages.word.view"))}</span></li></ul><h3 class="article--title mb-0 mt-2">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.show", article.slug),
          class: "lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</h3><span class="date d-xl-none d-block">${ssrInterpolate(article.jalali_created_at[0])}</span></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleSingleSlider.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  _push(`<!--[-->`);
  ssrRenderList(_ctx.$page.props.template.get_blog_data.article.banners, (banner, index) => {
    _push(`<div class="single-banner card shadow-1 mb-4"><img${ssrRenderAttr("src", banner.url)}${ssrRenderAttr("alt", banner.alt)} loading="lazy"><a${ssrRenderAttr("href", banner.link)} target="_blank"></a></div>`);
  });
  _push(`<!--]-->`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleBanners.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const ArticleBanners = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "ArticleLatestList",
  __ssrInlineRender: true,
  props: {
    articles: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "grid-type-one-container grid-article-sidebar-container card shadow-1 mb-4" }, _attrs))}><div class="card-body"><div class="sidebar-card-inner-header"><div class="inner-card-container--title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.latest_articles"))}</div><span class="divider"></span></div><div class="article-lists"><!--[-->`);
      ssrRenderList(_ctx.articles, (article) => {
        _push(`<div class="small-article"><div class="grid-thumbnail"><div class="grid-thumbnail--level-one"><div class="grid-thumbnail--level-two"><div class="image" style="${ssrRenderStyle(`background-image: url('${article.get_image.url}')`)}"></div></div></div>`);
        if (article.type == "video") {
          _push(`<span class="type-badge"><i class="ri-film-fill"></i></span>`);
        } else {
          _push(`<!---->`);
        }
        if (article.type == "podcast") {
          _push(`<span class="type-badge"><i class="ri-customer-service-fill"></i></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(unref(Link), {
          class: "article-link",
          href: _ctx.route("blog.articles.show", article.slug)
        }, null, _parent));
        _push(`</div><div class="small-article--details"><h3>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.show", article.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</h3><ul class="article--meta">`);
        if (article.user.seller) {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "link",
            href: _ctx.route("blog.articles.index", { profile: article.user.store.uuid })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="date"${_scopeId}>${ssrInterpolate(article.user.store.name)}</span>`);
              } else {
                return [
                  createVNode("span", { class: "date" }, toDisplayString(article.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "link",
            href: _ctx.route("blog.articles.index", { profile: article.user.username })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="date"${_scopeId}>${ssrInterpolate(article.user.get_name)}</span>`);
              } else {
                return [
                  createVNode("span", { class: "date" }, toDisplayString(article.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        }
        _push(`<li class="divider"></li><li><span class="date">${ssrInterpolate(article.jalali_created_at[3])}</span></li></ul></div></div>`);
      });
      _push(`<!--]--></div></div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleLatestList.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ArticleHashtags",
  __ssrInlineRender: true,
  props: {
    hashtags: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "inner-card-container hashtag-container card shadow-1 mb-4" }, _attrs))}><div class="card-body"><div class="sidebar-card-inner-header"><div class="inner-card-container--title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.hot_hashtags"))}</div><span class="divider"></span></div><ul class="hashtags"><!--[-->`);
      ssrRenderList(_ctx.hashtags, (hashtag, index) => {
        _push(`<li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index", { tag: hashtag.slug })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(hashtag.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(hashtag.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleHashtags.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$c
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    seo: {},
    article: {},
    random_articles: {},
    latest_articles: {},
    hashtags: {},
    comments: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.author != null) {
              _push2(`<meta name="author"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.image != null) {
              _push2(`<meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.type != null) {
              _push2(`<meta property="og:type"${ssrRenderAttr("content", _ctx.seo.type)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:card" content="summary_large_image"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.author != null) {
              _push2(`<meta name="twitter:creator"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.image != null) {
              _push2(`<meta name="twitter:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema["article"])}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema["article"]), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema["breadcrumb"])}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema["breadcrumb"]), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 2,
                name: "author",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 4,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 5,
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.type != null ? (openBlock(), createBlock("meta", {
                key: 6,
                property: "og:type",
                content: _ctx.seo.type
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:card",
                content: "summary_large_image"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 7,
                name: "twitter:creator",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 8,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 9,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 10,
                name: "twitter:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                name: "robots",
                content: "index, follow"
              }),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 11,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema["article"]), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 12,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema["breadcrumb"]), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container article-page"><div class="row">`);
      _push(ssrRenderComponent(_sfc_main$9, { article: _ctx.article }, null, _parent));
      _push(`<div class="article-container col-lg-8 col-md-8">`);
      _push(ssrRenderComponent(_sfc_main$7, { article: _ctx.article }, null, _parent));
      _push(`<div class="article-main-container">`);
      _push(ssrRenderComponent(_sfc_main$8, { article: _ctx.article }, null, _parent));
      _push(`<div class="article--details">`);
      _push(ssrRenderComponent(_sfc_main$6, { article: _ctx.article }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$5, {
        article: _ctx.article,
        comments: _ctx.comments
      }, null, _parent));
      _push(`</div></div></div><div class="col-lg-4 col-md-4 blog-sidebar"><div class="blog-sidebar--inner">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        articles: _ctx.random_articles,
        component_id: "659852"
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$2, { articles: _ctx.latest_articles }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$1, { hashtags: _ctx.hashtags }, null, _parent));
      _push(ssrRenderComponent(ArticleBanners, null, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Blog/Articles/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
