import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import { u as useNumberFormat } from "../ssr.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    order: {}
  },
  setup(__props) {
    const props = __props;
    const Map = ref();
    const mapResult = props.order.get_address.type == "user" ? props.order.get_address.address.get_map : props.order.get_address.address.location;
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 1500);
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 2e3);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.order_details", { order: _ctx.order.uuid })
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title panel-content--title-with-button mb-2 lts-05"><div>${ssrInterpolate(_ctx.$t("messages.sentence.order_details", { order: _ctx.order.uuid }))}</div>`);
      if (_ctx.order.status == "sent" || _ctx.order.status == "delivered") {
        _push(`<div class="user-order-item-footer"><a${ssrRenderAttr("href", _ctx.route("user.orders.sales_factor", _ctx.order.id))} target="_blank" class="btn link fs-7"><i class="ri-file-list-3-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.get_factor"))}</a></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="orders-list mb-3"><div class="orders p-0"><div class="user-order-items"><div class="user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.status"))}: </span>`);
      if (_ctx.order.status == "registered") {
        _push(`<span class="badge bg-info text-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "sent") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "delivered") {
        _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "cancelled") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.status == "returned") {
        _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}: </span> ${ssrInterpolate(_ctx.order.uuid)}</span></div>`);
      if (_ctx.order.status == "sent") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.order.get_send_method["type"] == "post" && _ctx.order.get_send_method["item"]["uuid"] == "peyk" ? _ctx.$t("messages.sentence.courier_phone_number") : _ctx.$t("messages.sentence.post_tracking_code"))}: </span> ${ssrInterpolate(_ctx.order.post_tracking_code)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(_ctx.order.jalali_created_at[2])}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.price + _ctx.order.get_total_bill.discount))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.discount))}-</span>`);
      if (_ctx.order.get_total_bill.discount > 0) {
        _push(`<span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</span></div>`);
      if (_ctx.order.get_discount != null) {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.deduction_with_discount_code"))}: </span><span class="text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_discount["amount"]))}-</span><span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><i data-bs-toggle="modal" data-bs-target="#discountDetails" class="ri-information-line link ms-1"></i></span><div class="modal fade" id="discountDetails" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code_details"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.title"))}</td><td>${ssrInterpolate(_ctx.order.get_discount["information"]["title"])}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code"))}</td><td>${ssrInterpolate(_ctx.order.get_discount["information"]["code"])}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_send_method["type"] == "post") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}: </span>`);
        if (_ctx.order.get_send_method["free"]) {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.free"))}</span>`);
        } else {
          _push(`<span>`);
          if (_ctx.order.get_send_method["price"] != null) {
            _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_send_method["price"]))} <span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
          }
          _push(`</span>`);
        }
        _push(`</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}: </span> ${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.price + _ctx.order.get_total_bill.send_price - (_ctx.order.get_discount != null ? _ctx.order.get_discount["amount"] : 0)))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      if (_ctx.order.get_total_bill.cancel.price > 0) {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_cancelled_amount"))}: </span><span class="text-danger">${ssrInterpolate(_ctx.order.is_all_item_cancelled ? unref(useNumberFormat)(
          _ctx.order.get_total_bill.price + _ctx.order.get_total_bill.send_price - (_ctx.order.get_discount != null ? _ctx.order.get_discount["amount"] : 0)
        ) : unref(useNumberFormat)(_ctx.order.get_total_bill.cancel.price))}-</span><span class="currency text-danger">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="row send-details mb-4"><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_way"))}: </span> ${ssrInterpolate(_ctx.order.get_send_method["type"] == "post" ? _ctx.order.get_send_method["item"]["name"] : _ctx.$t("messages.sentence.receive_in_person"))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2">`);
      if (_ctx.order.get_address.type == "user") {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.first_name + " " + _ctx.order.get_address.address.last_name)}</span>`);
      } else {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_firstname"))}: </span> ${ssrInterpolate(_ctx.order.user.get_name)}</span>`);
      }
      _push(`</div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2">`);
      if (_ctx.order.get_address.type == "user") {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.phone)}</span>`);
      } else {
        _push(`<span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.sentence.recipient_phone"))}: </span> ${ssrInterpolate(_ctx.$page.props.auth.user.phone)}</span>`);
      }
      _push(`</div>`);
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="divider mb-3"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="col-12 mb-3"><span class="fw-bold text-dark fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.address_of_selected_receiving_center"))}:</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.state.replace("استان", ""))}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.city)}</span></div><div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.postal_code)}</span></div>`);
      if (_ctx.order.get_address.type == "shop") {
        _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span> ${ssrInterpolate(_ctx.order.get_address.address.phone)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-xl-3 col-lg-4 col-md-auto col-sm-6 mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.map"))}: </span><span class="link" data-bs-toggle="modal" data-bs-target="#showMap">${ssrInterpolate(_ctx.$t("messages.word.display"))} <i class="ri-map-pin-2-line ms-1"></i></span></span><div class="modal fade" id="showMap" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.map"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "Map",
        ref: Map,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(mapResult),
        zoom: unref(mapResult).zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        class: "map"
      }, null, _parent));
      _push(`<div class="readonly-map"></div></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div><div class="col-12 user-order-item-header--meta"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(_ctx.order.get_address.address.full_address)}</span></span></div></div>`);
      if (_ctx.order.description != null) {
        _push(`<div class="row mb-4"><div class="col-12"><div class="card bg-light"><div class="card-body py-3"><div class="title fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.order_description"))}</div><div class="lts-05 lh-25">${unref(useNl2br)(_ctx.order.description) ?? ""}</div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="user-order-item-content mb-4"><div class="mb-1 mt-2 mb-4"><div class="fw-bold text-dark"><i class="ri-pantone-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.consignments_information"))}</div></div><!--[-->`);
      ssrRenderList(_ctx.order.consignments, (consignment, index) => {
        _push(`<div class="consignment-section mb-4"><div class="d-flex align-items-start justify-content-between flex-sm-row flex-column mb-3 mb-sm-0"><span class="consignment-section-header fw-bold d-block fs-8 mb-2 mb-sm-3">`);
        if (consignment.store != null) {
          _push(`<!--[--><span class="me-1">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_of_store"))}:</span>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.stores.show", consignment.store.uuid),
            class: "link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(consignment.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(consignment.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<!--]-->`);
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
        }
        _push(`</span></div><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "min-width": "750px", "width": "100%" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.paid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
        ssrRenderList(consignment.consignment_items, (item) => {
          _push(`<tr><td class="first-small">`);
          if (item.product != null) {
            _push(`<img class="br-10" width="35" height="35"${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.get_images[0]["alt"])}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td><td>`);
          if (item.product != null) {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.products.show", item.product.slug),
              class: "product-title product-title-min-300 link fw-normal mb-2"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(item.product.title)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(item.product.title), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<a href="javascript:void(0)" class="product-title product-title-min-300 link fw-normal mb-2">${ssrInterpolate(item.title)}</a>`);
          }
          _push(`<ul class="list-of-props-for-table"><!--[-->`);
          ssrRenderList(item.get_props, (prop, index2) => {
            _push(`<!--[-->`);
            if (prop.type == "color") {
              _push(`<li><span class="text-gray fs-9">${ssrInterpolate(_ctx.$t("messages.word.color"))}:</span><span class="raw-circle d-inline-block ms-1" style="${ssrRenderStyle("background-color:" + prop["value"]["color"])}"></span><span class="fs-9 ms-1">${ssrInterpolate(prop["value"]["label"])}</span></li>`);
            } else {
              _push(`<li><span class="text-gray fs-9">${ssrInterpolate(prop["name"])}:</span><span class="fs-9 ms-1">${ssrInterpolate(prop["value"])}</span></li>`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></ul></td><td class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(item.get_full_count_price))} <span class="unit unit-sm"></span></td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td><td class="first-small lts-05" style="${ssrRenderStyle({ "width": "100px" })}">`);
          if (item.status == "sent") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
          } else if (item.status == "delivered") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
          } else if (item.status == "cancelled") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
          } else if (item.status == "returned") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
          } else {
            _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
          }
          _push(`</td>`);
          if (item.status == "cancelled") {
            _push(`<td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#cancellation-reason-" + item.id)} class="dropdown-item no-btn"><i class="ri-information-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "cancellation-reason-" + item.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5 text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.product_cancellation_reason"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="row"><div class="col-12 mb-4"><span class="lts-05 lh-30">${unref(useNl2br)(item.reason) ?? ""}</span></div></div></div></div></div><div class="modal-footer"><button class="btn btn-light" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></td>`);
          } else {
            _push(`<td>-</td>`);
          }
          _push(`</tr>`);
        });
        _push(`<!--]--></tbody></table></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Orders/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
