import { defineComponent, ref, unref, withCtx, createVNode, resolveDynamicComponent, createTextVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderVNode, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { a as _sfc_main$2, b as _sfc_main$3, c as _sfc_main$4, d as _sfc_main$5 } from "../ssr.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import { wTrans } from "laravel-vue-i18n";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    seo: {},
    brand: {},
    latest_products: {},
    popular_products: {},
    discounted_products: {},
    latest_articles: {}
  },
  setup(__props) {
    const props = __props;
    const brandLatestProducts = ref({
      status: "prod",
      component_id: useRandomStr(6),
      data: {
        product_list: {
          id: useRandomStr(6),
          label: wTrans("messages.sentence.brand_latest_products"),
          archive: { brand: props.brand.slug },
          products: props.latest_products
        }
      }
    });
    const brandPopularProducts = ref({
      status: "prod",
      component_id: useRandomStr(6),
      data: {
        product_list: {
          id: useRandomStr(6),
          label: wTrans("messages.sentence.brand_popular_products"),
          archive: { brand: props.brand.slug, popular: true },
          products: props.popular_products
        }
      }
    });
    const brandDiscountedProducts = ref({
      status: "prod",
      component_id: useRandomStr(6),
      data: {
        product_list: {
          id: useRandomStr(6),
          label: wTrans("messages.sentence.brand_discounted_products"),
          archive: { brand: props.brand.slug, discount: true },
          products: props.discounted_products
        }
      }
    });
    const brandLatestArticles = ref({
      status: "prod",
      component_id: useRandomStr(6),
      data: {
        article_list: {
          id: useRandomStr(6),
          label: wTrans("messages.sentence.brand_latest_articles"),
          archive: { brand: props.brand.slug },
          articles: props.latest_articles
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.image != null) {
              _push2(`<meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.type != null) {
              _push2(`<meta property="og:type"${ssrRenderAttr("content", _ctx.seo.type)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:card" content="summary_large_image"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.image != null) {
              _push2(`<meta name="twitter:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 2,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 4,
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.type != null ? (openBlock(), createBlock("meta", {
                key: 5,
                property: "og:type",
                content: _ctx.seo.type
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:card",
                content: "summary_large_image"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 6,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 7,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 8,
                name: "twitter:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                name: "robots",
                content: "index, follow"
              }),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 9,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container brand-page"><div class="row mb-3"><div class="col-12">`);
      if (_ctx.brand.get_banner != null) {
        _push(`<div class="brand-header card mb-5"><div class="image"><img${ssrRenderAttr("src", _ctx.brand.get_banner)}${ssrRenderAttr("alt", _ctx.brand.title)}></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="brand-details mb-3"><div class="header-information"><div class="card"><img width="100" height="100"${ssrRenderAttr("src", _ctx.brand.get_logo)}${ssrRenderAttr("alt", _ctx.brand.title)} loading="lazy"><div class="top-bar"><div class="title"><h1>${ssrInterpolate(_ctx.$t("messages.word.brand"))} ${ssrInterpolate(_ctx.brand.title)} `);
      if (_ctx.brand.title_en != null) {
        _push(`<!--[--><span>|</span> ${ssrInterpolate(_ctx.brand.title_en)}<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</h1><p class="brand-en-name-responsive" style="${ssrRenderStyle({ "display": "none" })}">${ssrInterpolate(_ctx.brand.title_en)}</p><div class="left"><p>${ssrInterpolate(_ctx.$t("messages.sentence.products_count"))}: ${ssrInterpolate(_ctx.brand.products_count)}</p><a${ssrRenderAttr("href", _ctx.brand.website)} class="btn btn-gray" target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.official_website"))}</a></div></div><p class="brand-en-name-main">Product Brand</p><div class="categories"><ul><!--[-->`);
      ssrRenderList(_ctx.brand.get_categories, (category) => {
        _push(`<li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { cat: category.slug, brand: _ctx.brand.slug })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(category.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(category.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div></div></div></div></div></div></div></div>`);
      if (_ctx.latest_products.length > 0) {
        _push(`<div class="col-12 mb-3">`);
        _push(ssrRenderComponent(_sfc_main$2, {
          status: brandLatestProducts.value.status,
          component_id: brandLatestProducts.value.component_id,
          data: brandLatestProducts.value.data
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.popular_products.length > 2) {
        _push(`<div class="col-12">`);
        _push(ssrRenderComponent(_sfc_main$3, {
          status: brandPopularProducts.value.status,
          component_id: brandPopularProducts.value.component_id,
          data: brandPopularProducts.value.data
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.discounted_products.length > 2) {
        _push(`<div class="col-12">`);
        _push(ssrRenderComponent(_sfc_main$4, {
          status: brandDiscountedProducts.value.status,
          component_id: brandDiscountedProducts.value.component_id,
          data: brandDiscountedProducts.value.data
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.latest_articles.length > 0) {
        _push(`<div class="col-12">`);
        _push(ssrRenderComponent(_sfc_main$5, {
          status: brandLatestArticles.value.status,
          component_id: brandLatestArticles.value.component_id,
          data: brandLatestArticles.value.data
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.brand.content != null && _ctx.brand.content.length > 10) {
        _push(`<div class="container"><div class="row"><div class="col-12 mb-4"><div class="card"><div class="card-body p-4"><div class="main-content">${_ctx.brand.content ?? ""}</div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Brand/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
