import { defineComponent, mergeModels, useModel, mergeProps, useSSRContext, ref, onMounted, inject, unref, withCtx, createVNode, createBlock, createCommentVNode, openBlock, createTextVNode, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderAttr, ssrRenderClass, ssrRenderList, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./MainLayout-CahYFWjG.js";
import { useForm, usePage, Head, Link } from "@inertiajs/vue3";
import { u as useRandomNum } from "./useRandomNum-DNNSqR7b.js";
import { _ as _sfc_main$2 } from "./NumInput-Bt6uFGO4.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Captcha",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    captcha_args: {}
  }, {
    "modelValue": { required: true },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const model = useModel(__props, "modelValue");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "custom-captcha-container" }, _attrs))}>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: model.value,
        "onUpdate:modelValue": ($event) => model.value = $event,
        type: "text"
      }, null, _parent));
      _push(`<span style="${ssrRenderStyle({ "text-align": "left", "direction": "ltr" })}">${ssrInterpolate(_ctx.captcha_args.first + " + " + _ctx.captcha_args.two + " = ")}</span></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Captcha.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$3
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    form: {},
    seo: {}
  },
  setup(__props) {
    const props = __props;
    const sendAnswerForm = useForm({
      captcha_args: {
        first: useRandomNum(1, 20),
        two: useRandomNum(1, 20)
      },
      captcha: null,
      answer: props.form.get_fields
    });
    let NeshanMap = null;
    let Map = null;
    let mapAddress = usePage().props.shopMapLocation;
    const mapLoaded = ref(false);
    onMounted(() => {
      if (typeof window !== "undefined") {
        NeshanMap = inject("NeshanMap");
        Map = ref();
        mapLoaded.value = true;
        setTimeout(() => {
          var _a;
          (_a = Map.value) == null ? void 0 : _a.reverse([mapAddress.longitude, mapAddress.latitude], {
            useMarker: true
          });
        }, 1e3);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}><meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 2,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 4,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 5,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                name: "robots",
                content: "index, follow"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container"><div class="row mb-3"><div class="col-12"><div class="card main-forms"><div class="card-body ps-md-5 ps-4 pe-md-5 pe-4 p-4"><h1 class="fs-5 fw-bold mb-3">${ssrInterpolate(_ctx.form.title)}</h1>`);
      if (_ctx.form.description != null && _ctx.form.description != "") {
        _push(`<div class="main-content mb-5">${_ctx.form.description ?? ""}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="row"><div class="${ssrRenderClass({ "col-12": true, "col-sm-6": _ctx.$page.props.currentUrl.includes("/contact-us") })}"><form class="row"><!--[-->`);
      ssrRenderList(_ctx.form.get_fields, (field, index) => {
        _push(`<!--[-->`);
        if (field.type == "text") {
          _push(`<div class="col-sm-6 col-12 mb-4"><label${ssrRenderAttr("for", "form-field-" + index)} class="form-label">${ssrInterpolate(field.title)}</label><input${ssrRenderAttr("value", unref(sendAnswerForm).answer[index]["value"])} type="text"${ssrRenderAttr("placeholder", field.title)}${ssrIncludeBooleanAttr(field.status == "necessary") ? " required" : ""} class="form-control"${ssrRenderAttr("id", "form-field-" + index)}></div>`);
        } else {
          _push(`<!---->`);
        }
        if (field.type == "textarea") {
          _push(`<div class="col-12 mb-4"><label${ssrRenderAttr("for", "form-field-" + index)} class="form-label">${ssrInterpolate(field.title)}</label><textarea type="text" rows="5"${ssrRenderAttr("placeholder", field.title)}${ssrIncludeBooleanAttr(field.status == "necessary") ? " required" : ""} class="form-control"${ssrRenderAttr("id", "form-field-" + index)}>${ssrInterpolate(unref(sendAnswerForm).answer[index]["value"])}</textarea></div>`);
        } else {
          _push(`<!---->`);
        }
        if (field.type == "checkbox") {
          _push(`<div class="col-sm-6 col-12 form-check form-switch mb-4 ms-3"><label${ssrRenderAttr("for", "form-field-" + index)} class="form-label clickable">${ssrInterpolate(field.title)}</label><input${ssrIncludeBooleanAttr(Array.isArray(unref(sendAnswerForm).answer[index]["value"]) ? ssrLooseContain(unref(sendAnswerForm).answer[index]["value"], null) : unref(sendAnswerForm).answer[index]["value"]) ? " checked" : ""} type="checkbox"${ssrRenderAttr("placeholder", field.title)} class="form-check-input clickable"${ssrRenderAttr("id", "form-field-" + index)}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--><div class="col-12 d-flex justify-content-between">`);
      _push(ssrRenderComponent(_sfc_main$1, {
        modelValue: unref(sendAnswerForm).captcha,
        "onUpdate:modelValue": ($event) => unref(sendAnswerForm).captcha = $event,
        captcha_args: unref(sendAnswerForm).captcha_args
      }, null, _parent));
      _push(`<div>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        type: "submit",
        class: "btn btn-light me-2"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<button type="submit" class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.word.send"))}</button></div></div></form></div>`);
      if (_ctx.$page.props.currentUrl.includes("/contact-us") && mapLoaded.value) {
        _push(`<div class="col-12 col-sm-6 ps-sm-5 ps-3 mt-sm-0 mt-5"><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(mapAddress),
          zoom: unref(mapAddress).zoom,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          class: "map"
        }, null, _parent));
        _push(`<div class="readonly-map"></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Forms/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
