import { defineComponent, onMounted, ref, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, createVNode, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderClass, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./FormatedNumInput-D4wHj270.js";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import SimpleBar from "simplebar";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    store: {},
    user: {},
    consignments: {},
    transactions: {},
    tickets: {},
    keyword: {},
    priorityList: {}
  },
  setup(__props) {
    const props = __props;
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
        $(".tickets-container .simplebar-content-wrapper").scrollTop($(".tickets-container .simplebar-content").prop("scrollHeight"));
      });
    }
    const createTicketForm = useForm({
      title: null,
      priority: "normal",
      content: null,
      user_id: props.user.id
    });
    const editWalletForm = useForm({
      amount: props.user.wallet.get_formatted_amount
    });
    const Map = ref();
    const mapResult = props.store.get_information.map;
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 1500);
    setTimeout(() => {
      var _a;
      (_a = Map.value) == null ? void 0 : _a.reverse([mapResult.longitude, mapResult.latitude], {
        useMarker: true
      });
    }, 2e3);
    const rejectStoreFrom = useForm({
      status: "reject",
      reason: ""
    });
    const banStoreFrom = useForm({
      status: "banned",
      reason: ""
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b;
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.manage_store")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.manage_store")
      }, null, _parent));
      _push(`<div class="store-details row mb-4"><div class="col-lg-4 col-md-5 col-12"><div class="user-profile mb-4"><div class="card"><div class="card-body"><div class="top-pattern"></div><div class="user-avatar d-flex align-items-end justify-content-start"><img class="ms-4 shadow-smooth-1" width="110" height="110"${ssrRenderAttr("src", _ctx.store.get_logo)}${ssrRenderAttr("alt", _ctx.store.name)}>`);
      if (_ctx.store.status == "banned") {
        _push(`<div class="details shadow-smooth-2 ms-2"><span class="lts-05 text-danger">${ssrInterpolate(_ctx.$t("messages.word.banned"))}</span></div>`);
      } else if (_ctx.store.status == "awaiting") {
        _push(`<div class="details shadow-smooth-2 ms-2"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></div>`);
      } else if (_ctx.store.status == "reject") {
        _push(`<div class="details shadow-smooth-2 ms-2"><span class="lts-05 text-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span></div>`);
      } else if (_ctx.store.status == "active") {
        _push(`<div class="details shadow-smooth-2 ms-2"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.active"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="row p-3"><div class="col-12 d-flex align-items-center justify-content-between mb-3"><div><div class="user-name mb-1"><a class="link text-dark" target="_blank"${ssrRenderAttr("href", _ctx.route("main.stores.show", _ctx.store.uuid))}>${ssrInterpolate(_ctx.store.name)} <i class="ri-external-link-fill fs-9 ms-1 text-info"></i></a></div><div class="user-phone">${ssrInterpolate(_ctx.store.uuid)}</div></div></div><div class="col-12 user-bio"><span>${ssrInterpolate(_ctx.$t("messages.word.biography"))}:</span><p class="lts-05">${ssrInterpolate(_ctx.store.bio != null && _ctx.store.bio != "" ? _ctx.store.bio : _ctx.$t("messages.word.empty"))}</p></div><div class="col-12 mb-3"><div class="divider"></div></div><div class="meta-text col-12 d-flex align-items-center justify-content-between mb-3"><div class="key d-flex align-items-center lts-05"><i class="ri-user-3-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.seller"))}: </div><div class="value fw-bold">`);
      _push(ssrRenderComponent(unref(Link), {
        class: "link",
        href: _ctx.route("admin.users.show", _ctx.user.id)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.user.get_name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.user.get_name), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="meta-text col-12 d-flex align-items-center justify-content-between mb-3"><div class="key d-flex align-items-center lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.account_type"))}:</div><div class="value">${ssrInterpolate(_ctx.store.type == "legal" ? _ctx.$t("messages.word.legal") : _ctx.$t("messages.word.genuine"))}</div></div><div class="col-12 mb-3"><div class="divider"></div></div><div class="col-12 d-flex align-items-center justify-content-between mb-3"><div class="meta-icon d-flex align-items-center"><i class="ri-wallet-3-line"></i><div class="ms-2"><span>${ssrInterpolate(_ctx.$t("messages.sentence.wallet_amount"))}</span><div>${ssrInterpolate(_ctx.user.wallet.get_formatted_amount)} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></div>`);
      if (_ctx.$page.props.auth.user.type == "owner") {
        _push(`<span class="link edit-wallet-link" data-bs-toggle="modal" data-bs-target="#edit-wallet-amount">${ssrInterpolate(_ctx.$t("messages.sentence.edit_amount"))}</span>`);
      } else {
        _push(`<span class="link edit-wallet-link">${ssrInterpolate(_ctx.$t("messages.sentence.edit_amount"))}</span>`);
      }
      _push(`<div class="modal fade" id="edit-wallet-amount" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_seller_wallet_amount"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><label for="eaWalletAmount" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.inventory"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editWalletForm).amount,
        "onUpdate:modelValue": ($event) => unref(editWalletForm).amount = $event,
        type: "text",
        required: "",
        class: "form-control",
        id: "eaWalletAmount"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-0"><p class="form-control-description"><strong class="fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_411256"))}</p></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(editWalletForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div></div><div class="col-12 mb-3"><div class="divider"></div></div><div class="col-12 mb-3"><ul class="user-information"><li><span>${ssrInterpolate(_ctx.$t("messages.sentence.statistical_information"))}: </span><div class="link" data-bs-toggle="modal" data-bs-target="#show-statistical-information">${ssrInterpolate(_ctx.$t("messages.word.show"))}</div></li><li><span>${ssrInterpolate(_ctx.$t("messages.sentence.identity_information"))}: </span><div class="link" data-bs-toggle="modal" data-bs-target="#show-store-identity-information">${ssrInterpolate(_ctx.$t("messages.word.show"))}</div></li><li><span>${ssrInterpolate(_ctx.$t("messages.word.address"))}: </span><div class="link" data-bs-toggle="modal" data-bs-target="#show-store-location">${ssrInterpolate(_ctx.$t("messages.word.show"))}</div></li></ul><div class="modal fade" id="show-statistical-information" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.statistical_information"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.store_page_view"))}</td><td>${ssrInterpolate(_ctx.store.get_formatted_view_count)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.created_products"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.user.products_count))}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.priced_products"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.products_count))}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.created_articles"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.user.articles_count))}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.sent_consignments"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.consignments_count["sent"]))}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.cancelled_consignments"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.consignments_count["cancelled"]))}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_consignments"))}</td><td>${ssrInterpolate(unref(useNumberFormat)(_ctx.store.consignments_count["awaiting"]))}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><div class="modal fade" id="show-store-identity-information" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.identity_information"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row">`);
      if (_ctx.store.type == "legal") {
        _push(`<!--[--><div class="col-12 mb-4"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</td><td>${ssrInterpolate(_ctx.store.user.get_name)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.phone"))}</td><td>${ssrInterpolate(_ctx.store.user.phone)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.company_name"))}</td>`);
        if (_ctx.store.get_information.company_name != null) {
          _push(`<td>${ssrInterpolate(_ctx.store.get_information.company_name)}</td>`);
        } else {
          _push(`<td>-</td>`);
        }
        _push(`</tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.company_type"))}</td>`);
        if (_ctx.store.get_information.company_type != null && _ctx.store.get_information.company_type != "messages.word.") {
          _push(`<td>${ssrInterpolate(_ctx.store.get_information.company_type)}</td>`);
        } else {
          _push(`<td>-</td>`);
        }
        _push(`</tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.company_national_number"))}</td>`);
        if (_ctx.store.get_information.company_national_number != null) {
          _push(`<td>${ssrInterpolate(_ctx.store.get_information.company_national_number)}</td>`);
        } else {
          _push(`<td>-</td>`);
        }
        _push(`</tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.economic_code"))}</td><td>${ssrInterpolate(_ctx.store.get_information.company_economic_number != null ? _ctx.store.get_information.company_economic_number : "پر نشده (اختیاری)")}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.signature_owners"))}</td>`);
        if (_ctx.store.get_information.company_signatory != null) {
          _push(`<td>${ssrInterpolate(_ctx.store.get_information.company_signatory)}</td>`);
        } else {
          _push(`<td>-</td>`);
        }
        _push(`</tr></tbody></table></div></div>`);
        if (_ctx.store.get_information.legal_identity_image_url != void 0) {
          _push(`<div class="col-12"><img style="${ssrRenderStyle({ "width": "100%" })}"${ssrRenderAttr("src", _ctx.store.get_information.legal_identity_image_url)}${ssrRenderAttr("alt", _ctx.store.user.get_name)}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.store.type == "genuine") {
        _push(`<!--[--><div class="col-12 mb-4"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</td><td>${ssrInterpolate(_ctx.store.user.get_name)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.phone"))}</td><td>${ssrInterpolate(_ctx.store.user.phone)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</td><td>${ssrInterpolate(_ctx.store.get_information.national_number)}</td></tr></tbody></table></div></div>`);
        if (_ctx.store.get_information.national_card_image_url != void 0) {
          _push(`<div class="col-12"><img style="${ssrRenderStyle({ "width": "100%" })}"${ssrRenderAttr("src", _ctx.store.get_information.national_card_image_url)}${ssrRenderAttr("alt", _ctx.store.user.get_name)}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><div class="modal fade" id="show-store-location" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.address"))}:</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row">`);
      if (_ctx.store.get_information.address != void 0) {
        _push(`<div class="col-12 mb-4"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.town"))}</td><td>${ssrInterpolate(_ctx.store.get_information.address.state)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.city"))}</td><td>${ssrInterpolate(_ctx.store.get_information.address.city)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</td><td>${ssrInterpolate(_ctx.store.get_information.address.full_address)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</td><td>${ssrInterpolate(_ctx.store.get_information.address.postal_code)}</td></tr></tbody></table></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(mapResult) != null) {
        _push(`<div class="col-12 mb-3"><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(mapResult),
          zoom: ((_a = unref(mapResult)) == null ? void 0 : _a.zoom) != null ? Number((_b = unref(mapResult)) == null ? void 0 : _b.zoom) : 0,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          class: "map"
        }, null, _parent));
        _push(`<div class="readonly-map"></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div></div><div class="col-12 mb-2"><div class="d-flex align-items-center justify-content-between bg-light p-3 br-15"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.seller_direct_post"))}</span>`);
      if (_ctx.store.direct_post) {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.stores.direct_post_status", _ctx.store.uuid),
          method: "post",
          as: "button",
          class: "btn btn-switch btn-on fs-9 me-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.active"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.active")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.stores.direct_post_status", _ctx.store.uuid),
          method: "post",
          as: "button",
          class: "btn btn-switch btn-off fs-9 me-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.deactive"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.deactive")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      }
      _push(`</div></div>`);
      if (_ctx.store.status == "awaiting") {
        _push(`<!--[--><div class="col-6 mt-2">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.stores.change", _ctx.store.uuid),
          data: { status: "accept" },
          class: "w-100-percent btn btn-success lts-05",
          method: "post",
          as: "button",
          "preserve-scroll": ""
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.accept"))}</span>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(_ctx.$t("messages.word.accept")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="col-6 mt-2"><button class="w-100-percent btn btn-danger lts-05" data-bs-toggle="modal" data-bs-target="#reject-store"><span>${ssrInterpolate(_ctx.$t("messages.word.reject"))}</span></button></div><div class="modal fade" id="reject-store" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content p-4"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.reject_store"))}: <span class="badge bg-info fs-9 ms-1">${ssrInterpolate(_ctx.store.name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_496632"))}</p></div><div class="col-12"><div class="form-element-row"><label for="eaRejectMessage" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.reject_reason"))}</label><textarea id="eaRejectMessage" rows="4" class="form-control">${ssrInterpolate(unref(rejectStoreFrom).reason)}</textarea></div></div></div></div><div class="modal-footer"><button type="submit"${ssrIncludeBooleanAttr(unref(rejectStoreFrom).processing) ? " disabled" : ""} class="btn btn-danger shadow-1 px-4 me-0" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.reject"))}</button></div></form></div></div></div><!--]-->`);
      } else {
        _push(`<!--[--><div class="col-6 mt-2"><button data-bs-toggle="modal" data-bs-target="#create-ticket" class="w-100-percent btn btn-light lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket"))}</button></div>`);
        if (_ctx.store.status != "reject") {
          _push(`<div class="col-6 mt-2">`);
          if (_ctx.store.status == "banned") {
            _push(ssrRenderComponent(unref(Link), {
              class: "w-100-percent btn btn-light lts-05",
              method: "delete",
              as: "button",
              "preserve-scroll": "",
              href: _ctx.route("admin.stores.destroy", _ctx.store.uuid)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.unban"))}</span>`);
                } else {
                  return [
                    createVNode("span", null, toDisplayString(_ctx.$t("messages.word.unban")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent));
          } else {
            _push(`<!---->`);
          }
          if (_ctx.store.status == "active") {
            _push(`<button class="w-100-percent btn btn-light lts-05" type="button" preserve-scroll data-bs-toggle="modal" data-bs-target="#ban-store"><span>${ssrInterpolate(_ctx.$t("messages.word.ban"))}</span></button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="modal fade" id="ban-store" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content p-4"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.ban_store"))}: <span class="badge bg-info fs-9 ms-1">${ssrInterpolate(_ctx.store.name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_369985"))}</p></div><div class="col-12"><div class="form-element-row"><label for="eaRejectMessage" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.reason"))}</label><textarea id="eaRejectMessage" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.store_ban_reason") + " ...")}>${ssrInterpolate(unref(banStoreFrom).reason)}</textarea></div></div></div></div><div class="modal-footer"><button type="submit"${ssrIncludeBooleanAttr(unref(banStoreFrom).processing) ? " disabled" : ""} class="btn btn-danger shadow-1 px-4 me-0" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.reject"))}</button></div></form></div></div></div><!--]-->`);
      }
      if (_ctx.store.status == "reject" || _ctx.store.status == "banned") {
        _push(`<div class="col-12 mb-3 mt-3"><div class="divider"></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.store.status == "reject" || _ctx.store.status == "banned") {
        _push(`<div class="col-12"><div>${ssrInterpolate(_ctx.$t("messages.word.reason"))}:</div><span class="text-danger fs-8 lts-05">${unref(useNl2br)(_ctx.store.reason) ?? ""}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="modal fade" id="create-ticket" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content p-4"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket_for"))}: <span class="badge bg-info fs-9 ms-1">${ssrInterpolate(_ctx.store.name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_875523"))}</p></div><div class="col-md-6"><div class="form-element-row mb-4"><label for="eaTicketTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createTicketForm).title)} id="eaTicketTitle" type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.ticket"))}></div></div><div class="col-md-6"><div class="form-element-row mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.priority"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(createTicketForm).priority,
        "onUpdate:modelValue": ($event) => unref(createTicketForm).priority = $event,
        options: _ctx.priorityList,
        optionLabel: "label",
        optionValue: "id",
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div></div><div class="col-12"><div class="form-element-row"><label for="eaTicketMessage" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.message"))}</label><textarea id="eaTicketMessage" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.message"))}>${ssrInterpolate(unref(createTicketForm).content)}</textarea></div></div></div></div><div class="modal-footer"><button type="submit"${ssrIncludeBooleanAttr(unref(createTicketForm).processing) ? " disabled" : ""} class="btn btn-primary shadow-1 px-4 me-0" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.send"))} <i class="ri-send-plane-2-line ms-2"></i></button></div></form></div></div></div></div></div></div></div></div><div class="col-lg-8 col-md-7 col-12"><div class="simplebar-container"><ul class="nav nav-tabs nav-pager" style="${ssrRenderStyle({ "min-width": "767px" })}" id="settingsTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" id="orders-tab" data-bs-toggle="tab" data-bs-target="#orders-tab-pane" type="button" role="tab" aria-controls="orders-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.word.consignments"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="transactions-tab" data-bs-toggle="tab" data-bs-target="#transactions-tab-pane" type="button" role="tab" aria-controls="transactions-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.transactions"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="tickets-tab" data-bs-toggle="tab" data-bs-target="#tickets-tab-pane" type="button" role="tab" aria-controls="tickets-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.tickets"))}</button></li></ul></div><div class="tab-content card" id="settingsTabContent"><div class="tab-pane fade show active" id="orders-tab-pane" role="tabpanel" aria-labelledby="orders-tab" tabindex="0"><div class="orders-list list"><div class="card-body"><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "600px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.consignments.data, (consignment) => {
        _push(`<tr><td>${ssrInterpolate(consignment.uuid)}</td><td>`);
        if (consignment.status == "awaiting_seller") {
          _push(`<span class="badge bg-info text-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller"))}</span>`);
        } else if (consignment.status == "cancelled") {
          _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else if (consignment.status == "sent_to_main_storage") {
          _push(`<span class="badge bg-purple text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_main_storage"))}</span>`);
        } else if (consignment.status == "delivered_to_main_storage") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_main_storage"))}</span>`);
        } else if (consignment.status == "sent_to_customer") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_customer"))}</span>`);
        } else if (consignment.status == "direct_sent_to_customer") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.direct_sent_to_customer"))}</span>`);
        } else if (consignment.status == "delivered") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_customer"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(consignment.jalali_created_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "150px" })}">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.orders.show", consignment.order.id),
          as: "button",
          class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.check"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.check")) + " ", 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.consignments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.consignments.links
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="transactions-tab-pane" role="tabpanel" aria-labelledby="transactions-tab" tabindex="0"><div class="card-body"><div class="title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.transaction_list"))}</div><div class="transaction-list list"><div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "750px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.price"))} <span class="currency">(${ssrInterpolate(_ctx.$t("messages.word.toman"))})</span></th><th>${ssrInterpolate(_ctx.$t("messages.word.description"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.transactions.data, (transaction) => {
        _push(`<tr><td class="white-space-nowrap">`);
        if (transaction.amount > 0) {
          _push(`<span class="text-success fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.deposit"))}</span>`);
        } else if (transaction.amount < 0 && transaction.type == "bank_withdrawal") {
          _push(`<span class="text-info fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.bank_withdrawal"))}</span>`);
        } else if (transaction.amount < 0) {
          _push(`<span class="text-danger fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.withdrawal"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (transaction.type == "seller_withdrawal" || transaction.type == "affiliate_withdrawal") {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-info": true })}">${ssrInterpolate(transaction.get_formatted_amount.replace("-", ""))}</span>`);
        } else {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-danger": transaction.amount < 0, "text-success": transaction.amount > 0 })}">${ssrInterpolate(transaction.get_formatted_amount)}</span>`);
        }
        _push(`</td><td class="fs-9 lts-05">${transaction.description ?? ""}</td><td class="fs-8">${ssrInterpolate(transaction.transaction_id)}</td><td>`);
        if (transaction.status == "accepted") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.successful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type != "seller_withdrawal" && transaction.type != "affiliate_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.unsuccessful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type == "bank_withdrawal") {
          _push(`<span class="badge bg-warning rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else if (transaction.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_admin"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "waiting_payment") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(transaction.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.transactions.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.transactions.links
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="tickets-tab-pane" role="tabpanel" aria-labelledby="tickets-tab" tabindex="0"><div class="card-body"><div class="title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.ticket_list"))}</div><div class="list"><div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "600px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.priority"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.tickets.data, (ticket) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.tickets.show", ticket.id),
          class: { link: true, "fw-normal": ticket.status == "waiting_user" || ticket.status == "closed" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="lts-05 fs-8">`);
        if (ticket.priority == "high") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.high"))}</span>`);
        } else if (ticket.priority == "normal") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (ticket.priority == "low") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.low"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (ticket.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
        } else if (ticket.status == "waiting_user") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
        } else if (ticket.status == "closed") {
          _push(`<span class="badge bg-dark rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(ticket.jalali_updated_at[3])}</td><td>`);
        if (ticket.status != "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-dark btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.close"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (ticket.status == "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-success btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.open"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-unlock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-unlock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.tickets.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.tickets.links
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stores/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
