import { defineComponent, inject, watch, ref, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, createBlock, openBlock, createVNode, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrIncludeBooleanAttr, ssrRenderClass, ssrLooseEqual, ssrRenderList, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import SimpleBar from "simplebar";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$3 } from "./FormatedNumInput-D4wHj270.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import "laravel-vue-i18n";
import { _ as _sfc_main$4 } from "./NumInput-Bt6uFGO4.js";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    user: {},
    cart: {},
    orders: {},
    transactions: {},
    tickets: {},
    addresses: {},
    productComments: {},
    keyword: {},
    genderList: {},
    priorityList: {}
  },
  setup(__props) {
    const props = __props;
    if (typeof window !== "undefined") {
      $(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
      });
    }
    const profileForm = useForm({
      avatar: props.user.avatar,
      name: props.user.name,
      username: props.user.username,
      email: props.user.email,
      national_number: props.user.national_number,
      birthday: props.user.jalali_birthday != null ? props.user.jalali_birthday[1] : null,
      gender: props.user.gender,
      bio: props.user.bio,
      social: {
        instagram: props.user.get_social.instagram,
        telegram: props.user.get_social.telegram,
        twitter: props.user.get_social.twitter,
        facebook: props.user.get_social.facebook
      }
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "avatar" && media.file != null) {
        $("#edit-user-profile-button").trigger("click");
        props.user.get_avatar = media.file.url;
        profileForm.avatar = media.file.id + "";
      }
    });
    const createTicketForm = useForm({
      title: null,
      priority: "normal",
      content: null,
      user_id: props.user.id
    });
    const editWalletForm = useForm({
      amount: props.user.wallet.get_formatted_amount
    });
    const editScoreForm = useForm({
      score: null,
      type: null
    });
    const productUUID = ref(null);
    const productWidget = ref(null);
    const searchProductStatus = ref(false);
    const selectedInventory = ref();
    const count = ref();
    const changeCount = (inventory) => {
      if (inventory != null) {
        if (inventory.max_sale == null) {
          if (count.value > inventory.count) {
            count.value = Number(inventory.count);
          }
        } else if (count.value > inventory.max_sale) {
          count.value = Number(inventory.max_sale);
          if (count.value > inventory.count) {
            count.value = Number(inventory.count);
          }
        }
        if (count.value < inventory.min_sale) {
          count.value = Number(inventory.min_sale);
        }
      }
    };
    watch(selectedInventory, (value) => {
      if (value != null) {
        count.value = Number(value.min_sale);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.user_details")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.user_details")
      }, null, _parent));
      _push(`<div class="row mb-4"><div class="col-lg-4 col-md-5 col-12"><div class="user-profile mb-4"><div class="card"><div class="card-body"><div class="top-pattern"></div><div class="user-avatar d-flex align-items-end justify-content-start"><img class="ms-4" width="110" height="110"${ssrRenderAttr("src", _ctx.user.get_avatar)}${ssrRenderAttr("alt", _ctx.user.get_name)}>`);
      if (_ctx.user.status == "banned") {
        _push(`<div class="details shadow-smooth-2 ms-2"><span class="lts-05 text-danger me-1">${ssrInterpolate(_ctx.$t("messages.word.banned"))}</span></div>`);
      } else {
        _push(`<div class="details shadow-smooth-2 ms-2">`);
        if (_ctx.user.get_level == "gold") {
          _push(`<span class="d-inline-flex align-items-center lts-05"><span class="text-gray lh-15">${ssrInterpolate(_ctx.$t("messages.word.gold"))}</span><span class="d-inline-block gold-circle ms-1"></span></span>`);
        } else if (_ctx.user.get_level == "silver") {
          _push(`<span class="d-inline-flex align-items-center lts-05"><span class="text-gray lh-15">${ssrInterpolate(_ctx.$t("messages.word.silver"))}</span><span class="d-inline-block silver-circle ms-1"></span></span>`);
        } else {
          _push(`<span class="d-inline-flex align-items-center lts-05"><span class="text-gray lh-15">${ssrInterpolate(_ctx.$t("messages.word.bronze"))}</span><span class="d-inline-block bronze-circle ms-1"></span></span>`);
        }
        _push(`</div>`);
      }
      _push(`</div><div class="row p-3"><div class="col-12 d-flex align-items-center justify-content-between mb-3"><div><div class="user-name mb-1">${ssrInterpolate(_ctx.user.get_name)}</div><div class="user-phone">${ssrInterpolate(_ctx.user.phone)}</div></div>`);
      if (_ctx.$page.props.auth.user.type == "owner") {
        _push(`<span id="edit-user-profile-button" class="edit-profile-link link" data-bs-toggle="modal" data-bs-target="#edit-user-profile"><i class="ri-pencil-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</span>`);
      } else {
        _push(`<span id="edit-user-profile-button" class="edit-profile-link link"><i class="ri-pencil-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</span>`);
      }
      _push(`<div class="modal fade" id="edit-user-profile" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_user_profile"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row edit-account-form"><div class="col-12 avatar-container d-flex align-items-center mb-5"><img width="100" height="100"${ssrRenderAttr("src", _ctx.user.get_avatar)} class="shadow-1"${ssrRenderAttr("alt", _ctx.user.get_name)}><div class="edit-link"><button type="button" class="btn btn-light shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="avatar"><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.change_profile"))}</button><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.profile_hint"))})</div></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaFullname" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.fullname"))}</label><input${ssrRenderAttr("value", unref(profileForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.fullname"))} required class="form-control" id="eaFullname"></div><div class="col-sm-6 col-12 mb-4"><label for="eaUsername" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.username"))}</label><input${ssrRenderAttr("value", unref(profileForm).username)} minlength="4" maxlength="20" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.username"))} required class="form-control" id="eaUsername"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.username_hint"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaPhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label><input${ssrRenderAttr("value", _ctx.user.phone)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.phone"))} class="form-control" id="eaPhone" minlength="11" maxlength="11" autocomplete="phone" disabled></div><div class="col-sm-6 col-12 mb-4"><label for="eaEmail" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.email"))}</label><input${ssrRenderAttr("value", unref(profileForm).email)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.email"))} class="form-control" id="eaEmail"${ssrIncludeBooleanAttr(_ctx.user.email != null && _ctx.user.email_verified_at != null) ? " disabled" : ""}></div><div class="col-sm-4 col-12 mb-4"><label for="eaNationalCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</label><input${ssrRenderAttr("value", unref(profileForm).national_number)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.national_number"))} class="form-control" maxlength="10" id="eaNationalCode"></div><div class="col-sm-4 col-12 mb-4"><label for="birthdayPicker" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.birthday_date"))}</label><input${ssrRenderAttr("value", unref(profileForm).birthday)} id="birthdayPicker"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.choose") + " " + _ctx.$t("messages.sentence.birthday_date"))} type="text" readonly class="form-control" data-jdp></div><div class="col-sm-4 col-12 mb-4"><label for="eaGender" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.gender"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(profileForm).gender,
        "onUpdate:modelValue": ($event) => unref(profileForm).gender = $event,
        options: _ctx.genderList,
        optionLabel: "label",
        optionValue: "id",
        id: "eaGender",
        placeholder: _ctx.$t("messages.sentence.choose_gender"),
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaBiography" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.biography"))}</label><textarea class="form-control" name="biography"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.biography_summary"))} id="eaBiography">${ssrInterpolate(unref(profileForm).bio)}</textarea></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-4"><span class="fw-bold d-flex fs-6 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.personal_socials"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaInstagram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.instagram"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.instagram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.instagram"))} class="form-control" id="eaInstagram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTelegram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.telegram"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.telegram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.telegram"))} class="form-control" id="eaTelegram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTwitter" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.twitter"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.twitter)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.twitter"))} class="form-control" id="eaTwitter"></div><div class="col-sm-6 col-12 mb-4"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.facebook"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.facebook)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.facebook"))} class="form-control" id="eaFacebook"></div></div></div><div class="modal-footer pt-1"><button type="button" class="btn btn-light lts-05 shadow-1 me-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(profileForm).processing) ? " disabled" : ""} data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))} `);
      if (unref(profileForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></form></div></div></div></div><div class="col-12 user-bio"><span>${ssrInterpolate(_ctx.$t("messages.word.biography"))}:</span><p class="lts-05">${ssrInterpolate(_ctx.user.bio != null && _ctx.user.bio != "" ? _ctx.user.bio : _ctx.$t("messages.word.empty"))}</p></div>`);
      if (_ctx.user.seller) {
        _push(`<div class="col-12 mb-3"><div class="divider"></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.user.seller) {
        _push(`<div class="meta-text col-12 d-flex align-items-center justify-content-between mb-3"><div class="key d-flex align-items-center lts-05"><i class="ri-store-2-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div><div class="value fw-bold">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.stores.show", _ctx.user.store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.user.store.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.user.store.name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 mb-3"><div class="divider"></div></div><div class="col-12 d-flex align-items-center justify-content-between mb-3"><div class="meta-icon d-flex align-items-center"><i class="ri-wallet-3-line"></i><div class="ms-2"><span>${ssrInterpolate(_ctx.$t("messages.sentence.wallet_amount"))}</span><div>${ssrInterpolate(_ctx.user.wallet.get_formatted_amount)} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></div>`);
      if (_ctx.$page.props.auth.user.type == "owner") {
        _push(`<span class="link edit-wallet-link lts-05" data-bs-toggle="modal" data-bs-target="#edit-wallet-amount">${ssrInterpolate(_ctx.$t("messages.sentence.edit_inventory"))}</span>`);
      } else {
        _push(`<span class="link edit-wallet-link lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.edit_inventory"))}</span>`);
      }
      _push(`<div class="modal fade" id="edit-wallet-amount" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_user_wallet_amount"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><label for="eaWalletAmount" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.inventory"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editWalletForm).amount,
        "onUpdate:modelValue": ($event) => unref(editWalletForm).amount = $event,
        type: "text",
        required: "",
        class: "form-control",
        id: "eaWalletAmount"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-0"><p class="form-control-description"><strong class="fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_998112"))}</p></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(editWalletForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div></div><div class="col-12 mb-3"><div class="divider"></div></div><div class="meta-text col-12 mb-3"><div class="d-flex align-items-center justify-content-between mb-2"><div class="key d-flex align-items-center lts-05"><i class="ri-copper-coin-fill text-warning me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</div><div class="value fw-bold">${ssrInterpolate(_ctx.user.get_score.formatted_score)} <span>${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div><div class="d-flex align-items-center justify-content-end">`);
      if (_ctx.$page.props.auth.user.type == "owner") {
        _push(`<span class="edit-profile-link link lts-05" data-bs-toggle="modal" data-bs-target="#edit-user-score">${ssrInterpolate(_ctx.$t("messages.sentence.edit_score"))}</span>`);
      } else {
        _push(`<span class="edit-profile-link link lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.edit_score"))}</span>`);
      }
      _push(`<div class="modal fade" id="edit-user-score" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_user_score"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><label for="eaUserScore" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.score"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editScoreForm).score,
        "onUpdate:modelValue": ($event) => unref(editScoreForm).score = $event,
        type: "text",
        required: "",
        class: "form-control",
        id: "eaUserScore"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-3"><div class="d-flex"><label class="${ssrRenderClass({ "btn btn-light me-1 w-100": true, "btn-success": unref(editScoreForm).type == "increase" ? true : false })}">${ssrInterpolate(_ctx.$t("messages.word.increase"))} <input${ssrIncludeBooleanAttr(ssrLooseEqual(unref(editScoreForm).type, "increase")) ? " checked" : ""} class="d-none" type="radio" value="increase"></label><label class="${ssrRenderClass({ "btn btn-light me-1 w-100": true, "btn-danger": unref(editScoreForm).type == "decrease" ? true : false })}">${ssrInterpolate(_ctx.$t("messages.word.decrease"))} <input${ssrIncludeBooleanAttr(ssrLooseEqual(unref(editScoreForm).type, "decrease")) ? " checked" : ""} class="d-none" type="radio" value="decrease"></label></div></div><div class="col-12 mb-0"><p class="form-control-description"><strong class="fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_541123"))}</p></div></div></div><div class="modal-footer"><button${ssrIncludeBooleanAttr(unref(editScoreForm).processing) ? " disabled" : ""} class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div></div></div><div class="col-12 mb-3"><div class="divider"></div></div><div class="col-12"><ul class="user-information"><li><span>${ssrInterpolate(_ctx.$t("messages.word.role"))}: </span>`);
      if (_ctx.user.type == "owner") {
        _push(`<div>${ssrInterpolate(_ctx.$t("messages.word.owner"))}</div>`);
      } else if (_ctx.user.type == "admin") {
        _push(`<div>${ssrInterpolate(_ctx.user.role.label)}</div>`);
      } else if (_ctx.user.seller) {
        _push(`<div>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
      } else if (_ctx.user.type == "user") {
        _push(`<div>${ssrInterpolate(_ctx.$t("messages.word.user"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</li><li><span>${ssrInterpolate(_ctx.$t("messages.word.national_number"))}: </span> ${ssrInterpolate(_ctx.user.national_number != null ? _ctx.user.national_number : _ctx.$t("messages.word.empty"))}</li><li><span>${ssrInterpolate(_ctx.$t("messages.word.gender"))}: </span> ${ssrInterpolate(_ctx.user.gender != null ? _ctx.user.gender : _ctx.$t("messages.word.not_defined"))}</li><li><span>${ssrInterpolate(_ctx.$t("messages.word.email"))}: </span> ${ssrInterpolate(_ctx.user.email != null ? _ctx.user.email : _ctx.$t("messages.word.empty"))}</li><li><span>${ssrInterpolate(_ctx.$t("messages.sentence.birthday_date"))}: </span> ${ssrInterpolate(_ctx.user.jalali_birthday != null && Array.isArray(_ctx.user.jalali_birthday) ? _ctx.user.jalali_birthday[1] : _ctx.$t("messages.word.not_defined"))}</li></ul></div><div class="col-6 mt-3"><button data-bs-toggle="modal" data-bs-target="#create-ticket" class="w-100-percent btn btn-light lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket"))}</button></div><div class="col-6 mt-3">`);
      _push(ssrRenderComponent(unref(Link), {
        class: "w-100-percent btn btn-light lts-05",
        method: "delete",
        as: "button",
        "preserve-scroll": "",
        href: _ctx.route("admin.users.destroy", _ctx.user.id)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (_ctx.user.status == "active") {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.ban"))}</span>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.unban"))}</span>`);
            }
          } else {
            return [
              _ctx.user.status == "active" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("messages.word.ban")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.unban")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="modal fade" id="create-ticket" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content p-4"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket_for"))}: <span class="badge bg-info fs-9 ms-1">${ssrInterpolate(_ctx.user.get_name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_875523"))}</p></div><div class="col-md-6"><div class="form-element-row mb-4"><label for="eaTicketTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createTicketForm).title)} id="eaTicketTitle" type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.ticket_title"))}></div></div><div class="col-md-6"><div class="form-element-row mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.priority"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(createTicketForm).priority,
        "onUpdate:modelValue": ($event) => unref(createTicketForm).priority = $event,
        options: _ctx.priorityList,
        optionLabel: "label",
        optionValue: "id",
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div></div><div class="col-12"><div class="form-element-row"><label for="eaTicketMessage" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.message"))}</label><textarea id="eaTicketMessage" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_message"))}>${ssrInterpolate(unref(createTicketForm).content)}</textarea></div></div></div></div><div class="modal-footer"><button type="submit"${ssrIncludeBooleanAttr(unref(createTicketForm).processing) ? " disabled" : ""} class="btn btn-primary shadow-1 px-4 me-0" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.send"))} <i class="ri-send-plane-2-line ms-2"></i></button></div></form></div></div></div></div></div></div></div></div><div class="col-lg-8 col-md-7 col-12"><div class="simplebar-container"><ul class="nav nav-tabs nav-pager" style="${ssrRenderStyle({ "min-width": "767px" })}" id="settingsTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" id="cart-tab" data-bs-toggle="tab" data-bs-target="#cart-tab-pane" type="button" role="tab" aria-controls="cart-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.word.cart"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="orders-tab" data-bs-toggle="tab" data-bs-target="#orders-tab-pane" type="button" role="tab" aria-controls="orders-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.orders"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="transactions-tab" data-bs-toggle="tab" data-bs-target="#transactions-tab-pane" type="button" role="tab" aria-controls="transactions-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.transactions"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="tickets-tab" data-bs-toggle="tab" data-bs-target="#tickets-tab-pane" type="button" role="tab" aria-controls="tickets-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.tickets"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="addresses-tab" data-bs-toggle="tab" data-bs-target="#addresses-tab-pane" type="button" role="tab" aria-controls="addresses-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.addresses"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="comments-tab" data-bs-toggle="tab" data-bs-target="#comments-tab-pane" type="button" role="tab" aria-controls="comments-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.comments"))}</button></li></ul></div><div class="tab-content card" id="settingsTabContent"><div class="tab-pane fade show active" id="cart-tab-pane" role="tabpanel" aria-labelledby="cart-tab" tabindex="0"><div class="cart-list list"><div class="card-body"><div class="d-flex align-items-center justify-content-end mb-3"><button class="btn btn-primary fs-8 fw-bold px-3" data-bs-toggle="modal" data-bs-target="#addToCart">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart"))}</button><div class="modal fade users-add-to-cart-modal" id="addToCart" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_cart_of_user"))}: <span class="ms-1">${ssrInterpolate(_ctx.user.get_name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaWidgetProduct" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.add_product"))} <span class="fs-9 text-gray fw-light">(${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))})</span></label><div class="search-product-input d-flex align-items-center mb-2">`);
      if (productWidget.value != null) {
        _push(`<button class="btn btn-danger btn-square btn-xs btn-delete"><i class="ri-close-line"></i></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("value", productUUID.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": p-1234567")} class="form-control" id="eaWidgetProduct" style="${ssrRenderStyle({ "direction": "ltr" })}"><button class="btn btn-dark ms-1 btn-square" type="button"${ssrIncludeBooleanAttr(searchProductStatus.value) ? " disabled" : ""}>`);
      if (searchProductStatus.value) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<i class="ri-search-2-line"></i>`);
      }
      _push(`</button></div></div>`);
      if (productWidget.value != null) {
        _push(`<!--[--><div class="col-12 mb-3"><div class="fw-light fs-8 text-gray mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.product_title"))}:</div><a${ssrRenderAttr("href", _ctx.route("main.products.show", productWidget.value.slug))} target="_blank" class="link title">${ssrInterpolate(productWidget.value.title)}</a></div>`);
        if (productWidget.value.inventory_status["inquery"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-danger text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_status_is_inquery_mode"))}</span></div>`);
        } else if (!productWidget.value.inventory_status["inventory"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-danger text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_inventory_is_empty"))}</span></div>`);
        } else if (!productWidget.value.inventory_status["instock"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-danger text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_outofstock"))}</span></div>`);
        } else {
          _push(`<div class="product-inventory-list col-12"><div class="text-dark lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_one_item"))}:</div><ul><!--[-->`);
          ssrRenderList(productWidget.value.inventories, (inventory) => {
            _push(`<li class="d-flex align-items-center"><div class="radio-select"><label class="${ssrRenderClass({ clickable: true, active: selectedInventory.value != null && selectedInventory.value.id == inventory.id })}">`);
            if (selectedInventory.value != null && selectedInventory.value.id == inventory.id) {
              _push(`<i class="ri-check-line"></i>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</label></div><div class="inventory-data d-flex align-items-end justify-content-between flex-grow-1"><div>`);
            if (inventory.store_id != null) {
              _push(`<a${ssrRenderAttr("href", _ctx.route("main.stores.show", inventory.store.uuid))} target="_blank" class="link lts-05 mb-2">${ssrInterpolate(inventory.store.name)}</a>`);
            } else {
              _push(`<a href="javascript:void(0)" class="link lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</a>`);
            }
            _push(`<ul><!--[-->`);
            ssrRenderList(inventory.props, (prop, ci) => {
              _push(`<li class="d-inline-flex align-items-center"><span class="title lts-05 text-gray me-1">${ssrInterpolate(prop.name)}: </span>`);
              if (prop.type == "color") {
                _push(`<div><span class="color" style="${ssrRenderStyle("background-color:" + prop.value.color)}"></span><span class="text-dark fs-8 lts-05 ms-1">${ssrInterpolate(prop.value.label)}</span></div>`);
              } else {
                _push(`<div class="text-dark fs-8 lts-05">${ssrInterpolate(prop.value)}</div>`);
              }
              _push(`</li>`);
            });
            _push(`<!--]--></ul>`);
            if (selectedInventory.value != null && selectedInventory.value.id == inventory.id) {
              _push(`<div class="price-count-container mt-2"><div class="count-container"><span class="increase"><i class="ri-add-line"></i></span>`);
              _push(ssrRenderComponent(_sfc_main$4, {
                modelValue: count.value,
                "onUpdate:modelValue": ($event) => count.value = $event,
                onChange: ($event) => changeCount(inventory),
                type: "text",
                name: "count",
                minlength: "1",
                maxlength: "4",
                autocomplete: "off"
              }, null, _parent));
              _push(`<span class="decrease"><i class="ri-subtract-line"></i></span></div></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div><div><div class="cart-item--price fa-num">`);
            if (inventory.discount_price > 0) {
              _push(`<div class="cart-item--discount lts-05"><del>${ssrInterpolate(unref(useNumberFormat)(inventory.discount_price))}</del></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--price-now text-dark lts-05"><span>${ssrInterpolate(unref(useNumberFormat)(inventory.get_final_price))}</span><span class="unit unit-sm"></span></div></div></div></div></li>`);
          });
          _push(`<!--]--></ul></div>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (selectedInventory.value != null && selectedInventory.value != null) {
        _push(`<div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.add"))}</button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
      if (_ctx.cart.items.length > 0) {
        _push(`<div class="cart-amount d-block w-100 mb-4"><div class="row checkout"><div class="checkout-row col-md-auto col-6 mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_prices"))} (${ssrInterpolate(_ctx.cart.items.length)})</div><div class="checkout-row-value lts-05"><span class="fw-bold fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.cart.totalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row col-md-auto col-6 mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_discounts"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 fw-bold text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.cart.totalDiscount))}</span><span class="unit-red unit-sm lts-05 text-danger"></span></div></div><div class="checkout-row col-md-auto col-6 mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cart_total"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.cart.totalFinalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row checkout-footer col-md-auto col-6 mb-3"><div class="checkout-row-label lts-05"><span class="d-flex"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.cart.customerClubScore))}</span> <span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.cart.items.length > 0) {
        _push(`<div class="d-block w-100 cart-items simplebar-container"><div class="d-block">`);
        if (_ctx.cart.items.length > 0) {
          _push(`<!--[-->`);
          ssrRenderList(_ctx.cart.items, (item) => {
            _push(`<div class="cart-item"><div class="cart-item--thumbnail"><a${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))} target="_blank"><img${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.title)} loading="lazy"></a></div><div class="cart-item--detail"><h2 class="cart-item--title mb-2"><a${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))} target="_blank">${ssrInterpolate(item.product.title)}</a></h2>`);
            if (item.get_props.length > 0) {
              _push(`<div class="cart-item--data"><ul><!--[-->`);
              ssrRenderList(item.get_props, (prop, i) => {
                _push(`<li>`);
                if (prop.type == "color") {
                  _push(`<div class="cart-item--variant mb-2"><span class="color shadow-2" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span><span class="color-name lts">${ssrInterpolate(prop.value["label"])}</span></div>`);
                } else {
                  _push(`<!--[-->`);
                  if (prop.type == "warranty") {
                    _push(`<i class="ri-shield-check-fill"></i>`);
                  } else {
                    _push(`<i class="ri-focus-line"></i>`);
                  }
                  _push(`<span>${ssrInterpolate(prop.name + ": " + prop.value)}</span><!--]-->`);
                }
                _push(`</li>`);
              });
              _push(`<!--]--></ul></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--data mb-4"><ul><li><i class="ri-store-2-line"></i>`);
            if (item.store != null) {
              _push(`<a target="_blank" class="shop-name link lts-05"${ssrRenderAttr("href", _ctx.route("main.stores.show", item.store.uuid))}>${ssrInterpolate(item.store.name)}</a>`);
            } else {
              _push(`<a class="shop-name link lts-05" href="javascript:void(0)">${ssrInterpolate(_ctx.$page.props.appName)}</a>`);
            }
            _push(`</li><li><i class="ri-checkbox-multiple-fill"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.available_in_stock"))}</span><span class="text-secondary mx-2">|</span><i class="ri-truck-fill"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span></li></ul></div><div class="cart-item--price--actions"><div class="cart-item--actions"><div class="num-block fa-num me-3"><div class="num-in"><span class="plus"></span><input${ssrRenderAttr("value", item.count)} type="text" class="in-num" name="count" autocomplete="off" readonly><span class="minus dis"></span></div></div><button class="btn btn-link btn-sm text-secondary"><i class="ri-delete-bin-5-line me-1"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</span></button></div><div class="cart-item--price fa-num">`);
            if (item.discount > 0) {
              _push(`<div class="cart-item--discount"><del>${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count + item.price * item.count))}</del></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span><span class="unit"></span></div></div></div></div></div>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.cart.items.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="tab-pane fade" id="orders-tab-pane" role="tabpanel" aria-labelledby="orders-tab" tabindex="0"><div class="orders-list list"><div class="card-body"><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "600px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.orders.data, (order) => {
        _push(`<tr><td>${ssrInterpolate(order.uuid)}</td><td>`);
        if (order.status == "registered") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "sent") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "delivered") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "returned") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "cancelled") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(order.jalali_created_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "150px" })}">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.orders.show", order.id),
          as: "button",
          class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.check"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.check")) + " ", 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.orders.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.orders.links
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="transactions-tab-pane" role="tabpanel" aria-labelledby="transactions-tab" tabindex="0"><div class="card-body"><div class="title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.transaction_list"))}</div><div class="transaction-list list"><div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "700px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.price"))} <span class="currency">(${ssrInterpolate(_ctx.$t("messages.word.toman"))})</span></th><th>${ssrInterpolate(_ctx.$t("messages.word.description"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.transactions.data, (transaction) => {
        _push(`<tr><td class="white-space-nowrap">`);
        if (transaction.amount > 0) {
          _push(`<span class="text-success fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.deposit"))}</span>`);
        } else if (transaction.amount < 0 && transaction.type == "bank_withdrawal") {
          _push(`<span class="text-info fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.bank_withdrawal"))}</span>`);
        } else if (transaction.amount < 0) {
          _push(`<span class="text-danger fw-bold fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.word.withdrawal"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (transaction.type == "seller_withdrawal" || transaction.type == "affiliate_withdrawal") {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-info": true })}">${ssrInterpolate(transaction.get_formatted_amount.replace("-", ""))}</span>`);
        } else {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-danger": transaction.amount < 0, "text-success": transaction.amount > 0 })}">${ssrInterpolate(transaction.get_formatted_amount)}</span>`);
        }
        _push(`</td><td class="fs-9 lts-05">${transaction.description ?? ""}</td><td class="fs-8">${ssrInterpolate(transaction.transaction_id)}</td><td>`);
        if (transaction.status == "accepted") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.successful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type != "seller_withdrawal" && transaction.type != "affiliate_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.unsuccessful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type == "bank_withdrawal") {
          _push(`<span class="badge bg-warning rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else if (transaction.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_admin"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "waiting_payment") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(transaction.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.transactions.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.transactions.links
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="tickets-tab-pane" role="tabpanel" aria-labelledby="tickets-tab" tabindex="0"><div class="card-body"><div class="title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.ticket_list"))}</div><div class="list"><div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "600px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.priority"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.tickets.data, (ticket) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.tickets.show", ticket.id),
          class: { link: true, "fw-normal": ticket.status == "waiting_user" || ticket.status == "closed" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="lts-05 fs-8">`);
        if (ticket.priority == "high") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.high"))}</span>`);
        } else if (ticket.priority == "normal") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (ticket.priority == "low") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.low"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (ticket.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
        } else if (ticket.status == "waiting_user") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
        } else if (ticket.status == "closed") {
          _push(`<span class="badge bg-dark rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(ticket.jalali_updated_at[3])}</td><td>`);
        if (ticket.status != "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-dark btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.close"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (ticket.status == "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-success btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.open"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-unlock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-unlock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.tickets.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.tickets.links
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="addresses-tab-pane" role="tabpanel" aria-labelledby="addresses-tab" tabindex="0"><div class="card-body">`);
      if (_ctx.addresses.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.addresses.length != 0) {
        _push(`<div class="title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.word.addresses"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.addresses.length != 0) {
        _push(`<div class="address-container"><div class="row"><!--[-->`);
        ssrRenderList(_ctx.addresses, (address) => {
          _push(`<div class="${ssrRenderClass({ "col-xl-4": true, "col-lg-6": true, "col-md-6": true, "user-address-item": true, "active-address": address.active })}"><div class="custom-radio-box"><div class="custom-radio-box-label"${ssrRenderAttr("data-placeholder", address.active ? _ctx.$t("messages.sentence.user_default_address") : _ctx.$t("messages.sentence.not_selected"))}><span class="d-block user-address-recipient mb-2">${ssrInterpolate(address.state + ", " + address.city)}</span><span class="d-block user-contact-items mb-3"><span class="user-contact-item"><span class="value full-address lts-05">${ssrInterpolate(address.full_address)}</span></span><span class="user-contact-item"><i class="ri-phone-line icon"></i><span class="value">${ssrInterpolate(address.phone)}</span></span><span class="user-contact-item"><i class="ri-user-line icon"></i><span class="value">${ssrInterpolate(address.first_name + " " + address.last_name)}</span></span></span></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="tab-pane fade" id="comments-tab-pane" role="tabpanel" aria-labelledby="comments-tab" tabindex="0"><div class="card-body">`);
      if (_ctx.productComments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.productComments.data.length != 0) {
        _push(`<div class="title lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.product_comments"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="comment-list orders-list list"><div class="comments orders"><div class="comment-items user-order-items"><!--[-->`);
      ssrRenderList(_ctx.productComments.data, (comment) => {
        _push(`<div class="comment-item user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row">`);
        if (comment.status == "awaiting") {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation yellow"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></span></div>`);
        } else if (comment.reported) {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation red"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.word.reported"))}</span></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link link-icon",
          href: _ctx.route("admin.users.show", comment.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(comment.user.get_name)} <i class="ri-external-link-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(comment.user.get_name) + " ", 1),
                createVNode("i", { class: "ri-external-link-line" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.like"))}: </span> ${ssrInterpolate(comment.vote_up)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.unlike"))}: </span> ${ssrInterpolate(comment.vote_down)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.rating"))}: </span> ${ssrInterpolate(comment.rating)} ${ssrInterpolate(_ctx.$t("messages.sentence.from_5_rating"))}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(comment.jalali_created_at[0])}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.product"))}: </span><a class="link link-icon"${ssrRenderAttr("href", _ctx.route("main.products.show", comment.product.slug))} target="_blank">${ssrInterpolate(comment.product.title)} <i class="ri-external-link-line"></i></a></span></div></div></div><div class="row send-details"><div class="col-sm-auto mb-2">`);
        if (comment.buy_suggest == "1") {
          _push(`<span class="user-order-meta text-success">${ssrInterpolate(_ctx.$t("messages.sentence.suggest_product"))}</span>`);
        } else if (comment.buy_suggest == "0") {
          _push(`<span class="user-order-meta text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.not_suggest_product"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-12 user-order-item-header--meta mb-3"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.comment_content"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(comment.content)}</span></span></div>`);
        if (comment.get_strengths.length > 0) {
          _push(`<!--[--><div class="col-sm-auto mb-2"><div class="title text-success">${ssrInterpolate(_ctx.$t("messages.sentence.strengths"))}:</div></div><!--[-->`);
          ssrRenderList(comment.get_strengths, (strength, index) => {
            _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta positive"><span class="text-muted me-1">${ssrInterpolate(strength)}</span></span></div>`);
          });
          _push(`<!--]--><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_weakness.length > 0) {
          _push(`<!--[--><div class="col-sm-auto mb-2"><div class="title text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.weakness"))}:</div></div><!--[-->`);
          ssrRenderList(comment.get_weakness, (weakness, index) => {
            _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta negative"><span class="text-muted me-1">${ssrInterpolate(weakness)}</span></span></div>`);
          });
          _push(`<!--]--><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_answer != null) {
          _push(`<div class="col-12"><div class="row send-details admin-answer"><div class="col-sm-auto mb-1"><span class="user-order-meta">${ssrInterpolate(comment.get_answer.user.name)} <span class="text-muted ms-1">${ssrInterpolate(comment.get_answer.user.role.label)}</span></span></div><div class="col-sm-auto p-0 mb-2">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.product.comments.delete_answer", comment.id),
            method: "delete",
            as: "button",
            class: "btn remove-answer"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-close-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-close-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><div class="col-12 user-order-item-header--meta"><p class="fw-bold mb-0">${ssrInterpolate(comment.get_answer.content)}</p></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.productComments.data.length > 0) {
        _push(ssrRenderComponent(_sfc_main$5, {
          links: _ctx.productComments.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Users/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
