import { defineComponent, onMounted, ref, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, Head } from "@inertiajs/vue3";
import SimpleBar from "simplebar";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "resize-observer-polyfill";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Show",
  __ssrInlineRender: true,
  props: {
    ticket: {}
  },
  setup(__props) {
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
        $(".tickets-container .simplebar-content-wrapper").scrollTop($(".tickets-container .simplebar-content").height());
      });
    }
    const sendAnswerForm = useForm({
      type: "text",
      content: null
    });
    const imagePreview = ref();
    ref();
    ref();
    const imageUrl = ref();
    ref();
    const sendAttachmentForm = useForm({
      attachment: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.show_ticket", { ticket: _ctx.ticket.title })
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body pt-3"><div class="panel-content--title mb-3 lts-05"><span>${ssrInterpolate(_ctx.$t("messages.word.ticket"))}:</span> ${ssrInterpolate(_ctx.ticket.title)} `);
      if (_ctx.ticket.status == "waiting_admin") {
        _push(`<span class="badge bg-info rounded-pill fs-7 ms-2">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
      } else if (_ctx.ticket.status == "waiting_user") {
        _push(`<span class="badge bg-success rounded-pill fs-7 ms-2">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
      } else if (_ctx.ticket.status == "closed") {
        _push(`<span class="badge bg-dark rounded-pill fs-7 ms-2">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="tickets-container shadow-1"><div id="tickets" class="tickets simplebar-container"><!--[-->`);
      ssrRenderList(_ctx.ticket.ticket_answers, (answer, index) => {
        _push(`<div class="${ssrRenderClass({ ticket: true, reply: answer.user_id != _ctx.ticket.user_id })}">`);
        if (index == 0 || _ctx.ticket.ticket_answers[index - 1] != null && answer.user_id != _ctx.ticket.ticket_answers[index - 1].user_id) {
          _push(`<div class="${ssrRenderClass({ avatar: true, "mt-4": index != 0 })}"><img class="shadow-1"${ssrRenderAttr("src", answer.user.get_avatar)}${ssrRenderAttr("alt", answer.user.get_name)}><span>${ssrInterpolate(answer.user.get_name)}</span>`);
          if (answer.user.type == "owner") {
            _push(`<span class="badge bg-dark">${ssrInterpolate(_ctx.$t("messages.word.owner"))}</span>`);
          } else if (answer.user.type == "admin") {
            _push(`<span class="badge bg-dark">${ssrInterpolate(_ctx.$t("messages.word.admin"))}</span>`);
          } else if (answer.user.seller) {
            _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (answer.type == "text") {
          _push(`<div class="text shadow-1"><p class="m-0">${answer.content.replace(/(?:\r\n|\r|\n)/g, "<br />") ?? ""}</p><div class="date">${ssrInterpolate(answer.jalali_created_at[2])}</div></div>`);
        } else if (answer.type == "file") {
          _push(`<div class="image shadow-1"><img class="shadow-1"${ssrRenderAttr("src", answer.get_file["link"])}${ssrRenderAttr("alt", answer.get_file["alt"])}><div class="image-details"><span class="image-name">${ssrInterpolate(answer.get_file["name"])}</span><div><span>${ssrInterpolate(answer.get_file["size"])}</span>`);
          if (answer.get_file["alt"] != "deleted") {
            _push(`<span class="link lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.open_image"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="date">${ssrInterpolate(answer.jalali_created_at[2])}</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--></div><form class="send-answer-ticket-container">`);
      if (_ctx.ticket.status != "closed") {
        _push(`<div class="send-answer-ticket"><button${ssrIncludeBooleanAttr(unref(sendAnswerForm).processing) ? " disabled" : ""} class="btn btn-primary btn-square btn-sm shadow-1 me-1"><i class="ri-send-plane-2-fill"></i></button><textarea rows="1" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.send_new_message") + " ...")}>${ssrInterpolate(unref(sendAnswerForm).content)}</textarea><span data-bs-toggle="modal" data-bs-target="#send-attachment" class="attachment-icon ps-2"><i class="send ri-attachment-2"></i></span></div>`);
      } else if (_ctx.ticket.status == "closed") {
        _push(`<div class="send-answer-ticket"><span class="ticket-closed lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ticket_is_closed_and_cant_send_answer"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</form><div class="modal fade" id="send-attachment" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.send_attachment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body add-ticket-form"><div class="form-element-row form-element-row-file mb-4"><div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.upload_your_image_as_attachment_to_ticket"))}</div><div class="fs-9 text-muted mb-4">(${ssrInterpolate(_ctx.$t("messages.sentence.ticket_attachment_hint"))})</div></div>`);
      if (imageUrl.value != null) {
        _push(`<div class="selected-image" style="${ssrRenderStyle({ "width": "200px", "height": "auto" })}"><img style="${ssrRenderStyle({ "width": "200px", "height": "auto" })}" class="shadow-1"${ssrRenderAttr("src", imageUrl.value)}><i class="ri-close-line shadow-1 remove-image"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file"><input type="file" class="custom-input-file-input" id="attachment" accept=".png,.jpg,.jpeg,.webp,.svg"><label for="attachment" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label></div></div></div><div class="modal-footer"><button type="button" class="btn btn-sm btn-light px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button${ssrIncludeBooleanAttr(unref(sendAttachmentForm).processing) ? " disabled" : ""} type="submit" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.send"))}</button></div></form></div></div></div></div></div></div>`);
      if (imagePreview.value != null) {
        _push(`<div class="show-ticket-image"><div class="overlay"><div><img class="shadow-1"${ssrRenderAttr("src", imagePreview.value["link"])}${ssrRenderAttr("alt", imagePreview.value["alt"])}><span class="shadow-1">${ssrInterpolate(imagePreview.value["name"])}</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Tickets/Show.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
