import { defineComponent, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext, createVNode, createBlock, createCommentVNode, openBlock, ref, reactive, resolveDirective, onMounted, computed, watch, provide } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderAttr, ssrRenderStyle, ssrRenderClass, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderList, ssrGetDirectiveProps, ssrRenderSlot } from "vue/server-renderer";
import { Link, usePage, useForm, router, Head } from "@inertiajs/vue3";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import $ from "jquery";
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { _ as _sfc_main$6 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$5 } from "./SearchList-BZnYMQPN.js";
import "toastify-js";
import ProgressBar from "primevue/progressbar/progressbar.esm.js";
import ConfirmDialog from "primevue/confirmdialog/confirmdialog.esm.js";
import { useConfirm } from "primevue/useconfirm/useconfirm.esm.js";
import { u as useRandomNum } from "./useRandomNum-DNNSqR7b.js";
import { Tooltip } from "bootstrap";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "Breadcrumb",
  __ssrInlineRender: true,
  props: {
    title: {},
    item: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "row page-top mb-4" }, _attrs))}><div class="col-12 d-flex align-items-center justify-content-between"><div class="page-title">${ssrInterpolate(_ctx.title)}</div><nav aria-label="breadcrumb"><ol class="breadcrumb"><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.sellers_panel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.sellers_panel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item active" aria-current="page">${ssrInterpolate(_ctx.item != null ? _ctx.item : _ctx.title)}</li></ol></nav></div></div>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Store/Breadcrumb.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Sidebar",
  __ssrInlineRender: true,
  props: {
    sidebar: { type: Boolean }
  },
  emits: ["updateSidebar"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) {
        emit("updateSidebar", false);
      }
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) emit("updateSidebar", false);
        else emit("updateSidebar", true);
      });
    }
    const closeSidebarInDevice = () => {
      if (typeof window !== "undefined") {
        if (window.innerWidth <= 768) {
          emit("updateSidebar", false);
        }
      }
    };
    const isActive = (values) => {
      for (let value of values) {
        if (typeof window !== "undefined") {
          if (!usePage().props.currentRouteName.includes(value)) {
            continue;
          }
          return usePage().props.currentRouteName.includes(value);
        }
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<nav${ssrRenderAttrs(mergeProps({
        class: _ctx.sidebar ? "admin-sidebar seller-sidebar open" : "admin-sidebar seller-sidebar"
      }, _attrs))}><div class="sidebar--top-section"><div class="title">${ssrInterpolate(_ctx.$page.props.appName)}</div><span class="sidebar-toggle"><i class="ri-menu-4-fill"></i></span></div><div class="sidebar-inner simplebar-container"><div class="sidebar--account-section mt-4"><div class="inner"><div class="store-logo-bg-pattern"></div><div class="user-avatar mb-4"><img class="shadow-1" width="60" height="60"${ssrRenderAttr("src", _ctx.$page.props.auth.store.get_logo)}${ssrRenderAttr("alt", _ctx.$page.props.auth.store.name)} style="${ssrRenderStyle({ "background-color": "white" })}"></div><div class="user-details"><span class="name mb-1">${ssrInterpolate(_ctx.$page.props.auth.store.name)}</span><span class="type">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span></div></div></div><ul class="menu-list" id="sidebarAccordion"><li class="title">${ssrInterpolate(_ctx.$t("messages.word.overview"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.dashboard"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-home-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.dashboard"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-home-3-line" }),
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.dashboard")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.financial_and_payments"))}</li><li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["seller.orders"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#ordersItem"${ssrRenderAttr("aria-expanded", isActive(["seller.orders"]))} aria-controls="ordersItem"><i class="ri-archive-2-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.orders"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span>`);
      if (_ctx.$page.props.auth.sellerBadge["waiting-orders"] > 0) {
        _push(`<span class="count-badge sub shadow-1">${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-orders"])}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</a><ul id="ordersItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["seller.orders"]) })}"><li class="${ssrRenderClass({ active: isActive(["seller.orders.awaiting"]), "has-notification": _ctx.$page.props.auth.sellerBadge["waiting-orders"] > 0 })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.orders.awaiting")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.awaiting_review")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><span class="item-title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span></a>`);
      }
      _push(`</li><li class="${ssrRenderClass({ active: isActive(["seller.orders.sent"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.orders.sent")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.sent")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span></a>`);
      }
      _push(`</li><li class="${ssrRenderClass({ active: isActive(["seller.orders.delivered"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.orders.delivered")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.delivered")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span></a>`);
      }
      _push(`</li><li class="${ssrRenderClass({ active: isActive(["seller.orders.cancelled"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.orders.cancelled")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.cancelled")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span></a>`);
      }
      _push(`</li></ul></li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.transactions.index"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.transactions.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-bank-card-2-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.transactions"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-bank-card-2-line" }),
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.transactions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["seller.wallet"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#financialItem"${ssrRenderAttr("aria-expanded", isActive(["seller.wallet"]))} aria-controls="financialItem"><i class="ri-wallet-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.financial"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="financialItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["seller.wallet", "seller.pending_payments"]) })}"><li class="${ssrRenderClass({ active: isActive(["seller.wallet.index"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.wallet.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.wallet"))}</span>`);
          } else {
            return [
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.wallet")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: isActive(["seller.wallet.withdrawals"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.wallet.withdrawals")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.withdrawals"))}</span>`);
          } else {
            return [
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.withdrawals")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: isActive(["seller.pending_payments.index"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.pending_payments.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.shares_pending_payments"))}</span>`);
          } else {
            return [
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.shares_pending_payments")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></li>`);
      if (_ctx.$page.props.auth.store != null && _ctx.$page.props.auth.store.direct_post) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.transportation.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.transportation.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-truck-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.transportation"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-truck-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.transportation")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.support_affairs"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.tickets"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("seller.tickets.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-message-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.tickets"))}</span>`);
            if (_ctx.$page.props.auth.sellerBadge["waiting-tickets"] > 0) {
              _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-tickets"])}</span>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("i", { class: "ri-message-3-line" }),
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.tickets")), 1),
              _ctx.$page.props.auth.sellerBadge["waiting-tickets"] > 0 ? (openBlock(), createBlock("span", {
                key: 0,
                class: "count-badge shadow-1"
              }, toDisplayString(_ctx.$page.props.auth.sellerBadge["waiting-tickets"]), 1)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.product_operation"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.products"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.products.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-shopping-basket-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.products"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-shopping-basket-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.products")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><i class="ri-shopping-basket-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.products"))}</span></a>`);
      }
      _push(`</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.storages", "seller.inventories"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.storages.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-home-4-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.warehousing"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-home-4-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.warehousing")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><i class="ri-home-4-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.warehousing"))}</span></a>`);
      }
      _push(`</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.questions"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.$page.props.auth.sellerBadge["waiting-questions"] > 0 ? _ctx.route("seller.questions.index", { awaiting_questions: true }) : _ctx.$page.props.auth.sellerBadge["waiting-question-answers"] > 0 ? _ctx.route("seller.questions.index", { awaiting_answers: true }) : _ctx.route("seller.questions.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-question-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.questions_and_answers"))}</span>`);
              if (_ctx.$page.props.auth.sellerBadge["waiting-questions"] > 0 || _ctx.$page.props.auth.sellerBadge["waiting-question-answers"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-questions"] + _ctx.$page.props.auth.sellerBadge["waiting-question-answers"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-question-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.questions_and_answers")), 1),
                _ctx.$page.props.auth.sellerBadge["waiting-questions"] > 0 || _ctx.$page.props.auth.sellerBadge["waiting-question-answers"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.sellerBadge["waiting-questions"] + _ctx.$page.props.auth.sellerBadge["waiting-question-answers"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><i class="ri-question-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.sentence.questions_and_answers"))}</span></a>`);
      }
      _push(`</li><li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.blog_operation"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["seller.articles"]) })}">`);
      if (_ctx.$page.props.auth.sellerAccess) {
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("seller.articles.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-article-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.articles"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-article-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.articles")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<a href="javascript:void(0)"><i class="ri-article-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.articles"))}</span></a>`);
      }
      _push(`</li></ul></div></nav>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Store/Sidebar.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Header",
  __ssrInlineRender: true,
  props: {
    sidebar: { type: Boolean }
  },
  emits: ["updateSidebar"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) {
        emit("updateSidebar", false);
      }
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) emit("updateSidebar", false);
        else emit("updateSidebar", true);
      });
    }
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      if (dark.value) {
        $("body").attr("id", "dark");
      } else {
        $("body").attr("id", "light");
      }
    }
    const isActive = (values) => {
      for (let value of values) {
        if (typeof window !== "undefined") {
          if (!usePage().props.currentRouteName.includes(value)) {
            continue;
          }
          return usePage().props.currentRouteName.includes(value);
        }
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<header${ssrRenderAttrs(mergeProps({
        class: _ctx.sidebar ? "page-header" : "page-header full"
      }, _attrs))}><div class="header-inner"><div><span style="${ssrRenderStyle(!_ctx.sidebar ? null : { display: "none" })}" class="sidebar-toggle"><i class="ri-menu-4-fill"></i></span></div><ul class="header-meta"><li>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.notifications.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-notification-3-line"${_scopeId}></i><span class="count-badge"${_scopeId}>${ssrInterpolate(_ctx.$page.props.notificationCount)}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-notification-3-line" }),
              createVNode("span", { class: "count-badge" }, toDisplayString(_ctx.$page.props.notificationCount), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li id="darkLight"><button><i class="${ssrRenderClass(dark.value ? "ri-sun-line" : "ri-moon-line")}"></i></button></li><li><a href="javascript:void(0)"><i class="ri-fullscreen-line"></i></a></li><li class="user-avatar dropdown"><img class="shadow-1" data-bs-toggle="dropdown"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)} width="40" height="40"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}><div data-bs-toggle="dropdown" class="d-md-block d-none"><span class="user-name">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span><span class="user-type">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</span></div><div class="dropdown-menu shadow-1"><ul><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["seller.information.edit"]) },
        href: _ctx.route("seller.information.edit")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-store-2-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_store"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-store-2-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_store")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["seller.profile.edit"]) },
        href: _ctx.route("seller.profile.edit")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-user-smile-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_profile"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-user-smile-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_profile")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["seller.profile.sessions"]) },
        href: _ctx.route("seller.profile.sessions")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-device-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.active_sessions"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-device-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.active_sessions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.notifications.index"),
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["seller.notifications.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-notification-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.notifications"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-notification-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.notifications")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "dropdown-item lts-05",
        method: "post",
        href: _ctx.route("logout"),
        as: "button"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-logout-circle-r-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-logout-circle-r-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.logout")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></li></ul></div></header>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Store/Header.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Files",
  __ssrInlineRender: true,
  props: {
    mediaLibrary: {},
    keyword: {}
  },
  emits: ["mediaData"],
  setup(__props, { emit: __emit }) {
    ref();
    const fileType = ref();
    const imageUrl = ref();
    const sizeToMB = ref();
    const uploadFileForm = useForm({
      file: null,
      description: null,
      optimization: true,
      cropImage: false,
      addWatermark: false
    });
    useConfirm();
    const mediaReactive = reactive({
      id: useRandomNum(1e5, 999999),
      type: "",
      file: null
    });
    if (typeof window !== "undefined") {
      $(() => {
        const mediaLibraryModal = document.getElementById("mediaLibrary");
        mediaLibraryModal.addEventListener("shown.bs.modal", (event) => {
          const button = event.relatedTarget;
          mediaReactive.type = button.getAttribute("data-bs-input");
        });
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "modal fade",
        id: "mediaLibrary",
        tabindex: "-1",
        "aria-hidden": "true"
      }, _attrs))}><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="row"><div class="col-12"><div class="card upload-file-container"><div class="card-body p-0"><div class="media-modal-header d-flex align-items-center justify-content-between mb-3"><span>${ssrInterpolate(_ctx.$t("messages.sentence.media_library"))}</span><i class="ri-close-line close-modal" data-bs-dismiss="modal"></i></div><form class="mb-3"><div class="form-element-row form-element-row-file">`);
      if (fileType.value == null) {
        _push(`<div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_yout_image_for_upload"))}</div><div class="fs-7 text-muted mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_formats"))}</div><div class="fs-7 text-muted mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_size"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file">`);
      if (fileType.value == null) {
        _push(`<label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input type="file" class="custom-input-file-input" id="uploadFile" accept=".png,.jpg,.jpeg,.webp,.gif,.svg"></div>`);
      if (fileType.value != null && !unref(uploadFileForm).processing) {
        _push(`<div class="row after-select-container"><div class="col-xl-2 col-lg-2 col-md-3 col-12 mb-4 mb-md-0">`);
        if (fileType.value == "image") {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + imageUrl.value + ")" })}"></div></div></div></div>`);
        } else if (fileType.value == "pdf" || fileType.value == "zip" || fileType.value == "mp3" || fileType.value == "mp4") {
          _push(`<div class="file-grid other-file"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (fileType.value == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")}>`);
          } else if (fileType.value == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")}>`);
          } else if (fileType.value == "mp3") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")}>`);
          } else if (fileType.value == "mp4") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(sizeToMB.value + "MB")}</span></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-xl-10 col-lg-10 col-md-9 col-12 d-flex flex-column justify-content-center">`);
        if (fileType.value != null) {
          _push(`<div class="file-description mb-3"><input${ssrRenderAttr("value", unref(uploadFileForm).description)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.file_full_name_for_seo"))}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="d-flex justify-content-between align-items-center upload-bottom-action-bar">`);
        if (fileType.value == "image") {
          _push(`<div class="image-crop"><label class="lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).optimization) ? ssrLooseContain(unref(uploadFileForm).optimization, null) : unref(uploadFileForm).optimization) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.image_optimization"))}</label><label class="ms-4 lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).cropImage) ? ssrLooseContain(unref(uploadFileForm).cropImage, null) : unref(uploadFileForm).cropImage) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.crop_image_square"))}</label></div>`);
        } else {
          _push(`<div></div>`);
        }
        _push(`<div class="custom-input-file">`);
        if (fileType.value != null) {
          _push(`<button${ssrIncludeBooleanAttr(unref(uploadFileForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary shadow-1"><i class="ri-upload-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.upload"))}</button>`);
        } else {
          _push(`<!---->`);
        }
        if (fileType.value != null) {
          _push(`<button type="button" class="btn btn-danger btn-square btn-sm ms-2 shadow-1"><i class="ri-delete-bin-line"></i></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(uploadFileForm).processing) {
        _push(`<div class="row uploading-progress"><div class="col-12">`);
        if (unref(uploadFileForm).progress) {
          _push(ssrRenderComponent(unref(ProgressBar), {
            value: unref(uploadFileForm).progress.percentage
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></form>`);
      _push(ssrRenderComponent(_sfc_main$5, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.image_title") + " ..."
      }, null, _parent));
      _push(`<div class="row file-container mb-3"><!--[-->`);
      ssrRenderList(_ctx.mediaLibrary.files.data, (file) => {
        _push(`<div class="col-xl-2 col-md-4 col-sm-4 col-6 mb-2"><div class="${ssrRenderClass({ file: true, "shadow-1": true, dropdown: true, "other-file": file.type != "image" })}">`);
        if (file.type == "image") {
          _push(`<div${ssrRenderAttrs(mergeProps({ class: "file-grid" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.choose_image"), void 0, { top: true })))}><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + _ctx.$page.props.appUrl + file.url + ")" })}"></div></div></div><div class="black-mask"></div><div class="add-image"><button class="btn btn-square btn-xs btn-white shadow-2"><i class="ri-add-line"></i></button></div></div>`);
        } else {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (file.type == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")} alt="pdf">`);
          } else if (file.type == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")} alt="zip">`);
          } else if (file.type == "audio") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")} alt="mp3">`);
          } else if (file.type == "video") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")} alt="mp4">`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(file.name)}</span></div></div></div></div>`);
        }
        _push(`<i class="ri-more-2-fill image-details" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-1"><ul><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.title"))}: </span><span class="value">${ssrInterpolate(file.description != null ? file.description : _ctx.$t("messages.word.empty"))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.file_format"))}: </span><span class="value">${ssrInterpolate(file.extension)}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.volume"))}: </span><span class="value">${ssrInterpolate(Math.round(file.size / 1e3 * 100) / 100)} ${ssrInterpolate(_ctx.$t("messages.word.megabyte"))}</span></li><li class="copy-file-url"><form action="#"><button class="no-btn" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.copy_link"))}</button></form></li><li class="remove-image"><button class="no-btn" type="submit">${ssrInterpolate(_ctx.$t("messages.sentence.delete_file"))}</button></li></ul></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      _push(ssrRenderComponent(unref(ConfirmDialog), null, {
        message: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="lts-05"${_scopeId}><strong class="text-danger"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.file_deleted_from_wherever_used"))}</span>`);
          } else {
            return [
              createVNode("span", { class: "lts-05" }, [
                createVNode("strong", { class: "text-danger" }, toDisplayString(_ctx.$t("messages.word.warning")) + ":", 1),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.file_deleted_from_wherever_used")), 1)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (_ctx.mediaLibrary.files.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$6, {
        key: unref(useRandomNum)(1e3, 9999),
        links: _ctx.mediaLibrary.files.links,
        "preserve-state": true,
        preserveScroll: true,
        only: "mediaLibrary"
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Store/Files.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "StoreLayout",
  __ssrInlineRender: true,
  props: {
    mediaLibrary: {},
    keyword: {}
  },
  setup(__props) {
    if (typeof window !== "undefined") {
      $(() => {
        window.jalaliDatepicker.startWatch({});
      });
    }
    onMounted(() => {
      new Tooltip(document.body, {
        selector: "[data-bs-toggle='tooltip']"
      });
    });
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    if (typeof window !== "undefined") {
      $(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
      });
    }
    const errorMessages = computed(() => {
      return usePage().props.errors;
    });
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
      if (errorMessages.value != null && Object.keys(errorMessages.value).length > 0) {
        router.reload({ only: ["errors"] });
      }
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") {
        return usePage().props.flash.message;
      }
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) {
        useToast(messages[i], "success", 4e3);
      }
      if (flashMessage.value != null && Object.keys(flashMessage.value).length > 0) {
        router.reload({ only: ["flash"] });
      }
    });
    const sidebar = ref(true);
    const updateSidebar = (value) => {
      sidebar.value = value;
    };
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) {
        sidebar.value = false;
      }
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) sidebar.value = false;
        else sidebar.value = true;
      });
    }
    const mediaReactive = reactive({
      id: 0,
      type: "",
      file: null
    });
    const mediaData = (value) => {
      mediaReactive.id = value.id;
      mediaReactive.type = value.type;
      mediaReactive.file = value.file;
    };
    provide("mediaData", mediaReactive);
    onMounted(() => {
      if (usePage().props.template != null) {
        document.documentElement.style.setProperty("--primary", "rgb(0, 96, 255)");
        document.documentElement.style.setProperty("--primary-rgb", "0, 96, 255");
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template.get_options.style.site_main_color)}${_scopeId}><meta name="robots" content="noindex,nofollow"${_scopeId}><meta name="googlebot" content="noindex"${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template.get_options.style.site_main_color
              }, null, 8, ["content"]),
              createVNode("meta", {
                name: "robots",
                content: "noindex,nofollow"
              }),
              createVNode("meta", {
                name: "googlebot",
                content: "noindex"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="page-wrapper">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        sidebar: sidebar.value,
        onUpdateSidebar: updateSidebar
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$2, {
        sidebar: sidebar.value,
        onUpdateSidebar: updateSidebar
      }, null, _parent));
      _push(`<div class="${ssrRenderClass(sidebar.value ? "page-content" : "page-content full")}"><div class="container-fluid">`);
      if (_ctx.$page.props.auth.store.status == "awaiting") {
        _push(`<div class="row"><div class="${ssrRenderClass({ "col-12 mb-3": true, "mb-md-5": _ctx.$page.props.auth.store.bio != null })}"><div class="text-warning alert alert-warning mb-0 pt-3 pb-3 p-4"><span class="mb-2 fw-bold d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_963321"))}</span><span class="d-flex lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_669852"))}</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.store.bio == null && _ctx.$page.props.auth.store.status != "reject" && _ctx.$page.props.currentRouteName != "seller.information.edit") {
        _push(`<div class="row"><div class="col-12 mb-md-5 mb-3"><div class="d-flex flex-md-row flex-column align-items-start align-items-md-center justify-content-md-between justify-content-center text-info alert alert-info mb-0 pt-3 pb-3 p-4"><span class="lts-05 d-flex mb-md-0 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_599962"))}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.information.edit"),
          as: "button",
          class: "text-white btn btn-info fs-8"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.store_settings"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.store_settings")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.store.status == "reject") {
        _push(`<div class="row"><div class="col-12 mb-md-5 mb-3"><div class="text-danger alert alert-danger mb-0 p-4"><span class="mb-3 fw-bold d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_859632"))}</span><b class="d-flex fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.reason"))}:</b><span class="d-flex mb-3">${unref(useNl2br)(_ctx.$page.props.auth.store.reason) ?? ""}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.information.edit"),
          as: "button",
          class: "btn btn-danger fs-8"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_577452"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.msg_id_577452")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.store.status == "banned") {
        _push(`<div class="row"><div class="col-12 mb-md-5 mb-3"><div class="text-danger alert alert-danger mb-0 p-4"><span class="mb-3 fw-bold d-flex">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_415823"))}</span><b class="d-flex fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.reason"))}:</b><span class="d-flex mb-3">${unref(useNl2br)(_ctx.$page.props.auth.store.reason) ?? ""}</span><span class="d-flex mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_854875"))}</span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.tickets.create"),
          as: "button",
          class: "btn btn-danger fs-8"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_ticket")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div><footer class="page-footer"></footer></div>`);
      _push(ssrRenderComponent(_sfc_main$1, {
        mediaLibrary: _ctx.mediaLibrary,
        keyword: _ctx.keyword,
        onMediaData: mediaData
      }, null, _parent));
      if (sidebar.value) {
        _push(`<div class="sidebar-black-mask"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/StoreLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _,
  _sfc_main$4 as a
};
