import { defineComponent, ref, onMounted, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrRenderList, ssrRenderAttr, ssrInterpolate, ssrIncludeBooleanAttr, ssrRenderStyle, ssrRenderComponent } from "vue/server-renderer";
import Swiper from "swiper/bundle";
import { Link } from "@inertiajs/vue3";
import { u as useNumberFormat } from "../ssr.js";
const PLAY_TIME = 6 * 1e3;
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Stories",
  __ssrInlineRender: true,
  props: {
    status: {},
    component_id: {},
    stories: {}
  },
  setup(__props) {
    const props = __props;
    const initStoriesStatus = ref(props.status == "dev" ? true : false);
    const swiperStoriesSliderTempContainer = () => {
      new Swiper(".swiper-stories-slider-temp-" + props.component_id, {
        slidesPerView: 10,
        spaceBetween: 1,
        breakpoints: {
          120: {
            slidesPerView: 3,
            spaceBetween: 1
          },
          350: {
            slidesPerView: 4,
            spaceBetween: 5
          },
          610: {
            slidesPerView: 5,
            spaceBetween: 5
          },
          768: {
            slidesPerView: 7,
            spaceBetween: 5
          },
          992: {
            slidesPerView: 9,
            spaceBetween: 10
          },
          1150: {
            slidesPerView: 11,
            spaceBetween: 10
          },
          1260: {
            slidesPerView: 12,
            spaceBetween: 10
          }
        },
        navigation: {
          nextEl: ".stories-section .swiper-button-next-" + props.component_id,
          prevEl: ".stories-section .swiper-button-prev-" + props.component_id
        },
        on: {
          init: () => {
            initStoriesStatus.value = true;
          }
        },
        observer: true
      });
    };
    const swiperStoriesSliderContainer = () => {
      new Swiper(".swiper-stories-slider-" + props.component_id, {
        slidesPerView: 10,
        spaceBetween: 1,
        breakpoints: {
          120: {
            slidesPerView: 3,
            spaceBetween: 0
          },
          350: {
            slidesPerView: 4,
            spaceBetween: 0
          },
          480: {
            slidesPerView: 5,
            spaceBetween: 0
          },
          610: {
            slidesPerView: 6,
            spaceBetween: 0
          },
          768: {
            slidesPerView: 7,
            spaceBetween: 0
          },
          992: {
            slidesPerView: 9,
            spaceBetween: 0
          },
          1100: {
            slidesPerView: 11,
            spaceBetween: 0
          },
          1200: {
            slidesPerView: 12,
            spaceBetween: 0
          },
          1300: {
            slidesPerView: 13,
            spaceBetween: 0
          }
        },
        navigation: {
          nextEl: ".stories-section .swiper-button-next-" + props.component_id,
          prevEl: ".stories-section .swiper-button-prev-" + props.component_id
        },
        on: {
          init: () => {
            initStoriesStatus.value = true;
          },
          click: (swiper, event) => {
            if (swiperStorySlider.value != null && swiper.clickedIndex !== void 0) {
              swiperStorySlider.value.slideTo(swiper.clickedIndex, 0);
              let currentSlideEl = swiper.slides[swiper.clickedIndex];
              let storyId = currentSlideEl.getAttribute("story-id");
              showStory(parseInt(storyId));
            }
          }
        },
        observer: true
      });
    };
    const isShowingStory = ref(false);
    const swiperStorySlider = ref(null);
    const swiperStorySliderContainer = () => {
      swiperStorySlider.value = new Swiper(".swiper-story-slider-" + props.component_id, {
        slidesPerView: 1,
        spaceBetween: 0,
        autoplay: false,
        effect: "fade",
        fadeEffect: {
          crossFade: true
        },
        navigation: {
          nextEl: ".show-story .swiper-button-next-" + props.component_id,
          prevEl: ".show-story .swiper-button-prev-" + props.component_id
        },
        pagination: {
          el: ".show-story .swiper-pagination-" + props.component_id,
          type: "bullets",
          clickable: true,
          dynamicBullets: false,
          renderBullet: function(index, className) {
            return `<span class="swiper-pagination-bullet"><span></span></span>`;
          }
        },
        observer: true,
        observeParents: true,
        observeSlideChildren: true,
        on: {
          beforeTransitionStart: (swiper, speed, internal) => {
            $(".show-story .swiper-pagination-bullet-active > span").css({ visibility: "hidden" });
            $(".show-story .swiper-pagination-bullet-active > span").css({ width: "0%" });
            let currentSlideIndex = swiperStorySlider.value.realIndex;
            let storyId = swiperStorySlider.value.slides[currentSlideIndex].getAttribute("story-id");
            showStory(parseInt(storyId));
          },
          slideChangeTransitionEnd: (swiper) => {
          }
        }
      });
    };
    onMounted(() => {
      swiperStoriesSliderTempContainer();
      swiperStoriesSliderContainer();
      swiperStorySliderContainer();
    });
    const videoElems = ref([]);
    const isPlayingVideo = ref(false);
    const isMuted = ref(false);
    const resetVideos = async () => {
      swiperStorySlider.value.autoplay.stop();
      await videoElems.value.forEach((element) => {
        if (!element.paused) {
          element.pause();
          element.currentTime = 0;
        }
      });
    };
    const storyImageStatus = ref(false);
    const isPlayingImage = ref(false);
    const timePercent = ref(0);
    const interval = ref(null);
    const percentAnimation = (action) => {
      {
        interval.value = setInterval(() => {
          if (timePercent.value < 100) {
            timePercent.value += 1;
            $(".show-story .swiper-pagination-bullet-active > span").css({ width: timePercent.value + "%" });
          }
        }, 60);
      }
    };
    const startImagePlay = () => {
      isPlayingImage.value = true;
      swiperStorySlider.value.params.autoplay.delay = PLAY_TIME;
      swiperStorySlider.value.autoplay.start();
      percentAnimation();
    };
    const showStory = async (story_id) => {
      $(".show-story .swiper-pagination-bullet-active > span").css({ width: "0%" });
      isShowingStory.value = true;
      isMuted.value = false;
      await resetVideos();
      storyImageStatus.value = true;
      isPlayingImage.value = false;
      clearInterval(interval.value);
      interval.value = null;
      timePercent.value = 0;
      let story = props.stories != void 0 ? props.stories.find((story2) => story2.id === story_id) : void 0;
      if (story != void 0) {
        if (story.type == "video") {
          if (videoElems.value[story.id].paused) {
            videoElems.value[story.id].currentTime = 0;
            videoElems.value[story.id].volume = 1;
            videoElems.value[story.id].play();
            setTimeout(() => {
              $(".show-story .swiper-pagination-bullet-active > span").css({ visibility: "visible" });
            }, 100);
          }
        } else if (story.type == "image") {
          startImagePlay();
          setTimeout(() => {
            $(".show-story .swiper-pagination-bullet-active > span").css({ visibility: "visible" });
          }, 100);
        }
      }
    };
    const showStoryRef = ref();
    const storyContainerRef = ref();
    onMounted(() => {
      if (typeof window !== "undefined") {
        if (window.innerWidth <= 440) {
          if (showStoryRef.value !== void 0 && showStoryRef.value != null) {
            showStoryRef.value.style.height = window.innerHeight + "px";
            storyContainerRef.value.style.height = window.innerHeight + "px";
          }
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: { container: true, readonly: _ctx.status == "dev" },
        style: initStoriesStatus.value ? "visibility: visible; height: initial;" : "visibility: hidden; height: 0;"
      }, _attrs))}><div class="stories-container mb-sm-3 mb-3 mt-3"><div class="row"><div class="col-12 mb-sm-2 mb-0"><div class="stories-section"><div class="swiper-slider-controller swiper-rtl"><div class="${ssrRenderClass("swiper-button-prev swiper-button-prev-" + _ctx.component_id)}"></div><div class="${ssrRenderClass("swiper-button-next swiper-button-next-" + _ctx.component_id)}"></div></div>`);
      if (_ctx.stories != void 0 && _ctx.stories.length > 0) {
        _push(`<div class="${ssrRenderClass("swiper swiper-stories-slider swiper-stories-slider-" + _ctx.component_id)}"><div class="swiper-wrapper"><!--[-->`);
        ssrRenderList(_ctx.stories, (story) => {
          _push(`<div class="swiper-slide"${ssrRenderAttr("story-id", story.id)}><div class="story-ring d-flex flex-column align-items-center clickable"><div class="story-cover story-ring shadow-primary mb-2"><div><img${ssrRenderAttr("src", story.cover)}${ssrRenderAttr("alt", story.title)} loading="lazy"></div></div><span class="story-title text-ellipsis lts-05">${ssrInterpolate(story.title)}</span></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<div class="${ssrRenderClass("swiper swiper-stories-slider swiper-stories-slider-temp-" + _ctx.component_id)}"><div class="swiper-wrapper"><!--[-->`);
        ssrRenderList(new Array(16), (temp, index) => {
          _push(`<div class="${ssrRenderClass({ "swiper-slide": true, readonly: _ctx.status == "dev" })}"><div class="story-ring temp-story d-flex flex-column align-items-center"><div class="temp-story-cover story-cover story-ring mb-2"><div><div class="temp-img"></div></div></div><span class="story-title text-ellipsis lts-05 sk sk-sm sk-text lh-15"> عنوان استوری </span></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      }
      _push(`</div></div></div>`);
      if (_ctx.status == "prod") {
        _push(`<div class="${ssrRenderClass({ "show-story": true, show: isShowingStory.value })}"><div class="story-container"><div class="${ssrRenderClass("swiper swiper-stories-slider swiper-story-slider-" + _ctx.component_id)}"><div class="swiper-wrapper"><!--[-->`);
        ssrRenderList(_ctx.stories, (story) => {
          _push(`<div class="swiper-slide"${ssrRenderAttr("story-id", story.id)}><div class="story-data">`);
          if (storyImageStatus.value && story.type == "image") {
            _push(`<img${ssrRenderAttr("src", story.file)} loading="lazy">`);
          } else {
            _push(`<!---->`);
          }
          if (story.type == "video") {
            _push(`<video class="video"${ssrIncludeBooleanAttr(isMuted.value) ? " muted" : ""} preload="none"><source${ssrRenderAttr("src", story.file)} type="video/mp4"></video>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="cover-data"></div><div class="top-shadow-black"></div><div class="bottom-shadow-black"></div><div class="story-header d-flex align-items-center justify-content-between"><div class="right d-flex align-items-center"><div class="cover"><img${ssrRenderAttr("src", story.cover)}${ssrRenderAttr("alt", story.title)} loading="lazy"></div><span class="title text-white ms-2 fs-9 lts-05 fw-light lh-15">${ssrInterpolate(story.title)}</span><span class="text-white ms-2 fs-11 fw-light lh-15 white-space-nowrap">${ssrInterpolate(story.jalali_created_at[3])}</span></div><ul class="left">`);
          if (story.type == "video") {
            _push(`<li>`);
            if (isPlayingVideo.value) {
              _push(`<i class="ri-pause-mini-line"></i>`);
            } else {
              _push(`<!---->`);
            }
            if (!isPlayingVideo.value) {
              _push(`<i class="ri-play-fill"></i>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          if (story.type == "image") {
            _push(`<li>`);
            if (isPlayingImage.value) {
              _push(`<i class="ri-pause-mini-line"></i>`);
            } else {
              _push(`<!---->`);
            }
            if (!isPlayingImage.value) {
              _push(`<i class="ri-play-fill"></i>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<li><i class="ri-close-line"></i></li></ul></div>`);
          if (story.file != null) {
            _push(`<ul class="story-meta" style="${ssrRenderStyle({ bottom: story.get_widgets.product != null ? "15%" : "8%" })}"><li>`);
            if (story.is_liked) {
              _push(`<i class="ri-heart-fill text-danger"></i>`);
            } else {
              _push(`<i class="ri-heart-line"></i>`);
            }
            _push(`<span>${ssrInterpolate(unref(useNumberFormat)(story.like))}</span></li>`);
            if (story.type == "video") {
              _push(`<li class="mute-icon">`);
              if (!isMuted.value) {
                _push(`<i class="ri-volume-up-line" style="${ssrRenderStyle({ "font-size": "20px" })}"></i>`);
              } else {
                _push(`<!---->`);
              }
              if (isMuted.value) {
                _push(`<i class="ri-volume-mute-line" style="${ssrRenderStyle({ "font-size": "20px" })}"></i>`);
              } else {
                _push(`<!---->`);
              }
              _push(`</li>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</ul>`);
          } else {
            _push(`<!---->`);
          }
          if (story.get_widgets.link.title != null && story.get_widgets.link.title != "" && story.get_widgets.link.url != null && story.get_widgets.link.url != "") {
            _push(`<a${ssrRenderAttr("href", story.get_widgets.link.url)} class="story-link link lts-05 shadow-smooth-1" style="${ssrRenderStyle({ bottom: story.get_widgets.product != null ? "15%" : "8%" })}">${ssrInterpolate(story.get_widgets.link.title)} <i class="ri-link-m"></i></a>`);
          } else {
            _push(`<!---->`);
          }
          if (story.get_widgets.product != null) {
            _push(`<div class="story-product card"><div class="card-body d-flex align-items-center"><div class="image"><img${ssrRenderAttr("src", story.get_widgets.product.get_images[0]["link"])}${ssrRenderAttr("alt", story.get_widgets.product.title)} loading="lazy"></div><div class="meta d-flex align-items-center flex-column"><div class="title clickable lts-05">${ssrInterpolate(story.get_widgets.product.title)}</div>`);
            if (story.get_widgets.product.in_stock_status && story.get_widgets.product.inventory && story.get_widgets.product.best_normal_price.discount_price != null) {
              _push(`<div class="discount-percent bg-secondary shadow-secondary shadow-1 me-2">${ssrInterpolate(story.get_widgets.product.best_normal_price.percent)}<i class="ri-percent-fill"></i></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="w-100 d-flex align-items-center justify-content-between"><ul class="product-colors"><!--[-->`);
            ssrRenderList(story.get_widgets.product.unique_color, (color, index) => {
              _push(`<li style="${ssrRenderStyle("background-color:" + color.value.color + (color.value.color == "#ffffff" ? "; border: solid 1px #ddd" : ""))}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)} class="${ssrRenderClass({ "color-is-white": color.value.color == "#ffffff" })}"></li>`);
            });
            _push(`<!--]--></ul><div class="d-inline-flex align-items-center"><span class="product-rating-average fs-9 lh-15"><i class="ri-star-fill"></i><span class="fw-bold">${ssrInterpolate(story.get_widgets.product.comments_info.rating == "0" ? "-" : story.get_widgets.product.comments_info.rating)}</span></span>`);
            if (!story.get_widgets.product.in_stock_status) {
              _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span></div>`);
            } else if (story.get_widgets.product.inventory) {
              _push(`<!--[-->`);
              if (story.get_widgets.product.best_normal_price.discount_price != null) {
                _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05">${ssrInterpolate(story.get_widgets.product.best_normal_price.discount_price)} <span class="unit unit-sm"></span></span></div>`);
              } else {
                _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05">${ssrInterpolate(story.get_widgets.product.best_normal_price.price)} <span class="unit unit-sm"></span></span></div>`);
              }
              _push(`<!--]-->`);
            } else {
              _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span></div>`);
            }
            _push(`</div></div></div>`);
            _push(ssrRenderComponent(unref(Link), {
              class: "product-link",
              href: _ctx.route("main.products.show", story.get_widgets.product.slug)
            }, null, _parent));
            _push(`</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        });
        _push(`<!--]--></div></div><div class="${ssrRenderClass("story-pagination swiper-pagination-" + _ctx.component_id)}"></div><div class="swiper-slider-controller swiper-rtl"><div class="${ssrRenderClass("swiper-button-prev swiper-button-prev-" + _ctx.component_id)}"></div><div class="${ssrRenderClass("swiper-button-next swiper-button-next-" + _ctx.component_id)}"></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Main/UI/Stories/Stories.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
