import { defineComponent, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Trash",
  __ssrInlineRender: true,
  props: {
    brands: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.brand_list_trash")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.trash")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.brand_title") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.logo"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.product_count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.edit"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.brands.data, (brand) => {
        _push(`<tr><td><img width="35" height="35" class="br-10 shadow-1"${ssrRenderAttr("src", brand.get_logo)}${ssrRenderAttr("alt", brand.title)}></td><td><strong>${ssrInterpolate(brand.title)}</strong></td><td>${ssrInterpolate(brand.products_count)}</td><td>${ssrInterpolate(brand.view_count)}</td>`);
        if (brand.status == "deleted") {
          _push(`<td><span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.deleted"))}</span></td>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<td>${ssrInterpolate(brand.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("admin.brands.destroy", brand.slug),
          data: { status: "publish" },
          as: "button",
          method: "delete"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-corner-up-right-double-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-corner-up-right-double-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-brand-" + brand.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-brand-" + brand.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_brand"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.brands.destroy", brand.slug),
          method: "delete",
          data: { status: "delete" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.brands.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.brands.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Brand/Trash.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
