import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "laravel-vue-i18n";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import ProgressBar from "primevue/progressbar/progressbar.esm.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Update",
  __ssrInlineRender: true,
  props: {
    details: {},
    changes: {}
  },
  setup(__props) {
    ref();
    const fileType = ref();
    const sizeToMB = ref();
    const updateProccessing = ref();
    const uploadFileForm = useForm({
      file: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.update_script")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.update_script"),
        item: _ctx.$t("messages.word.update")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body p-4"><div class="row">`);
      if (_ctx.details.hasUpdate) {
        _push(`<div class="col-12 d-flex flex-column align-items-center mb-2"><div class="d-inline-flex align-items-center alert alert-info text-info white-space-nowrap fs-7 fw-normal lts-05 px-3 py-2 br-15 mb-3"><span>${ssrInterpolate(_ctx.$t("messages.sentence.update_available"))}</span><span class="mx-2" style="${ssrRenderStyle({ "width": "4px", "height": "4px", "border-radius": "50px", "background-color": "#0dcaf0" })}"></span><span class="fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.version_number"))}: ${ssrInterpolate(_ctx.$page.props.panelDetails.latest_version)}</span></div>`);
        if (!_ctx.details.isUpdateFileExists) {
          _push(`<div class="mb-3"><span class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_512532"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.details.isUpdateFileExists) {
          _push(`<div class="upload-file-container">`);
          if (updateProccessing.value) {
            _push(`<div class="form-element-row-file d-flex align-items-center justify-content-center px-5"><div class="loading-circle mb-3"></div><div class="fw-bold lts-05 fs-6 text-dark text-center lh-25 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.updating"))} ...</div><div class="lts-05 fs-8 text-danger text-center lh-25 mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548996"))}</div><div class="lts-05 fs-8 text-gray text-center lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_588896"))}</div></div>`);
          } else {
            _push(`<div class="form-element-row-file d-flex align-items-center justify-content-center px-5"><div class="alert text-dark py-3" style="${ssrRenderStyle({ "background-color": "#e7edf3" })}"><div class="text-danger fw-bold mb-2">${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</div><div class="lts-05 fs-8 mb-2">1. ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_566932"))}</div><div class="lts-05 fs-8 mb-2">2. ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_912988"))}</div><div class="lts-05 fs-8">3. ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_365211"))}</div></div><div class="lts-05 fs-8 text-gray text-center lh-25 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_589652"))}</div><div>`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.updater.update"),
              onClick: ($event) => updateProccessing.value = true,
              "preserve-state": false,
              as: "button",
              method: "post",
              class: "btn btn-success"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.start_update"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.sentence.start_update")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent));
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.updater.delete"),
              as: "button",
              method: "delete",
              "preserve-state": false,
              class: "btn btn-danger-semi ms-2"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.delete_update_file"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.sentence.delete_update_file")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent));
            _push(`</div></div>`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="upload-file-container w-100"><form class="mb-3"><div class="form-element-row form-element-row-file">`);
          if (fileType.value == null) {
            _push(`<div class="text-center px-5"><div class="fs-7 lts-05 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_yout_file_for_upload"))}</div><div class="fs-7 lts-05 text-muted mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.file_name_must_be_vimashop_zip"))}</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="custom-input-file">`);
          if (fileType.value == null) {
            _push(`<label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_file"))}</span></label>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<input type="file" class="custom-input-file-input" id="uploadFile" accept=".zip"></div>`);
          if (fileType.value != null && !unref(uploadFileForm).processing) {
            _push(`<div class="row after-select-container"><div class="col-12 d-flex align-items-center justify-content-center mb-4"><div class="file-grid other-file" style="${ssrRenderStyle({ "width": "130px" })}"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")} style="${ssrRenderStyle({ "width": "50px" })}"><span class="file-size mt-2">${ssrInterpolate(sizeToMB.value + "MB")}</span></div></div></div></div></div><div class="col-12 d-flex flex-column justify-content-center"><div class="d-flex justify-content-center align-items-center upload-bottom-action-bar"><div class="custom-input-file">`);
            if (fileType.value != null) {
              _push(`<button${ssrIncludeBooleanAttr(unref(uploadFileForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary shadow-1 px-2 pe-3"><i class="ri-upload-2-line me-2"></i> ${ssrInterpolate(_ctx.$t("messages.word.upload"))}</button>`);
            } else {
              _push(`<!---->`);
            }
            if (fileType.value != null) {
              _push(`<button type="button" class="btn btn-danger btn-square btn-sm ms-2 shadow-1" style="${ssrRenderStyle({ "width": "36px", "height": "36px", "min-width": "36px" })}"><i class="ri-delete-bin-line" style="${ssrRenderStyle({ "font-size": "17px !important" })}"></i></button>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div></div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(uploadFileForm).processing) {
            _push(`<div class="row uploading-progress"><div class="col-12">`);
            if (unref(uploadFileForm).progress) {
              _push(ssrRenderComponent(unref(ProgressBar), {
                value: unref(uploadFileForm).progress.percentage
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></form></div>`);
        }
        _push(`</div>`);
      } else {
        _push(`<div class="col-12 d-flex flex-column align-items-center mb-2"><div class="d-inline-flex align-items-center alert bg-success text-success white-space-nowrap fs-7 fw-normal lts-05 px-3 py-2 br-15 mb-0"><span>${ssrInterpolate(_ctx.$t("messages.sentence.script_is_update"))}</span></div></div>`);
      }
      _push(`<div class="col-12 my-4"><div class="border"></div></div><div class="col-12"><div class="fw-bold lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.version_changes_list"))}:</div><div class="accordion" id="accordionVersionChanges"><!--[-->`);
      ssrRenderList(_ctx.changes, (change, index) => {
        _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="${ssrRenderClass({ "accordion-button ": true, collapsed: index > 0 })}" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-" + index)}${ssrRenderAttr("aria-expanded", index > 0 ? false : true)}${ssrRenderAttr("aria-controls", "collapse-" + index)}><span class="me-1 fs-8">${ssrInterpolate(_ctx.$t("messages.word.version"))}: </span><span>${ssrInterpolate(change["version"])}</span>`);
        if (change["version"] == _ctx.details.currentVersion) {
          _push(`<span class="badge bg-success ms-2">${ssrInterpolate(_ctx.$t("messages.sentence.current_version"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</button></h2><div${ssrRenderAttr("id", "collapse-" + index)} class="${ssrRenderClass({ "accordion-collapse collapse": true, show: index == 0 })}" data-bs-parent="#accordionVersionChanges"><div class="accordion-body"><ul style="${ssrRenderStyle({ "list-style": "decimal" })}" class="ps-3"><!--[-->`);
        ssrRenderList(change["changes"], (item, i) => {
          _push(`<li class="mb-3">${ssrInterpolate(item)}</li>`);
        });
        _push(`<!--]--></ul></div></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Updater/Update.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
