<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stores', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();

            $table->string('uuid')->unique();
            $table->string('name');
            $table->text('bio')->nullable();
            $table->string('logo')->nullable();
            $table->text('meta');

            $table->text('information');

            $table->unsignedBigInteger('view_count')->default(0);
            $table->string('type');
            $table->boolean('direct_post');
            $table->text('reason')->nullable();
            $table->string('status');

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
        });

        Schema::create('product_store', function (Blueprint $table) {
            $table->unsignedBigInteger("store_id");
            $table->foreign('store_id')->references('id')->on('stores')->cascadeOnDelete();

            $table->unsignedBigInteger("product_id");
            $table->foreign('product_id')->references('id')->on('products')->cascadeOnDelete();

            $table->timestamps();

            $table->primary(["store_id", "product_id"]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stores');
        Schema::dropIfExists('product_store');
    }
};
