<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_tags', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug');

            $table->unsignedBigInteger('view_count')->default('0');
            $table->string('status');

            $table->timestamps();
        });

        Schema::create('product_product_tag', function (Blueprint $table) {
            $table->unsignedBigInteger("product_tag_id");
            $table->foreign('product_tag_id')->references('id')->on('product_tags')->cascadeOnDelete();

            $table->unsignedBigInteger("product_id");
            $table->foreign('product_id')->references('id')->on('products')->cascadeOnDelete();

            $table->primary(["product_tag_id", "product_id"]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_tags');
        Schema::dropIfExists('product_product_tag');
    }
};
