<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('templates', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('image')->nullable();
            $table->text('options');
            $table->text('options_backup')->nullable();
            $table->text('top_banner')->nullable();
            $table->string('header');
            $table->text('header_backup')->nullable();
            $table->string('footer');
            $table->text('footer_backup')->nullable();
            $table->text('data');
            $table->text('data_backup')->nullable();
            $table->text('blog_data');
            $table->text('blog_data_backup')->nullable();
            $table->string('type');
            $table->string('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('templates');
    }
};