<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('storage_id')->index();
            $table->unsignedBigInteger('product_id')->index();
            $table->unsignedBigInteger('store_id')->index()->nullable();

            $table->string('uuid')->unique();
            $table->unsignedBigInteger('price');
            $table->unsignedBigInteger('discount_price')->nullable();
            $table->timestamp('discount_expire')->nullable();
            $table->text('discount_tree')->nullable();
            $table->unsignedBigInteger('count');
            $table->integer('min_sale')->default(1);
            $table->integer('max_sale')->nullable();
            $table->boolean('original')->default(1);
            $table->boolean('used')->default(0);
            $table->unsignedBigInteger('weight')->nullable();
            $table->unsignedBigInteger('purchase_price')->nullable();
            $table->text('price_changes')->nullable();
            $table->string('image')->nullable();
            $table->text('description')->nullable();
            $table->string('send_time')->nullable();

            $table->string('status');

            $table->timestamps();

            $table->foreign('storage_id')->references('id')->on('storages')->cascadeOnDelete();
            $table->foreign('product_id')->references('id')->on('products')->cascadeOnDelete();
            $table->foreign('store_id')->references('id')->on('stores')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventories');
    }
};
