<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('store_id')->index()->nullable();

            $table->text('reception_centers_addresses')->nullable();
            $table->text('post_ways');
            $table->string('post_period')->nullable();
            $table->unsignedBigInteger('free_post_min_price')->nullable();
            $table->text('description')->nullable();

            $table->timestamps();

            $table->foreign('store_id')->references('id')->on('stores')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_metas');
    }
};
