<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('article_tags', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug');

            $table->unsignedBigInteger('view_count')->default('0');
            $table->string('status');

            $table->timestamps();
        });

        Schema::create('article_article_tag', function (Blueprint $table) {
            $table->unsignedBigInteger("article_tag_id");
            $table->foreign('article_tag_id')->references('id')->on('article_tags')->cascadeOnDelete();

            $table->unsignedBigInteger("article_id");
            $table->foreign('article_id')->references('id')->on('articles')->cascadeOnDelete();

            $table->primary(["article_tag_id", "article_id"]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('article_tags');
        Schema::dropIfExists('article_article_tag');
    }
};
