<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->unsignedBigInteger('order_group_id')->index()->nullable();

            $table->string('uuid')->unique();
            $table->text('discount')->nullable();
            $table->text('address')->nullable();
            $table->text('send_method')->nullable();
            $table->text('delivery_date')->nullable();
            $table->string('post_tracking_code')->nullable();
            $table->text('description')->nullable();
            $table->boolean('is_locked')->default(false);
            $table->string('status');

            $table->timestamp('sent_at')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('order_group_id')->references('id')->on('order_groups')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
