<?php

use App\Http\Controllers\Api\v1\Emalls\EmallsProductsController;
use App\Http\Controllers\Api\v1\Inventories\InventoriesController;
use App\Http\Controllers\Api\v1\Products\ProductsController;
use App\Http\Controllers\Api\v1\Snapppay\SnapppayProductsController;
use App\Http\Controllers\Api\v1\Storages\StoragesController;
use App\Http\Controllers\Api\v1\Torob\TorobProductsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// api v1
Route::prefix('v1')->group(function () {
    // torob
    Route::prefix('torob')->group(function () {
        Route::get('products', [TorobProductsController::class, 'index'])->name('torob.products');
    });

    // emalls
    Route::prefix('emalls')->group(function () {
        Route::get('products', [EmallsProductsController::class, 'index'])->name('emalls.products');
    });

    // snapppay
    Route::prefix('snapppay')->group(function () {
        Route::get('products', [SnapppayProductsController::class, 'index'])->name('snapppay.products');
    });

    // products
    Route::prefix('products')->middleware(['api.key.auth'])->group(function () {
        Route::get('/', [ProductsController::class, 'index'])->name('products.index');
        Route::get('/show/{uuid}', [ProductsController::class, 'show'])->name('products.show');
        Route::post('/create', [ProductsController::class, 'create'])->name('products.create');
        Route::put('/update/{uuid}', [ProductsController::class, 'update'])->name('products.update');
        Route::delete('/delete/{uuid}', [ProductsController::class, 'delete'])->name('products.delete');
    });

    // storages
    Route::prefix('storages')->middleware(['api.key.auth'])->group(function () {
        Route::get('/', [StoragesController::class, 'index'])->name('storages.index');
        Route::get('/products/{storage_uuid}', [StoragesController::class, 'show'])->name('storages.show');
    });

    // inventories
    Route::prefix('inventories')->middleware(['api.key.auth'])->group(function () {
        Route::get('/product/{product_uuid}', [InventoriesController::class, 'index'])->name('inventories.index');
        Route::get('/show/{inventory_uuid}', [InventoriesController::class, 'show'])->name('inventories.show');
        Route::post('/product/{product_uuid}/create', [InventoriesController::class, 'create'])->name('inventories.create');
        Route::put('/update/{inventory_uuid}', [InventoriesController::class, 'update'])->name('inventories.update');
        Route::delete('/delete/{inventory_uuid}', [InventoriesController::class, 'delete'])->name('inventories.delete');
    });
});
