<?php

use App\Http\Controllers\Auth\PhoneLoginController;
use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('login', [PhoneLoginController::class, 'show'])->name('login'); // login page
    Route::post('login/process', [PhoneLoginController::class, 'process'])->middleware('throttle:6,1')->name('login.process'); // login process

    Route::get('login/verify', [PhoneLoginController::class, 'verify'])->name('login.verify'); // login authentication code page
    Route::post('login/do', [PhoneLoginController::class, 'login'])->name('login.do'); // login verify
});

Route::middleware('auth')->group(function () {
    Route::get('login/account-information', [PhoneLoginController::class, 'accountInformation'])->name('login.account.information'); // show complete user infromation
    Route::post('login/account-information/update', [PhoneLoginController::class, 'accountInformationUpdate'])->name('login.account.information.update'); // store user infromation

    Route::post('logout', [PhoneLoginController::class, 'logout'])->name('logout'); // logout user

    Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)->middleware(['signed', 'throttle:6,1'])->name('verification.verify');
    Route::post('email/verification-notification', [VerifyEmailController::class, 'sendVerification'])->middleware('throttle:6,1')->name('verification.send');
});