<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\Files\FilesController;
use App\Http\Controllers\Admin\Financial\TransactionsController;
use App\Http\Controllers\Admin\Menu\MenusController;
use App\Http\Controllers\Admin\Products\BrandsController;
use App\Http\Controllers\Admin\Products\ColorController;
use App\Http\Controllers\Admin\Products\ProductCategoriesController;
use App\Http\Controllers\Admin\Products\ProductsController;
use App\Http\Controllers\Admin\Products\ProductTagsController;
use App\Http\Controllers\Admin\Settings\SettingsController;
use App\Http\Controllers\Admin\Stores\StoresController;
use App\Http\Controllers\Admin\Templates\TemplatesController;
use App\Http\Controllers\Admin\Tickets\TicketsController;
use App\Http\Controllers\Admin\Account\NotificationsController;
use App\Http\Controllers\Admin\Account\ProfileController;
use App\Http\Controllers\Admin\Affiliates\AffiliatesController;
use App\Http\Controllers\Admin\Blog\ArticleCategoriesController;
use App\Http\Controllers\Admin\Blog\ArticleCommentsController;
use App\Http\Controllers\Admin\Blog\ArticlesController;
use App\Http\Controllers\Admin\Blog\ArticleTagsController;
use App\Http\Controllers\Admin\Faq\FaqController;
use App\Http\Controllers\Admin\Financial\DiscountController;
use App\Http\Controllers\Admin\Financial\PaymentMetaController;
use App\Http\Controllers\Admin\Financial\PendingPaymentsController;
use App\Http\Controllers\Admin\Financial\PrefactorsController;
use App\Http\Controllers\Admin\Financial\WithdrawalsController;
use App\Http\Controllers\Admin\Forms\FormsController;
use App\Http\Controllers\Admin\Newsletters\NewslettersController;
use App\Http\Controllers\Admin\Orders\OrdersController;
use App\Http\Controllers\Admin\Pages\PagesController;
use App\Http\Controllers\Admin\Products\CommentsController;
use App\Http\Controllers\Admin\Products\QuestionsController;
use App\Http\Controllers\Admin\Reports\ReportsController;
use App\Http\Controllers\Admin\Searches\SearchesController;
use App\Http\Controllers\Admin\Statistics\StatisticsController;
use App\Http\Controllers\Admin\Storage\InventoryController;
use App\Http\Controllers\Admin\Storage\StorageController;
use App\Http\Controllers\Admin\Stories\StoriesController;
use App\Http\Controllers\Admin\Updater\UpdaterController;
use App\Http\Controllers\Admin\Users\RolesController;
use App\Http\Controllers\Admin\Users\UsersController;
use App\Http\Controllers\Admin\WebService\WebServiceController;
use App\Http\Controllers\Blog\Articles\ArticlesController as BlogArticlesController;
use App\Http\Controllers\Blog\Articles\CommentsController as BlogCommentsController;
use App\Http\Controllers\Blog\BlogController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Main\Brand\BrandsController as MainBrandsController;
use App\Http\Controllers\Main\Cart\CartController;
use App\Http\Controllers\Main\Cart\Prefactor\PrefactorsController as MainPrefactorsController;
use App\Http\Controllers\Main\Faq\FaqController as MainFaqController;
use App\Http\Controllers\Main\Forms\FormsController as MainFormsController;
use App\Http\Controllers\Main\Products\ProductsController as MainProductsController;
use App\Http\Controllers\Main\MainController;
use App\Http\Controllers\Main\Pages\PagesController as MainPagesController;
use App\Http\Controllers\Main\Products\CommentsController as MainCommentsController;
use App\Http\Controllers\Main\Products\CompareController;
use App\Http\Controllers\Main\Products\QuestionsController as MainQuestionsController;
use App\Http\Controllers\Main\Sitemap\SitemapController;
use App\Http\Controllers\Main\Stores\StoresController as MainStoresController;
use App\Http\Controllers\Public\PrivateMediaController;
use App\Http\Controllers\Store\Account\InformationsController;
use App\Http\Controllers\Store\Account\NotificationsController as StoreNotificationsController;
use App\Http\Controllers\Store\Account\ProfileController as StoreProfileController;
use App\Http\Controllers\Store\Blog\ArticlesController as StoreArticlesController;
use App\Http\Controllers\Store\DashboardController as StoreDashboardController;
use App\Http\Controllers\Store\Files\FilesController as StoreFilesController;
use App\Http\Controllers\Store\Financial\PendingPaymentsController as StorePendingPaymentsController;
use App\Http\Controllers\Store\Register\RegisterController;
use App\Http\Controllers\Store\Tickets\TicketsController as StoreTicketsController;
use App\Http\Controllers\Store\Financial\TransactionsController as StoreTransactionsController;
use App\Http\Controllers\Store\Financial\WalletController as StoreWalletController;
use App\Http\Controllers\Store\Orders\OrdersController as StoreOrdersController;
use App\Http\Controllers\Store\Products\ProductsController as StoreProductsController;
use App\Http\Controllers\Store\Products\QuestionsController as StoreQuestionsController;
use App\Http\Controllers\Store\Storage\InventoryController as StoreInventoryController;
use App\Http\Controllers\Store\Storage\StorageController as StoreStorageController;
use App\Http\Controllers\Store\Transportation\TransportationController as StoreTransportationController;
use App\Http\Controllers\User\Addresses\AddressesController;
use App\Http\Controllers\User\DashboardController as UserDashboardController;
use App\Http\Controllers\User\Financial\TransactionsController as UserTransactionsController;
use App\Http\Controllers\User\Account\NotificationsController as UserNotificationsController;
use App\Http\Controllers\User\Account\ProfileController as UserProfileController;
use App\Http\Controllers\User\Comments\CommentsController as UserCommentsController;
use App\Http\Controllers\User\CustomerClub\CustomerClubController;
use App\Http\Controllers\User\Favorites\FavoritesController as UserFavoritesController;
use App\Http\Controllers\User\Financial\PrefactorsController as UserPrefactorsController;
use App\Http\Controllers\User\Financial\WalletController;
use App\Http\Controllers\User\History\HistoryController as UserHistoryController;
use App\Http\Controllers\User\Orders\OrdersController as UserOrdersController;
use App\Http\Controllers\User\Tickets\TicketsController as UserTicketsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/** redirects */
if (file_exists(storage_path('routes/web.php'))) {
    require storage_path('routes/web.php');
}

/** Main Template Routes */
Route::middleware(['web'])->group(function () {
    Route::get('/', [MainController::class, 'index'])->name('index'); // shop index page
    Route::post('search', [MainController::class, 'search'])->name('main.search'); // search typing

    Route::get('categories', [MainController::class, 'categories'])->name('main.categories'); // category list

    Route::get('products', [MainProductsController::class, 'index'])->name('main.products.index'); // products archive

    Route::get('product/{product}', [MainProductsController::class, 'show'])->name('main.products.show'); // product show
    Route::get('p/{uuid}', [MainProductsController::class, 'shortcut'])->name('main.products.shortcut'); // product show shortcut
    Route::post('p/{uuid}', [MainProductsController::class, 'shortcut_json'])->name('main.products.shortcut.json'); // product get shortcut json

    Route::post('product/{product}/add-to-cart', [MainProductsController::class, 'add_to_cart'])->name('main.products.add_to_cart'); // product add to cart
    Route::post('product/{product}/favorites', [MainProductsController::class, 'favorites'])->name('main.products.favorites'); // product add to favorites
    Route::post('product/{product}/notification', [MainProductsController::class, 'notification'])->name('main.products.notification'); // product notification

    Route::post('product/{product}/comment/add', [MainCommentsController::class, 'add'])->name('main.products.comments.add'); // product add comment
    Route::post('product/comment/{comment}/like', [MainCommentsController::class, 'like'])->name('main.products.comments.like'); // like comment
    Route::post('product/comment/{comment}/dislike', [MainCommentsController::class, 'dislike'])->name('main.products.comments.dislike'); // dislike comment
    Route::post('product/comment/{comment}/report', [MainCommentsController::class, 'report_comment'])->name('main.products.comments.report'); // dislike comment

    Route::post('product/{product}/question/add', [MainQuestionsController::class, 'add_question'])->name('main.products.questions.add'); // add questions
    Route::post('product/question/{question}/answer/add', [MainQuestionsController::class, 'add_answer'])->name('main.products.questions.answers.add'); // questions add answer
    Route::post('product/question/answer/{answer}/like', [MainQuestionsController::class, 'like_answer'])->name('main.products.questions.answers.like'); // questions like answer
    Route::post('product/question/answer/{answer}/dislike', [MainQuestionsController::class, 'dislike_answer'])->name('main.products.questions.answers.dislike'); // questions dislike answer

    Route::get('compare', [CompareController::class, 'show'])->name('main.compare.show')->middleware('auth'); // compare product page
    Route::post('compare/add/{product}', [CompareController::class, 'add'])->name('main.compare.add')->middleware('auth'); // add product to compare list
    Route::post('compare/delete/{compare}', [CompareController::class, 'delete'])->name('main.compare.delete')->middleware('auth'); // add product to compare list

    Route::get('brand/{brand}', [MainBrandsController::class, 'show'])->name('main.brands.show'); // brand show

    Route::get('store/{store}', [MainStoresController::class, 'show'])->name('main.stores.show'); // store show

    Route::get('page/{page}', [MainPagesController::class, 'show'])->name('main.pages.show'); // page show

    Route::get('faq', [MainFaqController::class, 'index'])->name('main.faq.index'); // faqs

    Route::get('form/{form}', [MainFormsController::class, 'show'])->name('main.forms.show'); // form show
    Route::post('form/answer/{form}', [MainFormsController::class, 'answer'])->name('main.forms.answer'); // form send answer

    Route::post('newsletter/subscribe', [MainController::class, 'subscribe'])->name('main.newsletter.subscribe'); // subscribe to newsletter

    Route::post('story/{story}/like', [MainController::class, 'like_story'])->name('main.stories.like'); // like story

    /** Cart Routes */
    Route::get('cart', [CartController::class, 'index'])->name('cart'); // cart page
    Route::prefix('cart')->middleware(['web', 'auth'])->group(function () {
        Route::post('/add', [CartController::class, 'add'])->name('cart.add'); // add to cart
        Route::post('/delete', [CartController::class, 'delete'])->name('cart.delete'); // delete from cart
        Route::post('/increase', [CartController::class, 'increase'])->name('cart.increase'); // increase cart count
        Route::post('/decrease', [CartController::class, 'decrease'])->name('cart.decrease'); // decrease cart count

        Route::get('/shiping', [CartController::class, 'shiping'])->name('cart.shiping'); // cart shiping page
        Route::post('/shiping/update', [CartController::class, 'shiping_update'])->name('cart.shiping.update'); // cart shiping update
        Route::post('/shiping/address/store', [CartController::class, 'store_address'])->name('cart.shiping.store_address'); // cart shiping store address
        Route::put('/shiping/address/{address}/update', [CartController::class, 'update_address'])->name('cart.shiping.update_address'); // cart shiping update address
        Route::delete('/shiping/address/{address}/delete', [CartController::class, 'delete_address'])->name('cart.shiping.delete_address'); // cart shiping delete address

        Route::get('/payment', [CartController::class, 'payment'])->name('cart.payment'); // cart payment page
        Route::post('/payment/check_discount', [CartController::class, 'check_discount'])->name('cart.payment.check_discount'); // cart check discount
        Route::post('/payment/gateway', [CartController::class, 'gateway'])->name('cart.payment.gateway'); // cart go to gateway
        Route::get('/payment/gateway', function () {
            return redirect()->route('cart');
        }); // cart go to gateway

        Route::get('/payment/callback', [CartController::class, 'callback_get'])->name('cart.payment.callback_get'); // cart payment gateway callback - get

        Route::get('/order/status', [CartController::class, 'status'])->name('cart.order.status'); // order status page
        Route::get('/transaction/error', [CartController::class, 'transaction_error'])->name('cart.transaction_error'); // transaction error
    });
    // post callback without auth
    Route::post('cart/payment/callback', [CartController::class, 'callback_post'])->name('cart.payment.callback_post'); // cart payment gateway callback - post

    /** Prefactor Routes */
    Route::prefix('prefactor/{uuid}/')->middleware(['web', 'auth'])->group(function () {
        Route::get('/shiping', [MainPrefactorsController::class, 'shiping'])->name('prefactor.shiping'); // prefactor shiping page
        Route::post('/shiping/update', [MainPrefactorsController::class, 'shiping_update'])->name('prefactor.shiping.update'); // prefactor shiping update

        Route::post('/shiping/address/store', [MainPrefactorsController::class, 'store_address'])->name('prefactor.shiping.store_address'); // prefactor shiping store address
        Route::put('/shiping/address/{address}/update', [MainPrefactorsController::class, 'update_address'])->name('prefactor.shiping.update_address'); // prefactor shiping update address
        Route::delete('/shiping/address/{address}/delete', [MainPrefactorsController::class, 'delete_address'])->name('prefactor.shiping.delete_address'); // prefactor shiping delete address

        Route::get('/payment', [MainPrefactorsController::class, 'payment'])->name('prefactor.payment'); // prefactor payment page
        Route::post('/payment/gateway', [MainPrefactorsController::class, 'gateway'])->name('prefactor.payment.gateway'); // prefactor go to gateway
    });

    /** Main Template Blog Routes */
    Route::prefix('blog')->middleware(['web'])->group(function () {
        Route::get('/', [BlogController::class, 'index'])->name('blog.index'); // shop index page

        Route::get('articles', [BlogArticlesController::class, 'index'])->name('blog.articles.index'); // articles archive

        Route::get('article/{article}', [BlogArticlesController::class, 'show'])->name('blog.articles.show'); // article show
        Route::post('article/vote/{article}', [BlogArticlesController::class, 'vote'])->name('blog.articles.vote'); // article vote

        Route::post('article/{article}/comment/add', [BlogCommentsController::class, 'add'])->name('blog.article.comments.add')->middleware(['auth']); // article add comment
        Route::post('article/comment/{comment}/like', [BlogCommentsController::class, 'like'])->name('blog.article.comments.like'); // like comment
        Route::post('article/comment/{comment}/dislike', [BlogCommentsController::class, 'dislike'])->name('blog.article.comments.dislike'); // dislike comment
    });

    /** sitemaps route */
    Route::middleware(['web'])->group(function () {
        Route::get('sitemap.xml', [SitemapController::class, 'index'])->name('sitemap.index'); // master sitemap
        Route::get('sitemap/{title}.xml', [SitemapController::class, 'urls'])->where('title', '.*')->name('sitemap.urls'); // sub-sitemaps with .xml support
    });
});

/** User Panel Routes */
Route::prefix('user')->middleware(['auth', 'readonly.owner'])->group(function () {
    Route::get('dashboard', [UserDashboardController::class, 'index'])->name('user.dashboard'); // dashboard

    Route::get('profile/edit', [UserProfileController::class, 'edit'])->name('user.profile.edit'); // show profile edit page
    Route::post('profile/update', [UserProfileController::class, 'update'])->name('user.profile.update'); // update profile
    Route::get('profile/sessions', [UserProfileController::class, 'sessions'])->name('user.profile.sessions'); // show active sessions
    Route::delete('profile/sessions/terminate', [UserProfileController::class, 'terminate'])->name('user.profile.sessions.terminate'); // terminate session

    Route::resource('tickets', UserTicketsController::class)->names('user.tickets'); // tickets Resources
    Route::post('ticket/{ticket}/answer', [UserTicketsController::class, 'answer'])->name('user.tickets.answer'); // send ticket answer
    Route::post('ticket/{ticket}/attachment', [UserTicketsController::class, 'attachment'])->name('user.tickets.attachment'); // send ticket attachment answer

    Route::get('notifications', [UserNotificationsController::class, 'index'])->name('user.notifications.index'); // show notification list

    Route::get('orders', [UserOrdersController::class, 'index'])->name('user.orders.index'); // show orders list
    Route::get('orders/{order}', [UserOrdersController::class, 'show'])->name('user.orders.show'); // show order details
    Route::get('orders/{order}/sales-factor', [UserOrdersController::class, 'sales_factor'])->name('user.orders.sales_factor'); // order sales factor

    Route::resource('addresses', AddressesController::class)->names('user.addresses'); // addresses Resources
    Route::post('address/{address}/change', [AddressesController::class, 'change'])->name('user.addresses.change'); // change active address

    Route::get('transactions', [UserTransactionsController::class, 'index'])->name('user.transactions.index'); // transactions list

    Route::get('prefactors', [UserPrefactorsController::class, 'index'])->name('user.prefactor.index'); // prefactor list

    Route::get('favorites', [UserFavoritesController::class, 'index'])->name('user.favorites.index'); // favorites list

    Route::get('comments', [UserCommentsController::class, 'index'])->name('user.comments.index'); // comments list

    Route::get('history', [UserHistoryController::class, 'index'])->name('user.history.index'); // history list

    Route::get('customer-club/scores', [CustomerClubController::class, 'scores'])->name('user.customer_club.scores'); // customer club scores

    Route::get('wallet', [WalletController::class, 'index'])->name('user.wallet.index'); // wallet page
    Route::post('wallet/charge', [WalletController::class, 'charge'])->name('user.wallet.charge'); // wallet charge
    Route::post('wallet/withdrawal/add', [WalletController::class, 'add_withdrawal'])->name('user.wallet.add_withdrawal'); // add withdrawal
    Route::delete('wallet/withdrawal/{withdrawal}/delete', [WalletController::class, 'delete_withdrawal'])->name('user.wallet.delete_withdrawal'); // delete withdrawal

    Route::post('wallet/bank/card/add', [WalletController::class, 'add_bank_card'])->name('user.wallet.add_bank_card'); // wallet add bank card
    Route::delete('wallet/bank/card/{bankCard}/delete', [WalletController::class, 'delete_bank_card'])->name('user.wallet.delete_bank_card'); // wallet add bank card
});

/** Seller Registration */
Route::prefix('auth/seller')->middleware(['auth'])->group(function () {
    Route::get('register', [RegisterController::class, 'register'])->name('seller.register'); // register
    Route::post('register/submit', [RegisterController::class, 'submit'])->name('seller.register.submit'); // register
});

/** Seller Panel Routes */
Route::prefix('seller')->middleware(['auth', 'seller', 'readonly.owner'])->group(function () {
    Route::get('dashboard', [StoreDashboardController::class, 'index'])->name('seller.dashboard'); // dashboard

    Route::get('profile/sessions', [StoreProfileController::class, 'sessions'])->name('seller.profile.sessions'); // current user profile active sessions
    Route::delete('profile/sessions/terminate', [StoreProfileController::class, 'terminate'])->name('seller.profile.sessions.terminate'); // terminate user session
    Route::get('profile/edit', [StoreProfileController::class, 'edit'])->name('seller.profile.edit'); // show profile edit page
    Route::put('profile/update', [StoreProfileController::class, 'update'])->name('seller.profile.update'); // update profile

    Route::get('notifications', [StoreNotificationsController::class, 'index'])->name('seller.notifications.index'); // show notification list

    Route::resource('files', StoreFilesController::class)->names('seller.files'); // files Resources

    Route::get('information/edit', [InformationsController::class, 'edit'])->name('seller.information.edit'); // show information edit page
    Route::post('information/update', [InformationsController::class, 'update'])->name('seller.information.update'); // update information

    Route::resource('tickets', StoreTicketsController::class)->names('seller.tickets'); // tickets Resources
    Route::post('ticket/{ticket}/answer', [StoreTicketsController::class, 'answer'])->name('seller.tickets.answer'); // send ticket answer
    Route::post('ticket/{ticket}/attachment', [StoreTicketsController::class, 'attachment'])->name('seller.tickets.attachment'); // send ticket attachment answer

    Route::get('transactions', [StoreTransactionsController::class, 'index'])->name('seller.transactions.index'); // transactions list

    Route::get('pending-payments', [StorePendingPaymentsController::class, 'index'])->name('seller.pending_payments.index')->middleware('can:seller-access'); // pending payment list

    Route::get('transportation', [StoreTransportationController::class, 'index'])->name('seller.transportation.index'); // transportation
    Route::put('transportation/update', [StoreTransportationController::class, 'update'])->name('seller.transportation.update'); // update transportation

    Route::resource('products', StoreProductsController::class)->names('seller.products')->middleware('can:seller-access'); // products Resources
    Route::post('product/{product}/add', [StoreProductsController::class, 'add'])->name('seller.products.add')->middleware('can:seller-access'); // products Resources
    Route::post('product/{product}/delete', [StoreProductsController::class, 'delete'])->name('seller.products.delete')->middleware('can:seller-access'); // products Resources
    Route::get('brand/search', [StoreProductsController::class, 'searchBrand'])->name('seller.brands.search')->middleware('can:seller-access'); // brands search json

    Route::get('product/questions', [StoreQuestionsController::class, 'index'])->name('seller.questions.index')->middleware('can:seller-access'); // questions list
    Route::post('product/questions/{question}/accept', [StoreQuestionsController::class, 'question_accept'])->name('seller.questions.accept')->middleware('can:seller-access'); // question accept
    Route::delete('product/questions/{question}/delete', [StoreQuestionsController::class, 'question_delete'])->name('seller.questions.delete')->middleware('can:seller-access'); // question delete
    Route::post('product/questions/answer/{answer}/accept', [StoreQuestionsController::class, 'answer_accept'])->name('seller.questions.answers.accept')->middleware('can:seller-access'); // question accept
    Route::post('product/questions/{question}/send-answer', [StoreQuestionsController::class, 'answer_send'])->name('seller.questions.answers.send')->middleware('can:seller-access'); // question send answer
    Route::delete('product/questions/answer/{answer}/delete-answer', [StoreQuestionsController::class, 'answer_delete'])->name('seller.questions.answers.delete')->middleware('can:seller-access'); // question delete answer

    Route::resource('storages', StoreStorageController::class)->names('seller.storages')->middleware('can:seller-access'); // storages Resources
    Route::get('storage/{storage}/inventories/{product}/list', [StoreStorageController::class, 'storageList'])->name('seller.storages.storageList')->middleware('can:seller-access'); // storage inventories index
    Route::get('storage/{storage}/export', [StoreStorageController::class, 'export'])->name('seller.storages.export')->middleware('can:seller-access'); // storage export
    Route::post('storage/{storage}/import', [StoreStorageController::class, 'import'])->name('seller.storages.import')->middleware('can:seller-access'); // storage import

    Route::resource('inventories', StoreInventoryController::class)->names('seller.inventories')->middleware('can:seller-access')->except(['index']); // inventories Resources
    Route::get('inventories/{product}/list', [StoreInventoryController::class, 'index'])->name('seller.inventories.index')->middleware('can:seller-access'); // inventories index
    Route::post('inventory/{inventory}/decrease', [StoreInventoryController::class, 'decrease'])->name('seller.inventories.decrease')->middleware('can:seller-access'); // decrease inventory

    Route::resource('articles', StoreArticlesController::class)->names('seller.articles')->middleware('can:seller-access'); // articles Resources

    Route::get('brand/search', [StoreArticlesController::class, 'searchBrand'])->name('seller.brands.search')->middleware('can:seller-access'); // brands search json

    Route::get('wallet', [StoreWalletController::class, 'index'])->name('seller.wallet.index'); // wallet page
    Route::get('wallet/withdrawals', [StoreWalletController::class, 'withdrawals'])->name('seller.wallet.withdrawals'); // wallet withdrawals page
    Route::post('wallet/charge', [StoreWalletController::class, 'charge'])->name('seller.wallet.charge'); // wallet charge
    Route::get('wallet/charge/callback', [StoreWalletController::class, 'callback_get'])->name('seller.wallet.charge.callback_get'); // wallet charge callback
    Route::post('wallet/charge/callback', [StoreWalletController::class, 'callback_post'])->name('seller.wallet.charge.callback_post'); // wallet charge callback
    Route::post('wallet/withdrawal/add', [StoreWalletController::class, 'add_withdrawal'])->name('seller.wallet.add_withdrawal'); // add withdrawal
    Route::delete('wallet/withdrawal/{withdrawal}/delete', [StoreWalletController::class, 'delete_withdrawal'])->name('seller.wallet.delete_withdrawal'); // delete withdrawal

    Route::post('wallet/bank/card/add', [StoreWalletController::class, 'add_bank_card'])->name('seller.wallet.add_bank_card'); // wallet add bank card
    Route::delete('wallet/bank/card/{bankCard}/delete', [StoreWalletController::class, 'delete_bank_card'])->name('seller.wallet.delete_bank_card'); // wallet add bank card

    Route::get('consignment/{consignment}', [StoreOrdersController::class, 'show'])->name('seller.orders.show')->middleware('can:seller-access'); // show order details
    Route::post('consignment/{consignment_item}/cancel-item', [StoreOrdersController::class, 'cancel_item'])->name('seller.orders.cancel_item')->middleware('can:seller-access'); // cancel consignment item
    Route::post('consignment/{consignment}/change-status', [StoreOrdersController::class, 'change_status'])->name('seller.orders.change_status')->middleware('can:seller-access'); // schange consignment status
    Route::get('consignments/awaiting', [StoreOrdersController::class, 'awaiting'])->name('seller.orders.awaiting')->middleware('can:seller-access'); // awaiting orders
    Route::get('consignments/sent', [StoreOrdersController::class, 'sent'])->name('seller.orders.sent')->middleware('can:seller-access'); // sent orders
    Route::get('consignments/delivered', [StoreOrdersController::class, 'delivered'])->name('seller.orders.delivered')->middleware('can:seller-access'); // delivered orders
    Route::get('consignments/cancelled', [StoreOrdersController::class, 'cancelled'])->name('seller.orders.cancelled')->middleware('can:seller-access'); // cancelled orders

    Route::get('consignments/{consignment}/sales-factor', [StoreOrdersController::class, 'sales_factor'])->name('seller.orders.sales_factor')->middleware('can:seller-access'); // order sales factor
    Route::get('consignments/{consignment}/thermal-sales-factor', [StoreOrdersController::class, 'thermal_sales_factor'])->name('seller.orders.thermal_sales_factor')->middleware('can:seller-access'); // order sales factor
});

/** Admin Panel Routes */
Route::prefix('admin')->middleware(['auth', 'admin', 'readonly.owner'])->group(function () {
    Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard'); // dashboard

    Route::get('reports', [ReportsController::class, 'index'])->name('admin.reports.index')->middleware('can:show-reports'); // user actions report list

    Route::get('statistics/tracking-view', [StatisticsController::class, 'tracking_view'])->name('admin.statistics.tracking_view')->middleware('can:show-statistics'); // all statistics
    Route::get('statistics/view-chart', [StatisticsController::class, 'view_chart'])->name('admin.statistics.view_chart')->middleware('can:show-statistics'); // view charts
    Route::get('statistics/products', [StatisticsController::class, 'products'])->name('admin.statistics.products')->middleware('can:show-statistics'); // view charts
    Route::get('statistics/articles', [StatisticsController::class, 'articles'])->name('admin.statistics.articles')->middleware('can:show-statistics'); // view charts
    Route::get('statistics/financial', [StatisticsController::class, 'financial'])->name('admin.statistics.financial')->middleware('can:show-statistics'); // view charts

    Route::resource('users', UsersController::class)->names('admin.users')->middleware('can:manage-users'); // Users Resources
    Route::resource('roles', RolesController::class)->names('admin.roles')->middleware('owner'); // Roles Resources
    Route::get('admin/list', [RolesController::class, 'adminList'])->name('admin.admin.list')->middleware('owner'); // admin lists
    Route::post('admin/promote/{user}', [RolesController::class, 'promote'])->name('admin.admin.promote')->middleware('owner'); // promote to admin
    Route::post('admin/demote/{user}', [RolesController::class, 'demote'])->name('admin.admin.demote')->middleware('owner'); // promote to admin
    Route::put('user/{user}/wallet/update', [UsersController::class, 'walletUpdate'])->name('admin.users.wallet.update')->middleware('owner'); // edit user wallet by owner
    Route::put('user/{user}/score/update', [UsersController::class, 'scoreUpdate'])->name('admin.users.score.update')->middleware('owner'); // edit user wallet by owner
    Route::get('user/all/export', [UsersController::class, 'export'])->name('admin.users.export')->middleware('can:manage-users'); // storage export
    Route::prefix('user/cart')->middleware('can:manage-users')->group(function () {
        Route::post('/{user}/add', [UsersController::class, 'cart_add'])->name('admin.users.cart.add'); // add to cart
        Route::post('/{user}/delete', [UsersController::class, 'cart_delete'])->name('admin.users.cart.delete'); // delete from cart
        Route::post('/{user}/increase', [UsersController::class, 'cart_increase'])->name('admin.users.cart.increase'); // increase cart count
        Route::post('/{user}/decrease', [UsersController::class, 'cart_decrease'])->name('admin.users.cart.decrease'); // decrease cart count
    });
    Route::post('user/p/{uuid}', [UsersController::class, 'product_inventory'])->name('admin.users.product_inventory'); // get product inventory
    Route::post('user/{phone}/json', [UsersController::class, 'user_json'])->name('admin.users.user_json'); // get user json data

    Route::get('profile/sessions', [ProfileController::class, 'sessions'])->name('admin.profile.sessions'); // current user profile active sessions
    Route::delete('profile/sessions/terminate', [ProfileController::class, 'terminate'])->name('admin.profile.sessions.terminate'); // terminate user session
    Route::get('profile/edit', [ProfileController::class, 'edit'])->name('admin.profile.edit'); // show profile edit page
    Route::put('profile/update', [ProfileController::class, 'update'])->name('admin.profile.update'); // update profile

    Route::resource('files', FilesController::class)->names('admin.files'); // files Resources

    Route::get('notifications', [NotificationsController::class, 'index'])->name('admin.notifications.index'); // show notification list

    Route::get('settings/edit', [SettingsController::class, 'edit'])->name('admin.settings.edit')->middleware('can:change-settings'); // show settings edit page
    Route::put('settings/update', [SettingsController::class, 'update'])->name('admin.settings.update')->middleware('can:change-settings'); // update settings
    Route::get('settings/license', [SettingsController::class, 'license'])->name('admin.settings.license')->middleware('can:change-settings'); // license
    Route::post('settings/check', [SettingsController::class, 'check'])->name('admin.settings.check')->middleware('can:change-settings'); // check

    Route::resource('menus', MenusController::class)->names('admin.menus')->middleware('can:manage-menus'); // menus Resources

    Route::resource('products', ProductsController::class)->names('admin.products')->middleware('can:manage-products'); // products Resources
    Route::get('product/trash/list', [ProductsController::class, 'trash'])->name('admin.products.trash')->middleware('can:manage-products'); // products Resources
    Route::post('product/action/{product}/check', [ProductsController::class, 'check'])->name('admin.products.check')->middleware('can:manage-products'); // products Resources
    Route::post('product/import/digikala', [ProductsController::class, 'import_digikala'])->name('admin.products.import.digikala')->middleware('can:manage-products'); // products Resources
    Route::post('product/{product}/clone', [ProductsController::class, 'clone'])->name('admin.products.clone')->middleware('can:manage-products'); // products Resources
    Route::get('product/export', [ProductsController::class, 'export'])->name('admin.products.export')->middleware('can:manage-products'); // storage export
    Route::post('product/import', [ProductsController::class, 'import'])->name('admin.products.import')->middleware('can:manage-products'); // storage import

    Route::resource('storages', StorageController::class)->names('admin.storages')->middleware('can:manage-storages'); // storages Resources
    Route::get('storage/{storage}/inventories/{product}/list', [StorageController::class, 'storageList'])->name('admin.storages.storageList')->middleware('can:manage-storages'); // storage inventories index
    Route::get('storage/{storage}/export', [StorageController::class, 'export'])->name('admin.storages.export')->middleware('can:manage-storages'); // storage export
    Route::post('storage/{storage}/import', [StorageController::class, 'import'])->name('admin.storages.import')->middleware('can:manage-storages'); // storage import

    Route::resource('inventories', InventoryController::class)->names('admin.inventories')->middleware('can:manage-storages')->except(['index']); // inventories Resources
    Route::get('inventories/{product}/list', [InventoryController::class, 'index'])->name('admin.inventories.index')->middleware('can:manage-storages'); // inventories index
    Route::post('inventory/{inventory}/decrease', [InventoryController::class, 'decrease'])->name('admin.inventories.decrease')->middleware('can:manage-storages'); // decrease inventory
    Route::post('inventory/{inventory}/status', [InventoryController::class, 'status'])->name('admin.inventories.status')->middleware('can:manage-storages'); // change inventory status

    Route::resource('product/categories', ProductCategoriesController::class)->names('admin.product.categories')->middleware('can:manage-product-categories'); // product_categories Resources
    Route::get('product/category/add/{category_id?}', [ProductCategoriesController::class, 'add'])->name('admin.product.categories.add')->middleware('can:manage-product-categories'); // add product categories with param

    Route::resource('product/tags', ProductTagsController::class)->names('admin.product.tags')->middleware('can:manage-products'); // product tags Resources

    Route::resource('product/colors', ColorController::class)->names('admin.product.colors')->middleware('can:manage-products'); // product colors Resources

    Route::get('product/comments', [CommentsController::class, 'index'])->name('admin.product.comments.index')->middleware('can:manage-product-comments'); // product comment list
    Route::post('product/comment/{comment}/accept', [CommentsController::class, 'accept'])->name('admin.product.comments.accept')->middleware('can:manage-product-comments'); // product comment accept
    Route::post('product/comment/{comment}/remove-report', [CommentsController::class, 'remove_report'])->name('admin.product.comments.remove_report')->middleware('can:manage-product-comments'); // product comment remove report
    Route::delete('product/comment/{comment}/delete', [CommentsController::class, 'delete'])->name('admin.product.comments.delete')->middleware('can:manage-product-comments'); // product comment delete
    Route::post('product/comment/{comment}/send-answer', [CommentsController::class, 'send_answer'])->name('admin.product.comments.send_answer')->middleware('can:manage-product-comments'); // product comment send answer
    Route::delete('product/comment/{comment}/delete-answer', [CommentsController::class, 'delete_answer'])->name('admin.product.comments.delete_answer')->middleware('can:manage-product-comments'); // product comment delete answer
    Route::put('product/comment/{comment}/edit', [CommentsController::class, 'edit'])->name('admin.product.comments.edit')->middleware('can:manage-product-comments'); // product comment edit

    Route::get('product/questions', [QuestionsController::class, 'index'])->name('admin.questions.index')->middleware('can:manage-product-questions'); // questions list
    Route::post('product/questions/{question}/accept', [QuestionsController::class, 'question_accept'])->name('admin.questions.accept')->middleware('can:manage-product-questions'); // question accept
    Route::delete('product/questions/{question}/delete', [QuestionsController::class, 'question_delete'])->name('admin.questions.delete')->middleware('can:manage-product-questions'); // question delete
    Route::post('product/questions/answer/{answer}/accept', [QuestionsController::class, 'answer_accept'])->name('admin.questions.answers.accept')->middleware('can:manage-product-questions'); // question accept
    Route::post('product/questions/{question}/send-answer', [QuestionsController::class, 'answer_send'])->name('admin.questions.answers.send')->middleware('can:manage-product-questions'); // question send answer
    Route::delete('product/questions/answer/{answer}/delete-answer', [QuestionsController::class, 'answer_delete'])->name('admin.questions.answers.delete')->middleware('can:manage-product-questions'); // question delete answer

    Route::resource('brands', BrandsController::class)->names('admin.brands')->middleware('can:manage-brands'); // brands Resources
    Route::get('brands/trash/list', [BrandsController::class, 'trash'])->name('admin.brands.trash')->middleware('can:manage-brands'); // brands Resources
    Route::get('brand/search', [BrandsController::class, 'searchBrand'])->name('admin.brands.search'); // brands search json

    Route::resource('stories', StoriesController::class)->names('admin.stories')->middleware('can:manage-stories'); // stories Resources
    Route::post('story/status', [StoriesController::class, 'status'])->name('admin.stories.status')->middleware('can:manage-stories'); // on/off stories

    Route::resource('tickets', TicketsController::class)->names('admin.tickets')->middleware('can:manage-tickets'); //tickets Resources
    Route::post('ticket/{ticket}/answer', [TicketsController::class, 'answer'])->name('admin.tickets.answer')->middleware('can:manage-tickets'); // send ticket answer
    Route::post('ticket/{ticket}/attachment', [TicketsController::class, 'attachment'])->name('admin.tickets.attachment')->middleware('can:manage-tickets'); // send ticket attachment answer

    Route::get('transactions', [TransactionsController::class, 'index'])->name('admin.transactions.index')->middleware('can:manage-transactions'); // transactions list
    Route::get('transactions/sellers', [TransactionsController::class, 'sellers'])->name('admin.transactions.sellers')->middleware('can:manage-transactions'); // sellers transactions list
    Route::get('transactions/affiliates', [TransactionsController::class, 'affiliates'])->name('admin.transactions.affiliates')->middleware('can:manage-transactions'); // affiliates transactions list

    Route::get('pending-payments', [PendingPaymentsController::class, 'index'])->name('admin.pending_payments.index')->middleware('can:manage-transactions'); // pending payment list
    Route::post('pending-payments/{pending_payment}/pay', [PendingPaymentsController::class, 'pay'])->name('admin.pending_payments.pay')->middleware('can:manage-transactions'); // pending payment pay

    Route::get('withdrawals', [WithdrawalsController::class, 'index'])->name('admin.withdrawals.index')->middleware('can:manage-transactions'); // withdrawals list
    Route::post('withdrawals/{withdrawal}/deposited', [WithdrawalsController::class, 'deposited'])->name('admin.withdrawals.deposited')->middleware('can:manage-transactions'); // withdrawals list
    Route::delete('withdrawals/{withdrawal}/delete', [WithdrawalsController::class, 'delete'])->name('admin.withdrawals.delete')->middleware('can:manage-transactions'); // withdrawals list

    Route::resource('prefactors', PrefactorsController::class)->names('admin.prefactors')->middleware('can:manage-prefactors'); // prefactors Resources
    Route::prefix('prefactor/order')->middleware('can:manage-prefactors')->group(function () {
        Route::post('/{prefactor}/add', [PrefactorsController::class, 'prefactor_add'])->name('admin.prefactor.add'); // add to prefactor
        Route::post('/{prefactor}/delete', [PrefactorsController::class, 'prefactor_delete'])->name('admin.prefactor.delete'); // delete from prefactor
        Route::post('/{prefactor}/increase', [PrefactorsController::class, 'prefactor_increase'])->name('admin.prefactor.increase'); // increase prefactor count
        Route::post('/{prefactor}/decrease', [PrefactorsController::class, 'prefactor_decrease'])->name('admin.prefactor.decrease'); // decrease prefactor count
        Route::post('/{prefactor}/add-discount', [PrefactorsController::class, 'add_discount'])->name('admin.prefactor.add_discount'); // add discount
        Route::delete('/{prefactor}/delete-discount', [PrefactorsController::class, 'delete_discount'])->name('admin.prefactor.delete_discount'); // delete discount
        Route::post('/{prefactor}/issuance', [PrefactorsController::class, 'issuance'])->name('admin.prefactor.issuance'); // issuance prefactor
    });

    Route::resource('templates', TemplatesController::class)->names('admin.templates')->middleware('can:manage-template'); // templates Resources
    Route::post('template/{template}/switch', [TemplatesController::class, 'switch'])->name('admin.templates.switch')->middleware('can:manage-template'); // switch template

    Route::resource('stores', StoresController::class)->names('admin.stores')->middleware('can:manage-stores'); // stores Resources
    Route::post('store/{store}/change', [StoresController::class, 'change'])->name('admin.stores.change')->middleware('can:manage-stores'); // stores awaiting list
    Route::post('store/{store}/direct-post-status', [StoresController::class, 'direct_post_status'])->name('admin.stores.direct_post_status')->middleware('can:manage-stores'); // stores awaiting list
    Route::post('store/add-seller', [StoresController::class, 'add_seller'])->name('admin.stores.add_seller')->middleware('can:manage-stores'); // stores awaiting list

    Route::get('store/awaiting', [StoresController::class, 'awaiting_stores'])->name('admin.stores.awaiting')->middleware('can:manage-stores'); // stores awaiting list
    Route::get('product/awaiting', [StoresController::class, 'awaiting_products'])->name('admin.stores.products.awaiting')->middleware('can:manage-products'); // stores awaiting products
    Route::get('inventory/awaiting', [StoresController::class, 'awaiting_inventories'])->name('admin.stores.inventories.awaiting')->middleware('can:manage-products'); // stores awaiting inventories
    Route::get('article/awaiting', [StoresController::class, 'awaiting_articles'])->name('admin.stores.articles.awaiting')->middleware('can:manage-articles'); // stores awaiting articles

    Route::get('payment/meta', [PaymentMetaController::class, 'index'])->name('admin.payments.meta.index')->middleware('can:manage-orders'); // show payment meta
    Route::put('payment/meta/update', [PaymentMetaController::class, 'update'])->name('admin.payments.meta.update')->middleware('can:manage-orders'); // update payment meta
    Route::post('payment/meta/address/store', [PaymentMetaController::class, 'address_store'])->name('admin.addresses.store')->middleware('can:manage-orders'); // store address
    Route::put('payment/meta/address/{id}/update', [PaymentMetaController::class, 'address_update'])->name('admin.addresses.update')->middleware('can:manage-orders'); // update address
    Route::delete('payment/meta/address/{id}/destroy', [PaymentMetaController::class, 'address_destroy'])->name('admin.addresses.destroy')->middleware('can:manage-orders'); // delete address

    Route::resource('discounts', DiscountController::class)->names('admin.discounts')->middleware('can:manage-discounts'); // discounts Resources

    Route::resource('pages', PagesController::class)->names('admin.pages')->middleware('can:manage-pages'); // pages Resources

    Route::resource('forms', FormsController::class)->names('admin.forms')->middleware('can:manage-forms'); // forms Resources
    Route::delete('form/{form}/answer/{answer}/destroy', [FormsController::class, 'answer_destroy'])->name('admin.forms.answer.destroy')->middleware('can:manage-forms'); // remove form answer

    Route::resource('articles', ArticlesController::class)->names('admin.articles')->middleware('can:manage-articles'); // articles Resources
    Route::get('article/trash/list', [ArticlesController::class, 'trash'])->name('admin.articles.trash')->middleware('can:manage-articles'); // articles Resources
    Route::post('article/action/{article}/check', [ArticlesController::class, 'check'])->name('admin.articles.check')->middleware('can:manage-articles'); // articles accept or reject

    Route::resource('article/categories', ArticleCategoriesController::class)->names('admin.article.categories')->middleware('can:manage-article-categories'); // article categories Resources

    Route::resource('article/tags', ArticleTagsController::class)->names('admin.article.tags')->middleware('can:manage-articles'); // article tags Resources

    Route::get('article/comments', [ArticleCommentsController::class, 'index'])->name('admin.article.comments.index')->middleware('can:manage-article-comments'); // article comment list
    Route::post('article/comment/{comment}/accept', [ArticleCommentsController::class, 'accept'])->name('admin.article.comments.accept')->middleware('can:manage-article-comments'); // article comment accept
    Route::delete('article/comment/{comment}/delete', [ArticleCommentsController::class, 'delete'])->name('admin.article.comments.delete')->middleware('can:manage-article-comments'); // article comment delete
    Route::post('article/{article}/comment/{comment}/send-answer', [ArticleCommentsController::class, 'send_answer'])->name('admin.article.comments.send_answer')->middleware('can:manage-article-comments'); // article comment send answer
    Route::put('article/comment/{comment}/edit', [ArticleCommentsController::class, 'edit'])->name('admin.article.comments.edit')->middleware('can:manage-article-comments'); // article comment edit

    Route::get('affiliate/products', [AffiliatesController::class, 'products'])->name('admin.affiliate.products')->middleware('can:manage-affiliate'); // affiliate product list
    Route::post('affiliate/{product}/add', [AffiliatesController::class, 'add'])->name('admin.affiliate.add')->middleware('can:manage-affiliate'); // add product to affiliate
    Route::delete('affiliate/{product}/delete', [AffiliatesController::class, 'delete'])->name('admin.affiliate.delete')->middleware('can:manage-affiliate'); // delete product from affiliate

    Route::get('order/{order}', [OrdersController::class, 'show'])->name('admin.orders.show')->middleware('can:manage-orders'); // show order details
    Route::get('order/{order}/send-sticker', [OrdersController::class, 'send_sticker'])->name('admin.orders.send_sticker')->middleware('can:manage-orders'); // show order send sticker
    Route::post('order/consignment/{consignment}/request-from-seller', [OrdersController::class, 'request_from_seller'])->name('admin.orders.request_from_seller')->middleware('can:manage-orders'); // request consignment from seller
    Route::post('order/consignment/{consignment}/cancel-request-from-seller', [OrdersController::class, 'cancel_request_from_seller'])->name('admin.orders.cancel_request_from_seller')->middleware('can:manage-orders'); //  cancel request consignment from seller
    Route::post('order/consignment/{consignment}/received-from-seller', [OrdersController::class, 'received_from_seller'])->name('admin.orders.received_from_seller')->middleware('can:manage-orders'); // consignment item received from seller
    Route::post('order/consignment-item/{consignment_item}/cancel-item', [OrdersController::class, 'cancel_item'])->name('admin.orders.cancel_item')->middleware('can:manage-orders'); // cancel consignment item
    Route::post('order/consignment-item/{consignment_item}/return-item', [OrdersController::class, 'return_item'])->name('admin.orders.return_item')->middleware('can:manage-orders'); // return consignment item
    Route::post('order/{order}/change-status', [OrdersController::class, 'change_status'])->name('admin.orders.change_status')->middleware('can:manage-orders'); // change order status
    Route::get('orders/processing', [OrdersController::class, 'processing'])->name('admin.orders.processing')->middleware('can:manage-orders'); // processing orders
    Route::get('orders/completed', [OrdersController::class, 'completed'])->name('admin.orders.completed')->middleware('can:manage-orders'); // completed orders

    Route::get('orders/{order}/sales-factor', [OrdersController::class, 'sales_factor'])->name('admin.orders.sales_factor')->middleware('can:manage-orders'); // order sales factor
    Route::get('orders/{order}/thermal-sales-factor', [OrdersController::class, 'thermal_sales_factor'])->name('admin.orders.thermal_sales_factor')->middleware('can:manage-orders'); // order sales factor

    Route::get('faq', [FaqController::class, 'index'])->name('admin.faq.index')->middleware('can:change-settings'); // faq list
    Route::post('faq/update', [FaqController::class, 'update'])->name('admin.faq.update')->middleware('can:change-settings'); // update faq list

    Route::get('updater', [UpdaterController::class, 'index'])->name('admin.updater.index')->middleware('owner'); // updater index
    Route::post('updater/upload', [UpdaterController::class, 'upload'])->name('admin.updater.upload')->middleware('owner'); // updater index
    Route::post('updater/update', [UpdaterController::class, 'update'])->name('admin.updater.update')->middleware('owner'); // updater index
    Route::delete('updater/delete', [UpdaterController::class, 'delete'])->name('admin.updater.delete')->middleware('owner'); // updater index

    Route::get('newsletters', [NewslettersController::class, 'index'])->name('admin.newsletters.index')->middleware('can:manage-newsletters'); // manage newsletters index
    Route::delete('newsletter/{newsletter}/destroy', [NewslettersController::class, 'destroy'])->name('admin.newsletters.destroy')->middleware('can:manage-newsletters'); // manage newsletters index
    Route::get('newsletter/export', [NewslettersController::class, 'export'])->name('admin.newsletters.export')->middleware('can:manage-newsletters'); // manage newsletters index

    Route::get('searches', [SearchesController::class, 'index'])->name('admin.searches.index')->middleware('can:manage-products'); // searches list
    Route::delete('search/{search}/destroy', [SearchesController::class, 'destroy'])->name('admin.searches.destroy')->middleware('can:manage-products'); // delete search

    Route::get('web-service', [WebServiceController::class, 'index'])->name('admin.web_service.index')->middleware('owner'); // searches list
    Route::post('web-service/refresh-key', [WebServiceController::class, 'refresh_key'])->name('admin.web_service.refresh_key')->middleware('owner'); // searches list
    Route::delete('web-service/delete-key', [WebServiceController::class, 'delete_key'])->name('admin.web_service.delete_key')->middleware('owner'); // searches list
});

/** common auth routes */
Route::middleware(['auth'])->group(function () {
    Route::get('error/banned', [UserDashboardController::class, 'banned'])->name('error.banned'); // bannde user
});

/** change theme mode */
Route::post('/theme/mode', [Controller::class, 'themeMode'])->name('theme.mode'); // change theme mode

/** change theme lang */
Route::post('/locale', [Controller::class, 'locale'])->name('locale');

/** public routes */
Route::get('/media/private/{file}', [PrivateMediaController::class, 'index'])->name('private_media')->middleware('auth'); // show private media

require __DIR__ . '/auth.php';
