import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import vue from "@vitejs/plugin-vue";
import i18n from "laravel-vue-i18n/vite";

export default defineConfig({
    build: {
        chunkSizeWarningLimit: 4000,
    },
    ssr: {
        noExternal: ["@inertiajs/server"],
    },
    plugins: [
        laravel({
            //hotFile: "../public_html/hot",
            input: "resources/js/app.ts",
            ssr: "resources/js/ssr.ts",
            refresh: true,
        }),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
                compilerOptions: {
                    isCustomElement: (tag) => tag === "model-viewer",
                },
            },
        }),
        i18n(),
    ],
});
